/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.util.ArrayList;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;

public final class IndexedFileHashedArray {
    private IndexedFile[] elements;
    private int elementSize;
    private int threshold;
    private int lastId;
    private ArrayList replacedElements;

    public IndexedFileHashedArray(int n) {
        if (n < 7) {
            n = 7;
        }
        this.elements = new IndexedFile[2 * n + 1];
        this.elementSize = 0;
        this.threshold = n + 1;
        this.lastId = 0;
        this.replacedElements = null;
    }

    public IndexedFile add(IDocument iDocument) {
        return this.add(new IndexedFile(iDocument, ++this.lastId));
    }

    private IndexedFile add(IndexedFile indexedFile) {
        IndexedFile indexedFile2;
        int n = this.elements.length;
        String string = indexedFile.getPath();
        int n2 = (string.hashCode() & Integer.MAX_VALUE) % n;
        while ((indexedFile2 = this.elements[n2]) != null) {
            if (indexedFile2.getPath().equals(string)) {
                if (this.replacedElements == null) {
                    this.replacedElements = new ArrayList(5);
                }
                this.replacedElements.add(indexedFile2);
                this.elements[n2] = indexedFile;
                return this.elements[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.elements[n2] = indexedFile;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return indexedFile;
    }

    public IndexedFile[] asArray() {
        IndexedFile indexedFile;
        IndexedFile[] indexedFileArray = new IndexedFile[this.lastId];
        int n = 0;
        int n2 = this.elements.length;
        while (n < n2) {
            indexedFile = this.elements[n];
            if (indexedFile != null) {
                indexedFileArray[indexedFile.fileNumber - 1] = indexedFile;
            }
            ++n;
        }
        if (this.replacedElements != null) {
            n = 0;
            n2 = this.replacedElements.size();
            while (n < n2) {
                indexedFileArray[indexedFile.fileNumber - 1] = indexedFile = (IndexedFile)this.replacedElements.get(n);
                ++n;
            }
        }
        return indexedFileArray;
    }

    public IndexedFile get(String string) {
        IndexedFile indexedFile;
        int n = this.elements.length;
        int n2 = (string.hashCode() & Integer.MAX_VALUE) % n;
        while ((indexedFile = this.elements[n2]) != null) {
            if (indexedFile.getPath().equals(string)) {
                return indexedFile;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void grow() {
        IndexedFileHashedArray indexedFileHashedArray = new IndexedFileHashedArray(this.elementSize * 2);
        int n = 0;
        int n2 = this.elements.length;
        while (n < n2) {
            if (this.elements[n] != null) {
                indexedFileHashedArray.add(this.elements[n]);
            }
            ++n;
        }
        this.elements = indexedFileHashedArray.elements;
        this.elementSize = indexedFileHashedArray.elementSize;
        this.threshold = indexedFileHashedArray.threshold;
    }

    public int size() {
        return this.elementSize + (this.replacedElements == null ? 0 : this.replacedElements.size());
    }

    public String toString() {
        String string = "";
        IndexedFile[] indexedFileArray = this.asArray();
        int n = 0;
        int n2 = indexedFileArray.length;
        while (n < n2) {
            string = String.valueOf(string) + indexedFileArray[n].toString() + "\n";
            ++n;
        }
        return string;
    }
}

