/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.InputStream;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class CModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected ICElement[] fElementsToProcess;
    protected ICElement[] fParentElements;
    protected static ICElement[] fgEmptyResult = new ICElement[0];
    protected ICElementDelta[] fDeltas = null;
    protected ICElement[] fResultElements = fgEmptyResult;
    protected IProgressMonitor fMonitor = null;
    protected boolean fNested = false;
    protected boolean fForce = false;
    protected boolean hasModifiedResource = false;

    protected CModelOperation() {
    }

    protected CModelOperation(ICElement[] iCElementArray) {
        this.fElementsToProcess = iCElementArray;
    }

    protected CModelOperation(ICElement[] iCElementArray, ICElement[] iCElementArray2) {
        this.fElementsToProcess = iCElementArray;
        this.fParentElements = iCElementArray2;
    }

    protected CModelOperation(ICElement[] iCElementArray, ICElement[] iCElementArray2, boolean bl) {
        this.fElementsToProcess = iCElementArray;
        this.fParentElements = iCElementArray2;
        this.fForce = bl;
    }

    protected CModelOperation(ICElement[] iCElementArray, boolean bl) {
        this.fElementsToProcess = iCElementArray;
        this.fForce = bl;
    }

    protected CModelOperation(ICElement iCElement) {
        this.fElementsToProcess = new ICElement[]{iCElement};
    }

    protected CModelOperation(ICElement iCElement, boolean bl) {
        this.fElementsToProcess = new ICElement[]{iCElement};
        this.fForce = bl;
    }

    protected void addDelta(ICElementDelta iCElementDelta) {
        if (this.fDeltas == null) {
            this.fDeltas = new ICElementDelta[]{iCElementDelta};
        } else {
            ICElementDelta[] iCElementDeltaArray = new ICElementDelta[this.fDeltas.length + 1];
            System.arraycopy(this.fDeltas, 0, iCElementDeltaArray, 0, this.fDeltas.length);
            iCElementDeltaArray[this.fDeltas.length] = iCElementDelta;
            this.fDeltas = iCElementDeltaArray;
        }
    }

    public void beginTask(String string, int n) {
        if (this.fMonitor != null) {
            this.fMonitor.beginTask(string, n);
        }
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException("operation.cancelled");
        }
    }

    protected ICModelStatus commonVerify() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return new CModelStatus(968);
        }
        int n = 0;
        while (n < this.fElementsToProcess.length) {
            if (this.fElementsToProcess[n] == null) {
                return new CModelStatus(968);
            }
            ++n;
        }
        return CModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] iResourceArray, IPath iPath) throws CModelException {
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(iResourceArray.length);
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.copy(iResourceArray, iPath, false, iProgressMonitor);
            this.hasModifiedResource = true;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    protected void createFile(IContainer iContainer, String string, InputStream inputStream, boolean bl) throws CModelException {
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        try {
            iFile.create(inputStream, bl, this.getSubProgressMonitor(1));
            this.hasModifiedResource = true;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    protected void createFolder(IContainer iContainer, String string, boolean bl) throws CModelException {
        IFolder iFolder = iContainer.getFolder((IPath)new Path(string));
        try {
            iFolder.create(bl, true, this.getSubProgressMonitor(1));
            this.hasModifiedResource = true;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    protected void deleteResource(IResource iResource, boolean bl) throws CModelException {
        try {
            iResource.delete(bl, this.getSubProgressMonitor(1));
            this.hasModifiedResource = true;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    protected void deleteResources(IResource[] iResourceArray, boolean bl) throws CModelException {
        if (iResourceArray == null || iResourceArray.length == 0) {
            return;
        }
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(iResourceArray.length);
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.delete(iResourceArray, bl, iProgressMonitor);
            this.hasModifiedResource = true;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    public void done() {
        if (this.fMonitor != null) {
            this.fMonitor.done();
        }
    }

    protected void execute() throws CModelException {
        ICModelStatus iCModelStatus = this.verify();
        if (!iCModelStatus.isOK()) {
            throw new CModelException(iCModelStatus);
        }
        this.executeOperation();
    }

    public void executeNestedOperation(CModelOperation cModelOperation, int n) throws CModelException {
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(n);
        try {
            cModelOperation.setNested(true);
            cModelOperation.run(iProgressMonitor);
            if (cModelOperation.hasModifiedResource()) {
                this.hasModifiedResource = true;
            }
            if (cModelOperation.fDeltas != null) {
                int n2 = 0;
                while (n2 < cModelOperation.fDeltas.length) {
                    this.addDelta(cModelOperation.fDeltas[n2]);
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            Throwable throwable;
            if (coreException instanceof CModelException) {
                throw (CModelException)coreException;
            }
            if (coreException.getStatus().getCode() == 76 && (throwable = coreException.getStatus().getException()) instanceof CModelException) {
                throw (CModelException)((Object)throwable);
            }
            throw new CModelException(coreException);
        }
    }

    protected abstract void executeOperation() throws CModelException;

    protected ICElement[] getElementsToProcess() {
        return this.fElementsToProcess;
    }

    protected ICElement getElementToProcess() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return null;
        }
        return this.fElementsToProcess[0];
    }

    public ICModel getCModel() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return this.getParentElement().getCModel();
        }
        return this.fElementsToProcess[0].getCModel();
    }

    protected ICElement getParentElement() {
        if (this.fParentElements == null || this.fParentElements.length == 0) {
            return null;
        }
        return this.fParentElements[0];
    }

    protected ICElement[] getParentElements() {
        return this.fParentElements;
    }

    public ICElement[] getResultElements() {
        return this.fResultElements;
    }

    protected IProgressMonitor getSubProgressMonitor(int n) {
        SubProgressMonitor subProgressMonitor = null;
        if (this.fMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.fMonitor, n, 4);
        }
        return subProgressMonitor;
    }

    protected IWorkspace getWorkspace() {
        ICProject iCProject;
        if (this.fElementsToProcess != null && this.fElementsToProcess.length > 0 && (iCProject = this.fElementsToProcess[0].getCProject()) != null) {
            return iCProject.getCModel().getWorkspace();
        }
        return null;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && this.hasModifiedResource;
    }

    public void internalWorked(double d) {
        if (this.fMonitor != null) {
            this.fMonitor.internalWorked(d);
        }
    }

    public boolean isCanceled() {
        if (this.fMonitor != null) {
            return this.fMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected void moveResources(IResource[] iResourceArray, IPath iPath) throws CModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.fMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.fMonitor, iResourceArray.length, 4);
        }
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.move(iResourceArray, iPath, false, (IProgressMonitor)subProgressMonitor);
            this.hasModifiedResource = true;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    public CElementDelta newCElementDelta() {
        return new CElementDelta(this.getCModel());
    }

    protected void registerDeltas() {
        if (this.fDeltas != null && !this.fNested) {
            CModelManager cModelManager = CModelManager.getDefault();
            int n = 0;
            while (n < this.fDeltas.length) {
                cModelManager.registerCModelDelta(this.fDeltas[n]);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            this.fMonitor = iProgressMonitor;
            this.execute();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.registerDeltas();
            if (this.hasModifiedResource()) throw throwable;
            CModelManager cModelManager = CModelManager.getDefault();
            cModelManager.fire(1);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.registerDeltas();
            if (this.hasModifiedResource()) return;
        }
        CModelManager cModelManager = CModelManager.getDefault();
        cModelManager.fire(1);
    }

    public void setCanceled(boolean bl) {
        if (this.fMonitor != null) {
            this.fMonitor.setCanceled(bl);
        }
    }

    protected void setNested(boolean bl) {
        this.fNested = bl;
    }

    public void setTaskName(String string) {
        if (this.fMonitor != null) {
            this.fMonitor.setTaskName(string);
        }
    }

    public void subTask(String string) {
        if (this.fMonitor != null) {
            this.fMonitor.subTask(string);
        }
    }

    protected ICModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int n) {
        if (this.fMonitor != null) {
            this.fMonitor.worked(n);
            this.checkCanceled();
        }
    }
}

