/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.SourceRange;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

class SourceManipulationInfo
extends CElementInfo {
    int modifiers;

    protected SourceManipulationInfo(CElement cElement) {
        super(cElement);
        this.setIsStructureKnown(true);
        this.modifiers = 0;
    }

    protected ISourceRange getSourceRange() {
        return new SourceRange(this.getElement().getStartPos(), this.getElement().getLength(), this.getElement().getIdStartPos(), this.getElement().getIdLength(), this.getElement().getStartLine(), this.getElement().getEndLine());
    }

    public String getSource() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTranslationUnit();
        if (iTranslationUnit != null) {
            try {
                IResource iResource = iTranslationUnit.getResource();
                if (iResource != null && iResource instanceof IFile) {
                    StringBuffer stringBuffer = Util.getContent((IFile)iResource);
                    return stringBuffer.substring(this.getElement().getStartPos(), this.getElement().getStartPos() + this.getElement().getLength());
                }
            }
            catch (IOException iOException) {
                throw new CModelException(iOException, 985);
            }
        }
        return "";
    }

    public ITranslationUnit getTranslationUnit() {
        ICElement iCElement = this.getElement();
        while (iCElement != null) {
            if (iCElement instanceof ITranslationUnit) {
                return (ITranslationUnit)iCElement;
            }
            iCElement = iCElement.getParent();
        }
        return null;
    }

    public void copy(ICElement iCElement, ICElement iCElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iCElement == null) {
            throw new IllegalArgumentException("operation.nullContainer");
        }
        ICElement[] iCElementArray = new ICElement[]{this.getElement()};
        ICElement[] iCElementArray2 = new ICElement[]{iCElement};
        ICElement[] iCElementArray3 = null;
        if (iCElement2 != null) {
            iCElementArray3 = new ICElement[]{iCElement2};
        }
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        this.getElement().getCModel().copy(iCElementArray, iCElementArray2, iCElementArray3, stringArray, bl, iProgressMonitor);
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        ICElement[] iCElementArray = new ICElement[]{this.getElement()};
        this.getElement().getCModel().delete(iCElementArray, bl, iProgressMonitor);
    }

    public void move(ICElement iCElement, ICElement iCElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iCElement == null) {
            throw new IllegalArgumentException("operation.nullContainer");
        }
        ICElement[] iCElementArray = new ICElement[]{this.getElement()};
        ICElement[] iCElementArray2 = new ICElement[]{iCElement};
        ICElement[] iCElementArray3 = null;
        if (iCElement2 != null) {
            iCElementArray3 = new ICElement[]{iCElement2};
        }
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        this.getElement().getCModel().move(iCElementArray, iCElementArray2, iCElementArray3, stringArray, bl, iProgressMonitor);
    }

    public void rename(String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        if (string == null) {
            throw new IllegalArgumentException("element.nullName");
        }
        ICElement[] iCElementArray = new ICElement[]{this.getElement()};
        ICElement[] iCElementArray2 = new ICElement[]{this.getElement().getParent()};
        String[] stringArray = new String[]{string};
        this.getElement().getCModel().rename(iCElementArray, iCElementArray2, stringArray, bl, iProgressMonitor);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean hasSameContentsAs(SourceManipulationInfo sourceManipulationInfo) {
        return this.element.fType == sourceManipulationInfo.element.fType;
    }
}

