/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MILocationReachedEvent
extends MIStoppedEvent {
    public MILocationReachedEvent(MIExecAsyncOutput mIExecAsyncOutput) {
        super(mIExecAsyncOutput);
        this.parse();
    }

    public MILocationReachedEvent(MIResultRecord mIResultRecord) {
        super(mIResultRecord);
        this.parse();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("thread-id=").append(this.getThreadId()).append('\n');
        MIFrame mIFrame = this.getFrame();
        if (mIFrame != null) {
            stringBuffer.append(mIFrame.toString());
        }
        return stringBuffer.toString();
    }

    void parse() {
        MIResult[] mIResultArray = null;
        MIExecAsyncOutput mIExecAsyncOutput = this.getMIExecAsyncOutput();
        MIResultRecord mIResultRecord = this.getMIResultRecord();
        if (mIExecAsyncOutput != null) {
            mIResultArray = mIExecAsyncOutput.getMIResults();
        } else if (mIResultRecord != null) {
            mIResultArray = mIResultRecord.getMIResults();
        }
        if (mIResultArray != null) {
            int n = 0;
            while (n < mIResultArray.length) {
                String string = mIResultArray[n].getVariable();
                MIValue mIValue = mIResultArray[n].getMIValue();
                String string2 = "";
                if (mIValue instanceof MIConst) {
                    string2 = ((MIConst)mIValue).getString();
                }
                if (string.equals("thread-id")) {
                    try {
                        int n2 = Integer.parseInt(string2.trim());
                        this.setThreadId(n2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("frame") && mIValue instanceof MITuple) {
                    MIFrame mIFrame = new MIFrame((MITuple)mIValue);
                    this.setFrame(mIFrame);
                }
                ++n;
            }
        }
    }
}

