/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIWatchpointTriggerEvent
extends MIStoppedEvent {
    int number;
    String exp = "";
    String oldValue = "";
    String newValue = "";

    public MIWatchpointTriggerEvent(MIExecAsyncOutput mIExecAsyncOutput) {
        super(mIExecAsyncOutput);
        this.parse();
    }

    public MIWatchpointTriggerEvent(MIResultRecord mIResultRecord) {
        super(mIResultRecord);
        this.parse();
    }

    public int getNumber() {
        return this.number;
    }

    public String getExpression() {
        return this.exp;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("number=").append(this.number).append('\n');
        stringBuffer.append("expression=" + this.exp + "\n");
        stringBuffer.append("old=" + this.oldValue + "\n");
        stringBuffer.append("new=" + this.newValue + "\n");
        stringBuffer.append("thread-id=").append(this.getThreadId()).append('\n');
        MIFrame mIFrame = this.getFrame();
        if (mIFrame != null) {
            stringBuffer.append(mIFrame.toString());
        }
        return stringBuffer.toString();
    }

    void parse() {
        MIResult[] mIResultArray = null;
        MIExecAsyncOutput mIExecAsyncOutput = this.getMIExecAsyncOutput();
        MIResultRecord mIResultRecord = this.getMIResultRecord();
        if (mIExecAsyncOutput != null) {
            mIResultArray = mIExecAsyncOutput.getMIResults();
        } else if (mIResultRecord != null) {
            mIResultArray = mIResultRecord.getMIResults();
        }
        if (mIResultArray != null) {
            int n = 0;
            while (n < mIResultArray.length) {
                Object object;
                String string = mIResultArray[n].getVariable();
                MIValue mIValue = mIResultArray[n].getMIValue();
                if (string.equals("wpt") || string.equals("hw-awpt") || string.equals("hw-rwpt")) {
                    if (mIValue instanceof MITuple) {
                        this.parseWPT((MITuple)mIValue);
                    }
                } else if (string.equals("value")) {
                    if (mIValue instanceof MITuple) {
                        this.parseValue((MITuple)mIValue);
                    }
                } else if (string.equals("thread-id")) {
                    if (mIValue instanceof MIConst) {
                        object = ((MIConst)mIValue).getString();
                        try {
                            int n2 = Integer.parseInt(((String)object).trim());
                            this.setThreadId(n2);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (string.equals("frame") && mIValue instanceof MITuple) {
                    object = new MIFrame((MITuple)mIValue);
                    this.setFrame((MIFrame)object);
                }
                ++n;
            }
        }
    }

    void parseWPT(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        int n = 0;
        while (n < mIResultArray.length) {
            String string = mIResultArray[n].getVariable();
            MIValue mIValue = mIResultArray[n].getMIValue();
            if (string.equals("number")) {
                if (mIValue instanceof MIConst) {
                    String string2 = ((MIConst)mIValue).getString();
                    try {
                        this.number = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (string.equals("exp") && mIValue instanceof MIConst) {
                this.exp = ((MIConst)mIValue).getString();
            }
            ++n;
        }
    }

    void parseValue(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        int n = 0;
        while (n < mIResultArray.length) {
            String string = mIResultArray[n].getVariable();
            MIValue mIValue = mIResultArray[n].getMIValue();
            String string2 = "";
            if (mIValue instanceof MIConst) {
                string2 = ((MIConst)mIValue).getString();
            }
            if (string.equals("old")) {
                this.oldValue = string2;
            } else if (string.equals("new")) {
                this.newValue = string2;
            } else if (string.equals("value")) {
                this.oldValue = this.newValue = string2;
            }
            ++n;
        }
    }
}

