/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;

public class MakeBuilder
extends ACBuilder {
    private static final String BUILD_ERROR = "MakeBuilder.buildError";
    public static final String BUILDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeBuilder";

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = true;
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo(map, BUILDER_ID);
        if (!this.shouldBuild(n, iMakeBuilderInfo)) {
            this.forgetLastBuiltState();
            return new IProject[0];
        }
        if (n == 9) {
            MyResourceDeltaVisitor myResourceDeltaVisitor = new MyResourceDeltaVisitor();
            IResourceDelta iResourceDelta = this.getDelta(this.getProject());
            if (iResourceDelta != null) {
                iResourceDelta.accept((IResourceDeltaVisitor)myResourceDeltaVisitor);
                bl = myResourceDeltaVisitor.shouldBuild();
            } else {
                bl = false;
            }
        }
        if (bl) {
            boolean bl2 = this.invokeMake(n, iMakeBuilderInfo, iProgressMonitor);
            if (bl2) {
                this.forgetLastBuiltState();
            }
        } else {
            this.forgetLastBuiltState();
        }
        this.checkCancel(iProgressMonitor);
        return this.getProject().getReferencedProjects();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean invokeMake(int n, IMakeBuilderInfo iMakeBuilderInfo, IProgressMonitor iProgressMonitor) {
        boolean bl = false;
        IProject iProject = this.getProject();
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(String.valueOf(MakeCorePlugin.getResourceString("MakeBuilder.Invoking_Make_Builder")) + iProject.getName(), 100);
        try {
            try {
                IPath iPath = iMakeBuilderInfo.getBuildCommand();
                if (iPath != null) {
                    Object object;
                    String string;
                    String[] stringArray;
                    String[] stringArray2;
                    IConsole iConsole = CCorePlugin.getDefault().getConsole();
                    iConsole.start(iProject);
                    ConsoleOutputStream consoleOutputStream = iConsole.getOutputStream();
                    this.removeAllMarkers(iProject);
                    IPath iPath2 = null;
                    if (!iMakeBuilderInfo.getBuildLocation().isEmpty() && (stringArray2 = iProject.getParent().findMember(iMakeBuilderInfo.getBuildLocation())) instanceof IContainer && stringArray2.exists()) {
                        iPath2 = stringArray2.getLocation();
                    }
                    if (iPath2 == null) {
                        iPath2 = iProject.getLocation();
                    }
                    if ((stringArray2 = this.getTargets(n, iMakeBuilderInfo)).length != 0 && stringArray2[stringArray2.length - 1].equals("clean")) {
                        bl = true;
                    }
                    String string2 = null;
                    CommandLauncher commandLauncher = new CommandLauncher();
                    commandLauncher.showCommand(true);
                    Properties properties = commandLauncher.getEnvironment();
                    ((Hashtable)properties).putAll(iMakeBuilderInfo.getEnvironment());
                    ((Hashtable)properties).put("CWD", iPath2.toOSString());
                    ((Hashtable)properties).put("PWD", iPath2.toOSString());
                    String[] stringArray3 = null;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Enumeration<?> enumeration = properties.propertyNames();
                    if (enumeration != null) {
                        while (true) {
                            if (!enumeration.hasMoreElements()) {
                                stringArray3 = arrayList.toArray(new String[arrayList.size()]);
                                break;
                            }
                            stringArray = (String)enumeration.nextElement();
                            arrayList.add(String.valueOf(stringArray) + "=" + properties.getProperty((String)stringArray));
                        }
                    }
                    stringArray = stringArray2;
                    if (iMakeBuilderInfo.isDefaultBuildCmd()) {
                        if (!iMakeBuilderInfo.isStopOnError()) {
                            stringArray = new String[stringArray2.length + 1];
                            stringArray[0] = "-k";
                            System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
                        }
                    } else {
                        string = iMakeBuilderInfo.getBuildArguments();
                        if (string != null && !string.equals("")) {
                            object = this.makeArray(string);
                            stringArray = new String[stringArray2.length + ((String[])object).length];
                            System.arraycopy(object, 0, stringArray, 0, ((String[])object).length);
                            System.arraycopy(stringArray2, 0, stringArray, ((Object)object).length, stringArray2.length);
                        }
                    }
                    string = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "progressMonitor");
                    object = (Integer)this.getProject().getSessionProperty((QualifiedName)string);
                    if (object == null) {
                        object = new Integer(100);
                    }
                    StreamMonitor streamMonitor = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100), (OutputStream)consoleOutputStream, (Integer)object);
                    ErrorParserManager errorParserManager = new ErrorParserManager(this.getProject(), (IMarkerGenerator)this, iMakeBuilderInfo.getErrorParsers());
                    errorParserManager.setOutputStream((OutputStream)streamMonitor);
                    OutputStream outputStream = errorParserManager.getOutputStream();
                    OutputStream outputStream2 = errorParserManager.getOutputStream();
                    Process process = commandLauncher.execute(iPath, stringArray, stringArray3, iPath2);
                    if (process != null) {
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        iProgressMonitor.subTask(String.valueOf(MakeCorePlugin.getResourceString("MakeBuilder.Invoking_Command")) + commandLauncher.getCommandLine());
                        if (commandLauncher.waitAndRead(outputStream, outputStream2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0)) != 0) {
                            string2 = commandLauncher.getErrorMessage();
                        }
                        iProgressMonitor.subTask(MakeCorePlugin.getResourceString("MakeBuilder.Updating_project"));
                        try {
                            iProject.refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        string2 = commandLauncher.getErrorMessage();
                    }
                    this.getProject().setSessionProperty((QualifiedName)string, !iProgressMonitor.isCanceled() && !bl ? new Integer(streamMonitor.getWorkDone()) : null);
                    if (string2 != null) {
                        StringBuffer stringBuffer = new StringBuffer(String.valueOf(iPath.toString()) + " ");
                        int n2 = 0;
                        while (true) {
                            if (n2 >= stringArray.length) {
                                String string3 = MakeCorePlugin.getFormattedString(BUILD_ERROR, stringBuffer.toString());
                                stringBuffer = new StringBuffer(string3);
                                stringBuffer.append(System.getProperty("line.separator", "\n"));
                                stringBuffer.append("(").append(string2).append(")");
                                consoleOutputStream.write(stringBuffer.toString().getBytes());
                                consoleOutputStream.flush();
                                break;
                            }
                            stringBuffer.append(stringArray[n2]);
                            stringBuffer.append(' ');
                            ++n2;
                        }
                    }
                    outputStream.close();
                    outputStream2.close();
                    iProgressMonitor.subTask(MakeCorePlugin.getResourceString("MakeBuilder.Creating_Markers"));
                    errorParserManager.reportProblems();
                    consoleOutputStream.close();
                }
            }
            catch (Exception exception) {
                CCorePlugin.log((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var27_30 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var27_31 = null;
        }
        iProgressMonitor.done();
        return bl;
    }

    public void checkCancel(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int n, IMakeBuilderInfo iMakeBuilderInfo) {
        switch (n) {
            case 9: {
                return iMakeBuilderInfo.isAutoBuildEnable();
            }
            case 10: {
                return iMakeBuilderInfo.isIncrementalBuildEnabled();
            }
            case 6: {
                return iMakeBuilderInfo.isFullBuildEnabled();
            }
        }
        return true;
    }

    protected String[] getTargets(int n, IMakeBuilderInfo iMakeBuilderInfo) {
        String string = "";
        switch (n) {
            case 9: {
                string = iMakeBuilderInfo.getAutoBuildTarget();
                break;
            }
            case 10: {
                string = iMakeBuilderInfo.getIncrementalBuildTarget();
                break;
            }
            case 6: {
                string = iMakeBuilderInfo.getFullBuildTarget();
            }
        }
        return this.makeArray(string);
    }

    String[] makeArray(String string) {
        string.trim();
        char[] cArray = string.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (cArray[n] == '\"' || cArray[n] == '\'') {
                if (n > 0 && cArray[n - 1] == '\\') {
                    bl = false;
                } else {
                    boolean bl2 = bl = !bl;
                }
            }
            if (c == ' ' && !bl) {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void removeAllMarkers(IProject iProject) throws CoreException {
        IWorkspace iWorkspace = iProject.getWorkspace();
        IMarker[] iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (iMarkerArray != null) {
            iWorkspace.deleteMarkers(iMarkerArray);
        }
    }

    public class MyResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        boolean bContinue;

        public boolean visit(IResourceDelta iResourceDelta) {
            IResource iResource = iResourceDelta.getResource();
            if (iResource != null && iResource.getProject() == MakeBuilder.this.getProject()) {
                this.bContinue = true;
                return false;
            }
            return true;
        }

        public boolean shouldBuild() {
            return this.bContinue;
        }
    }
}

