/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.core.BuildInfoFactory;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class MakeCorePlugin
extends Plugin {
    public static final String MAKE_PROJECT_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".make";
    private MakeTargetManager fTargetManager;
    public static final String OLD_BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    private static MakeCorePlugin plugin;
    private ResourceBundle resourceBundle;

    public MakeCorePlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.make.core.PluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static MakeCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        Object object = null;
        object = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, MakeCorePlugin.getUniqueIdentifier(), 0, throwable.getMessage(), throwable);
        MakeCorePlugin.log(object);
    }

    public static void log(IStatus iStatus) {
        ResourcesPlugin.getPlugin().getLog().log(iStatus);
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = MakeCorePlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String getFormattedString(String string, String string2) {
        return MessageFormat.format(MakeCorePlugin.getResourceString(string), string2);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (MakeCorePlugin.getDefault() == null) {
            return "org.eclipse.cdt.make.core";
        }
        return MakeCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    protected void initializeDefaultPluginPreferences() {
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo(this.getPluginPreferences(), MakeBuilder.BUILDER_ID, true);
        try {
            iMakeBuilderInfo.setBuildCommand((IPath)new Path("make"));
            iMakeBuilderInfo.setBuildLocation((IPath)new Path(""));
            iMakeBuilderInfo.setStopOnError(false);
            iMakeBuilderInfo.setUseDefaultBuildCmd(true);
            iMakeBuilderInfo.setAutoBuildEnable(false);
            iMakeBuilderInfo.setAutoBuildTarget("all");
            iMakeBuilderInfo.setIncrementalBuildEnable(true);
            iMakeBuilderInfo.setIncrementalBuildTarget("all");
            iMakeBuilderInfo.setFullBuildEnable(true);
            iMakeBuilderInfo.setFullBuildTarget("clean all");
            iMakeBuilderInfo.setErrorParsers(CCorePlugin.getDefault().getAllErrorParsersIDs());
        }
        catch (CoreException coreException) {}
        this.getPluginPreferences().setDefault("binaryparser", "org.eclipse.cdt.core.ELF");
    }

    public static IMakeBuilderInfo createBuildInfo(Preferences preferences, String string, boolean bl) {
        return BuildInfoFactory.create(preferences, string, bl);
    }

    public static IMakeBuilderInfo createBuildInfo(IProject iProject, String string) throws CoreException {
        return BuildInfoFactory.create(iProject, string);
    }

    public static IMakeBuilderInfo createBuildInfo(Map map, String string) {
        return BuildInfoFactory.create(map, string);
    }

    public IMakeTargetManager getTargetManager() {
        if (this.fTargetManager == null) {
            this.fTargetManager = new MakeTargetManager();
            this.fTargetManager.startup();
        }
        return this.fTargetManager;
    }

    public IMakefile createMakefile(IFile iFile) {
        GNUMakefile gNUMakefile = new GNUMakefile();
        try {
            String string;
            gNUMakefile.parse(iFile.getLocation().toOSString());
            String[] stringArray = gNUMakefile.getIncludeDirectories();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string = iFile.getLocation().removeLastSegments(1).toOSString();
            gNUMakefile.setIncludeDirectories(stringArray2);
        }
        catch (IOException iOException) {}
        return gNUMakefile;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        if (this.fTargetManager != null) {
            this.fTargetManager.shutdown();
            this.fTargetManager = null;
        }
    }
}

