/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MakeScannerProvider
extends AbstractCExtension
implements IScannerInfoProvider {
    public static final String INTERFACE_IDENTITY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".MakeScannerProvider";
    private static final QualifiedName scannerInfoProperty = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "makeBuildInfo");
    private static final String CDESCRIPTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeScannerInfo";
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";
    private static Map listeners;
    private static MakeScannerProvider defaultProvider;

    public static MakeScannerProvider getDefault() {
        if (defaultProvider == null) {
            defaultProvider = new MakeScannerProvider();
        }
        return defaultProvider;
    }

    public MakeScannerInfo getMakeScannerInfo(IProject iProject, boolean bl) throws CoreException {
        MakeScannerInfo makeScannerInfo = null;
        makeScannerInfo = (MakeScannerInfo)iProject.getSessionProperty(scannerInfoProperty);
        if (makeScannerInfo == null) {
            makeScannerInfo = this.loadScannerInfo(iProject);
        }
        if (makeScannerInfo != null && bl) {
            iProject.setSessionProperty(scannerInfoProperty, (Object)makeScannerInfo);
        }
        return makeScannerInfo;
    }

    private static synchronized Map getListeners() {
        if (listeners == null) {
            listeners = new HashMap();
        }
        return listeners;
    }

    private static void notifyInfoListeners(IProject iProject, IScannerInfo iScannerInfo) {
        List list = (List)MakeScannerProvider.getListeners().get(iProject);
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ((IScannerInfoChangeListener)listIterator.next()).changeNotification((IResource)iProject, iScannerInfo);
        }
    }

    public IScannerInfo getScannerInformation(IResource iResource) {
        MakeScannerInfo makeScannerInfo = null;
        try {
            makeScannerInfo = this.getMakeScannerInfo(iResource.getProject(), true);
        }
        catch (CoreException coreException) {}
        return makeScannerInfo;
    }

    private MakeScannerInfo loadScannerInfo(IProject iProject) throws CoreException {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
        Node node = iCDescriptor.getProjectData(CDESCRIPTOR_ID).getFirstChild();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (node != null) {
            if (node.getNodeName().equals(INCLUDE_PATH)) {
                arrayList.add(((Element)node).getAttribute(PATH));
            } else if (node.getNodeName().equals(DEFINED_SYMBOL)) {
                arrayList2.add(((Element)node).getAttribute(SYMBOL));
            }
            node = node.getNextSibling();
        }
        MakeScannerInfo makeScannerInfo = new MakeScannerInfo(iProject);
        makeScannerInfo.setIncludePaths(arrayList.toArray(new String[arrayList.size()]));
        makeScannerInfo.setPreprocessorSymbols(arrayList2.toArray(new String[arrayList2.size()]));
        return makeScannerInfo;
    }

    public static void removeScannerInfo(IResource iResource) {
        try {
            iResource.getProject().setSessionProperty(scannerInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    static void updateScannerInfo(MakeScannerInfo makeScannerInfo) throws CoreException {
        IProject iProject = makeScannerInfo.getProject();
        if (iProject.getSessionProperty(scannerInfoProperty) != null) {
            iProject.setSessionProperty(scannerInfoProperty, (Object)makeScannerInfo);
        }
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
        Element element = iCDescriptor.getProjectData(CDESCRIPTOR_ID);
        Node node = element.getFirstChild();
        while (node != null) {
            element.removeChild(node);
            node = element.getFirstChild();
        }
        if (makeScannerInfo != null) {
            Element element2;
            Document document = element.getOwnerDocument();
            ListIterator<String> listIterator = Arrays.asList(makeScannerInfo.getIncludePaths()).listIterator();
            while (listIterator.hasNext()) {
                element2 = document.createElement(INCLUDE_PATH);
                element2.setAttribute(PATH, listIterator.next());
                element.appendChild(element2);
            }
            listIterator = Arrays.asList(makeScannerInfo.getPreprocessorSymbols()).listIterator();
            while (listIterator.hasNext()) {
                element2 = document.createElement(DEFINED_SYMBOL);
                element2.setAttribute(SYMBOL, listIterator.next());
                element.appendChild(element2);
            }
            iCDescriptor.saveProjectData();
        }
        MakeScannerProvider.notifyInfoListeners(iProject, makeScannerInfo);
    }

    public synchronized void subscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        IResource iResource2 = null;
        if (iResource instanceof IProject) {
            iResource2 = iResource;
        } else if (iResource instanceof IFile) {
            iResource2 = ((IFile)iResource).getProject();
        } else {
            return;
        }
        Map map = MakeScannerProvider.getListeners();
        ArrayList<IScannerInfoChangeListener> arrayList = (ArrayList<IScannerInfoChangeListener>)map.get(iResource2);
        if (arrayList == null) {
            arrayList = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!arrayList.contains(iScannerInfoChangeListener)) {
            arrayList.add(iScannerInfoChangeListener);
            map.put(iResource2, arrayList);
        }
    }

    public synchronized void unsubscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        IResource iResource2 = null;
        if (iResource instanceof IProject) {
            iResource2 = iResource;
        } else if (iResource instanceof IFile) {
            iResource2 = ((IFile)iResource).getProject();
        } else {
            return;
        }
        Map map = MakeScannerProvider.getListeners();
        List list = (List)map.get(iResource2);
        if (list != null && !list.isEmpty()) {
            list.remove(iScannerInfoChangeListener);
            map.put(iResource2, list);
        }
    }
}

