/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTarget;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectTargets {
    private static final String BUILD_TARGET_ELEMENT = "buildTargets";
    private static final String TARGET_ELEMENT = "target";
    private static final String TARGET_ATTR_ID = "targetID";
    private static final String TARGET_ATTR_PATH = "path";
    private static final String TARGET_ATTR_NAME = "name";
    private static final String TARGET_STOP_ON_ERROR = "stopOnError";
    private static final String TARGET_USE_DEFAULT_CMD = "useDefaultCommand";
    private static final String TARGET_ARGUMENTS = "buildArguments";
    private static final String TARGET_COMMAND = "buildCommand";
    private static final String TARGET = "buidlTarget";
    private HashMap targetMap = new HashMap();
    private IProject project;

    public ProjectTargets(IProject iProject) {
        this.project = iProject;
    }

    public ProjectTargets(MakeTargetManager makeTargetManager, IProject iProject, InputStream inputStream) throws CoreException {
        this(iProject);
        Object object;
        Document document = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeCorePlugin.getResourceString("ProjectTargets.error_reading_project_targets"), (Throwable)exception));
        }
        object = document.getFirstChild();
        if (object.getNodeName().equals(BUILD_TARGET_ELEMENT)) {
            NodeList nodeList = object.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                object = nodeList.item(n);
                if (object.getNodeName().equals(TARGET_ELEMENT)) {
                    Object object2 = null;
                    NamedNodeMap namedNodeMap = object.getAttributes();
                    String string = namedNodeMap.getNamedItem(TARGET_ATTR_PATH).getNodeValue();
                    object2 = string != null && !string.equals("") ? iProject.getFolder(string) : iProject;
                    try {
                        MakeTarget makeTarget = new MakeTarget(makeTargetManager, iProject, namedNodeMap.getNamedItem(TARGET_ATTR_ID).getNodeValue(), namedNodeMap.getNamedItem(TARGET_ATTR_NAME).getNodeValue());
                        makeTarget.setContainer((IContainer)object2);
                        String string2 = this.getString((Node)object, TARGET_STOP_ON_ERROR);
                        if (string2 != null) {
                            makeTarget.setStopOnError(Boolean.valueOf(string2));
                        }
                        if ((string2 = this.getString((Node)object, TARGET_USE_DEFAULT_CMD)) != null) {
                            makeTarget.setUseDefaultBuildCmd(Boolean.valueOf(string2));
                        }
                        if ((string2 = this.getString((Node)object, TARGET_COMMAND)) != null) {
                            makeTarget.setBuildCommand((IPath)new Path(string2));
                        }
                        if ((string2 = this.getString((Node)object, TARGET_ARGUMENTS)) != null) {
                            makeTarget.setBuildArguments(string2);
                        }
                        if ((string2 = this.getString((Node)object, TARGET)) != null) {
                            makeTarget.setBuildTarget(string2);
                        }
                        this.add(makeTarget);
                    }
                    catch (CoreException coreException) {
                        MakeCorePlugin.log(coreException);
                    }
                }
                ++n;
            }
        }
    }

    protected String getString(Node node, String string) {
        Node node2 = this.searchNode(node, string);
        return node2 != null ? (node2.getFirstChild() == null ? null : node2.getFirstChild().getNodeValue()) : null;
    }

    protected Node searchNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeName().equals(string)) {
                return nodeList.item(n);
            }
            ++n;
        }
        return null;
    }

    public IMakeTarget[] get(IContainer iContainer) {
        ArrayList arrayList = (ArrayList)this.targetMap.get(iContainer);
        if (arrayList != null) {
            return arrayList.toArray(new IMakeTarget[arrayList.size()]);
        }
        return new IMakeTarget[0];
    }

    public IMakeTarget findTarget(IContainer iContainer, String string) {
        ArrayList arrayList = (ArrayList)this.targetMap.get(iContainer);
        if (arrayList != null) {
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                IMakeTarget iMakeTarget = (IMakeTarget)iterator.next();
                if (!iMakeTarget.getName().equals(string)) continue;
                return iMakeTarget;
            }
        }
        return null;
    }

    public void add(MakeTarget makeTarget) throws CoreException {
        ArrayList<MakeTarget> arrayList = (ArrayList<MakeTarget>)this.targetMap.get(makeTarget.getContainer());
        if (arrayList != null && arrayList.contains(makeTarget)) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeCorePlugin.getResourceString("MakeTargetManager.target_exists"), null));
        }
        if (arrayList == null) {
            arrayList = new ArrayList<MakeTarget>();
            this.targetMap.put(makeTarget.getContainer(), arrayList);
        }
        arrayList.add(makeTarget);
    }

    public boolean contains(MakeTarget makeTarget) {
        ArrayList arrayList = (ArrayList)this.targetMap.get(makeTarget.getContainer());
        return arrayList != null && arrayList.contains(makeTarget);
    }

    public boolean remove(IMakeTarget iMakeTarget) {
        ArrayList arrayList = (ArrayList)this.targetMap.get(iMakeTarget.getContainer());
        if (arrayList == null || !arrayList.contains(iMakeTarget)) {
            return false;
        }
        boolean bl = ((AbstractCollection)arrayList).remove(iMakeTarget);
        if (arrayList.size() == 0) {
            this.targetMap.remove(arrayList);
        }
        return bl;
    }

    public IProject getProject() {
        return this.project;
    }

    protected Document getAsXML() {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement(BUILD_TARGET_ELEMENT);
        documentImpl.appendChild(element);
        Iterator iterator = this.targetMap.entrySet().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next().getValue();
            int n = 0;
            while (n < list.size()) {
                MakeTarget makeTarget = (MakeTarget)list.get(n);
                element.appendChild(this.createTargetElement((Document)documentImpl, makeTarget));
                ++n;
            }
        }
        return documentImpl;
    }

    private Node createTargetElement(Document document, MakeTarget makeTarget) {
        Element element = document.createElement(TARGET_ELEMENT);
        element.setAttribute(TARGET_ATTR_NAME, makeTarget.getName());
        element.setAttribute(TARGET_ATTR_ID, makeTarget.getTargetBuilderID());
        element.setAttribute(TARGET_ATTR_PATH, makeTarget.getContainer().getProjectRelativePath().toString());
        Element element2 = document.createElement(TARGET_COMMAND);
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(makeTarget.getBuildCommand().toString()));
        element2 = document.createElement(TARGET_ARGUMENTS);
        element2.appendChild(document.createTextNode(makeTarget.getBuildArguments()));
        element.appendChild(element2);
        element2 = document.createElement(TARGET);
        element2.appendChild(document.createTextNode(makeTarget.getBuildTarget()));
        element.appendChild(element2);
        element2 = document.createElement(TARGET_STOP_ON_ERROR);
        element2.appendChild(document.createTextNode(new Boolean(makeTarget.isStopOnError()).toString()));
        element.appendChild(element2);
        element2 = document.createElement(TARGET_USE_DEFAULT_CMD);
        element2.appendChild(document.createTextNode(new Boolean(makeTarget.isDefaultBuildCmd()).toString()));
        element.appendChild(element2);
        return element;
    }

    public void saveTargets(OutputStream outputStream) throws IOException {
        Document document = this.getAsXML();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndenting(true);
        outputFormat.setPreserveSpace(true);
        outputFormat.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter(outputStream, "UTF8"), outputFormat);
        serializer.asDOMSerializer().serialize(document);
    }
}

