/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class StreamMonitor
extends OutputStream {
    IProgressMonitor monitor;
    OutputStream console;
    public final int fTotalWork;
    private int halfWay;
    private int currentIncrement;
    private int nextProgress;
    private int worked;

    public StreamMonitor(IProgressMonitor iProgressMonitor, OutputStream outputStream, int n) {
        this.nextProgress = this.currentIncrement = 2;
        this.worked = 0;
        this.monitor = iProgressMonitor;
        this.console = outputStream;
        this.fTotalWork = n;
        this.halfWay = this.fTotalWork / 2;
        this.monitor.beginTask("", this.fTotalWork);
    }

    private void progressUpdate() {
        if (--this.nextProgress <= 0) {
            if (this.fTotalWork > this.worked) {
                this.monitor.worked(1);
            }
            ++this.worked;
            if (this.worked >= this.halfWay) {
                this.currentIncrement *= 2;
                this.halfWay += (this.fTotalWork - this.halfWay) / 2;
            }
            this.nextProgress = this.currentIncrement;
        }
    }

    public void close() throws IOException {
        if (this.console != null) {
            this.console.close();
        }
        this.monitor.done();
    }

    public void flush() throws IOException {
        if (this.console != null) {
            this.console.flush();
        }
    }

    public synchronized void write(int n) throws IOException {
        if (this.console != null) {
            this.console.write(n);
        }
        this.progressUpdate();
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n != 0 || n2 < 0 || n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (this.console != null) {
            this.console.write(byArray, n, n2);
        }
        this.progressUpdate();
    }

    public int getWorkDone() {
        return this.worked;
    }
}

