/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.make.core.makefile.ICommand;
import org.eclipse.cdt.make.internal.core.makefile.Directive;

public class Command
extends Directive
implements ICommand {
    public static final char NL = '\n';
    String command = "";
    char prefix = '\u0000';

    public Command(Directive directive, String string) {
        super(directive);
        this.parse(string);
    }

    public boolean shouldIgnoreError() {
        return this.getPrefix() == '-';
    }

    public boolean shouldBeSilent() {
        return this.getPrefix() == '@';
    }

    public boolean shouldExecute() {
        return this.getPrefix() == '+';
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\t');
        if (this.getPrefix() != '\u0000') {
            stringBuffer.append(this.getPrefix());
        }
        stringBuffer.append(this.command).append('\n');
        return stringBuffer.toString();
    }

    public boolean equals(Command command) {
        return command.toString().equals(this.toString());
    }

    char getPrefix() {
        return this.prefix;
    }

    void parse(String string) {
        this.command = string.trim();
        if (this.command.startsWith("-") || this.command.startsWith("@") || this.command.startsWith("+")) {
            this.prefix = this.command.charAt(0);
            this.command = this.command.substring(1).trim();
        }
    }

    public Process execute(String string, String[] stringArray, File file) throws IOException {
        String[] stringArray2 = new String[]{string, "-c", this.command};
        return Runtime.getRuntime().exec(stringArray2, stringArray, file);
    }
}

