/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.gnu.IGNUMakefile;
import org.eclipse.cdt.make.internal.core.makefile.AbstractMakefile;
import org.eclipse.cdt.make.internal.core.makefile.BadDirective;
import org.eclipse.cdt.make.internal.core.makefile.Command;
import org.eclipse.cdt.make.internal.core.makefile.Comment;
import org.eclipse.cdt.make.internal.core.makefile.DefaultRule;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.EmptyLine;
import org.eclipse.cdt.make.internal.core.makefile.IgnoreRule;
import org.eclipse.cdt.make.internal.core.makefile.InferenceRule;
import org.eclipse.cdt.make.internal.core.makefile.MacroDefinition;
import org.eclipse.cdt.make.internal.core.makefile.MakefileReader;
import org.eclipse.cdt.make.internal.core.makefile.PosixRule;
import org.eclipse.cdt.make.internal.core.makefile.PreciousRule;
import org.eclipse.cdt.make.internal.core.makefile.Rule;
import org.eclipse.cdt.make.internal.core.makefile.SccsGetRule;
import org.eclipse.cdt.make.internal.core.makefile.SilentRule;
import org.eclipse.cdt.make.internal.core.makefile.SpecialRule;
import org.eclipse.cdt.make.internal.core.makefile.SuffixesRule;
import org.eclipse.cdt.make.internal.core.makefile.Target;
import org.eclipse.cdt.make.internal.core.makefile.Util;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Conditional;
import org.eclipse.cdt.make.internal.core.makefile.gnu.DefineVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.DeleteOnErrorRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Else;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Endef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Endif;
import org.eclipse.cdt.make.internal.core.makefile.gnu.ExportAllVariablesRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.ExportVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefileUtil;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUTargetRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifdef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifeq;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifndef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifneq;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Include;
import org.eclipse.cdt.make.internal.core.makefile.gnu.IntermediateRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.LowResolutionTimeRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.NotParallelRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.OverrideDefine;
import org.eclipse.cdt.make.internal.core.makefile.gnu.OverrideVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.PhonyRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.SecondaryRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.StaticTargetRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.TargetVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.UnExport;
import org.eclipse.cdt.make.internal.core.makefile.gnu.VPath;
import org.eclipse.cdt.make.internal.core.makefile.gnu.VariableDefinition;
import org.eclipse.cdt.make.internal.core.makefile.posix.PosixMakefileUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GNUMakefile
extends AbstractMakefile
implements IGNUMakefile {
    public static String PATH_SEPARATOR = System.getProperty("path.separator", ":");
    public static String FILE_SEPARATOR = System.getProperty("file.separator", "/");
    String[] includeDirectories = new String[0];
    IDirective[] builtins = null;

    public GNUMakefile() {
        super(null);
    }

    public void parse(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        this.parse(fileReader);
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void parse(Reader reader) throws IOException {
        this.parse(new MakefileReader(reader));
    }

    protected void parse(MakefileReader makefileReader) throws IOException {
        String string;
        Object object = null;
        Stack<Object> stack = new Stack<Object>();
        Stack<VariableDefinition> stack2 = new Stack<VariableDefinition>();
        int n = 0;
        int n2 = 0;
        this.clearDirectives();
        while ((string = makefileReader.readLine()) != null) {
            int n3;
            Object object2;
            int n4;
            int n5;
            Object object3;
            n = n2 + 1;
            n2 = makefileReader.getLineNumber();
            if (GNUMakefileUtil.isEndef(string)) {
                Directive directive;
                if (!stack2.empty()) {
                    directive = (VariableDefinition)stack2.pop();
                    directive.setEndLine(n2);
                }
                directive = new Endef(this);
                directive.setLines(n, n2);
                this.addDirective(stack, directive);
                continue;
            }
            if (GNUMakefileUtil.isDefine(string)) {
                VariableDefinition variableDefinition = this.parseVariableDefinition(string);
                variableDefinition.setLines(n, n2);
                this.addDirective(stack, variableDefinition);
                stack2.push(variableDefinition);
                continue;
            }
            if (GNUMakefileUtil.isOverrideDefine(string)) {
                VariableDefinition variableDefinition = this.parseVariableDefinition(string);
                variableDefinition.setLines(n, n2);
                this.addDirective(stack, variableDefinition);
                stack2.push(variableDefinition);
                continue;
            }
            if (!stack2.empty()) {
                VariableDefinition variableDefinition = (VariableDefinition)stack2.peek();
                object3 = variableDefinition.getValue();
                if (((StringBuffer)object3).length() > 0) {
                    ((StringBuffer)object3).append('\n');
                }
                ((StringBuffer)object3).append(string);
                continue;
            }
            if (PosixMakefileUtil.isCommand(string)) {
                Command command = new Command(this, string);
                command.setLines(n, n2);
                if (!stack.empty()) {
                    this.addDirective(stack, command);
                    continue;
                }
                if (object != null) {
                    int n6 = 0;
                    while (n6 < ((Rule[])object).length) {
                        object[n6].addDirective(command);
                        object[n6].setEndLine(n2);
                        ++n6;
                    }
                    continue;
                }
            }
            if ((n5 = Util.indexOfComment(string)) != -1) {
                object3 = new Comment(this, string.substring(n5 + 1));
                ((Directive)object3).setLines(n, n2);
                if (object != null) {
                    n4 = 0;
                    while (n4 < ((Rule[])object).length) {
                        object[n4].addDirective((Directive)object3);
                        object[n4].setEndLine(n2);
                        ++n4;
                    }
                } else {
                    this.addDirective(stack, (Directive)object3);
                }
                string = string.substring(0, n5);
                if (Util.isEmptyLine(string)) continue;
            }
            if (Util.isEmptyLine(string)) {
                object3 = new EmptyLine(this);
                ((Directive)object3).setLines(n, n2);
                if (object != null) {
                    n4 = 0;
                    while (n4 < ((Rule[])object).length) {
                        object[n4].addDirective((Directive)object3);
                        object[n4].setEndLine(n2);
                        ++n4;
                    }
                    continue;
                }
                this.addDirective(stack, (Directive)object3);
                continue;
            }
            object = null;
            if (GNUMakefileUtil.isElse(string)) {
                object3 = this.parseConditional(string);
                ((Directive)object3).setLines(n, n2);
                if (!stack.empty()) {
                    Conditional conditional = (Conditional)stack.pop();
                    conditional.setEndLine(n2 - 1);
                }
                this.addDirective(stack, (Directive)object3);
                stack.push(object3);
                continue;
            }
            if (GNUMakefileUtil.isEndif(string)) {
                object3 = new Endif(this);
                ((Directive)object3).setLines(n, n2);
                if (!stack.empty()) {
                    Conditional conditional = (Conditional)stack.pop();
                    conditional.setEndLine(n2);
                }
                this.addDirective(stack, (Directive)object3);
                continue;
            }
            object3 = this.processConditions(string);
            if (object3 != null) {
                ((Directive)object3).setLines(n, n2);
                this.addDirective(stack, (Directive)object3);
                stack.push(object3);
                continue;
            }
            object3 = this.processGNUDirectives(string);
            if (object3 != null) {
                ((Directive)object3).setLines(n, n2);
                this.addDirective(stack, (Directive)object3);
                continue;
            }
            SpecialRule specialRule = this.processSpecialRules(string);
            if (specialRule != null) {
                object = new Rule[]{specialRule};
                specialRule.setLines(n, n2);
                this.addDirective(stack, specialRule);
                continue;
            }
            if (PosixMakefileUtil.isInferenceRule(string)) {
                object2 = this.parseInferenceRule(string);
                ((Directive)object2).setLines(n, n2);
                this.addDirective(stack, (Directive)object2);
                object = new Rule[]{object2};
                continue;
            }
            if (GNUMakefileUtil.isVariableDefinition(string)) {
                object2 = this.parseVariableDefinition(string);
                ((Directive)object2).setLines(n, n2);
                this.addDirective(stack, (Directive)object2);
                continue;
            }
            if (GNUMakefileUtil.isStaticTargetRule(string)) {
                object2 = this.parseStaticTargetRule(string);
                n3 = 0;
                while (n3 < ((Rule[])object2).length) {
                    ((Directive)object2[n3]).setLines(n, n2);
                    this.addDirective(stack, (Directive)object2[n3]);
                    ++n3;
                }
                object = object2;
                continue;
            }
            if (GNUMakefileUtil.isGNUTargetRule(string)) {
                object2 = this.parseGNUTargetRules(string);
                n3 = 0;
                while (n3 < ((Rule[])object2).length) {
                    ((Directive)object2[n3]).setLines(n, n2);
                    this.addDirective(stack, (Directive)object2[n3]);
                    ++n3;
                }
                object = object2;
                continue;
            }
            object2 = new BadDirective(this, string);
            ((Directive)object2).setLines(n, n2);
            this.addDirective(stack, (Directive)object2);
        }
        this.setLines(1, n2);
    }

    private void addDirective(Stack stack, Directive directive) {
        if (stack.empty()) {
            this.addDirective(directive);
        } else {
            Conditional conditional = (Conditional)stack.peek();
            conditional.addDirective(directive);
            conditional.setEndLine(directive.getEndLine());
        }
    }

    protected Conditional processConditions(String string) {
        Conditional conditional = null;
        if (GNUMakefileUtil.isIfdef(string)) {
            conditional = this.parseConditional(string);
        } else if (GNUMakefileUtil.isIfndef(string)) {
            conditional = this.parseConditional(string);
        } else if (GNUMakefileUtil.isIfeq(string)) {
            conditional = this.parseConditional(string);
        } else if (GNUMakefileUtil.isIfneq(string)) {
            conditional = this.parseConditional(string);
        }
        return conditional;
    }

    protected Directive processGNUDirectives(String string) {
        Directive directive = null;
        if (GNUMakefileUtil.isUnExport(string)) {
            directive = this.parseUnExport(string);
        } else if (GNUMakefileUtil.isVPath(string)) {
            directive = this.parseVPath(string);
        } else if (GNUMakefileUtil.isInclude(string)) {
            directive = this.parseInclude(string);
        }
        return directive;
    }

    protected SpecialRule processSpecialRules(String string) {
        SpecialRule specialRule = null;
        if (PosixMakefileUtil.isIgnoreRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (PosixMakefileUtil.isPosixRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (PosixMakefileUtil.isPreciousRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (PosixMakefileUtil.isSilentRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (PosixMakefileUtil.isSuffixesRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (PosixMakefileUtil.isDefaultRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (PosixMakefileUtil.isSccsGetRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (GNUMakefileUtil.isPhonyRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (GNUMakefileUtil.isIntermediateRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (GNUMakefileUtil.isSecondaryRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (GNUMakefileUtil.isDeleteOnErrorRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (GNUMakefileUtil.isLowResolutionTimeRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (GNUMakefileUtil.isExportAllVariablesRule(string)) {
            specialRule = this.parseSpecialRule(string);
        } else if (GNUMakefileUtil.isNotParallelRule(string)) {
            specialRule = this.parseSpecialRule(string);
        }
        return specialRule;
    }

    protected SpecialRule parseSpecialRule(String string) {
        string = string.trim();
        String string2 = null;
        String[] stringArray = null;
        SpecialRule specialRule = null;
        int n = Util.indexOf(string, ':');
        if (n != -1) {
            string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1);
            stringArray = PosixMakefileUtil.findPrerequisites(string3);
        } else {
            string2 = string;
            stringArray = new String[]{};
        }
        if (string2.equals(".IGNORE")) {
            specialRule = new IgnoreRule((Directive)this, stringArray);
        } else if (string2.equals(".POSIX")) {
            specialRule = new PosixRule(this);
        } else if (string2.equals(".PRECIOUS")) {
            specialRule = new PreciousRule((Directive)this, stringArray);
        } else if (string2.equals(".SILENT")) {
            specialRule = new SilentRule((Directive)this, stringArray);
        } else if (string2.equals(".SUFFIXES")) {
            specialRule = new SuffixesRule((Directive)this, stringArray);
        } else if (string2.equals(".DEFAULT")) {
            specialRule = new DefaultRule((Directive)this, new Command[0]);
        } else if (string2.equals(".SCCS_GET")) {
            specialRule = new SccsGetRule((Directive)this, new Command[0]);
        } else if (string2.equals(".PHONY")) {
            specialRule = new PhonyRule((Directive)this, stringArray);
        } else if (string2.equals(".INTERMEDIATE")) {
            specialRule = new IntermediateRule((Directive)this, stringArray);
        } else if (string2.equals(".SECONDARY")) {
            specialRule = new SecondaryRule((Directive)this, stringArray);
        } else if (string2.equals(".DELETE_ON_ERROR")) {
            specialRule = new DeleteOnErrorRule((Directive)this, stringArray);
        } else if (string2.equals(".LOW_RESOLUTION_TIME")) {
            specialRule = new LowResolutionTimeRule((Directive)this, stringArray);
        } else if (string2.equals(".EXPORT_ALL_VARIABLES")) {
            specialRule = new ExportAllVariablesRule((Directive)this, stringArray);
        } else if (string2.equals(".NOTPARALLEL")) {
            specialRule = new NotParallelRule((Directive)this, stringArray);
        }
        return specialRule;
    }

    protected Conditional parseConditional(String string) {
        Conditional conditional = null;
        string = string.trim();
        String string2 = null;
        int n = 0;
        while (n < string.length()) {
            if (Util.isSpace(string.charAt(n))) {
                string2 = string.substring(0, n);
                string = string.substring(n).trim();
                break;
            }
            ++n;
        }
        if (string2 == null) {
            string2 = string;
        }
        if (string2.equals("ifdef")) {
            conditional = new Ifdef(this, string);
        } else if (string2.equals("ifndef")) {
            conditional = new Ifndef(this, string);
        } else if (string2.equals("ifeq")) {
            conditional = new Ifeq(this, string);
        } else if (string2.equals("ifneq")) {
            conditional = new Ifneq(this, string);
        } else if (string2.equals("else")) {
            conditional = new Else(this);
        }
        return conditional;
    }

    protected Include parseInclude(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringArray = new String[n - 1];
            int n2 = 0;
            while (n2 < n) {
                if (n2 == 0) {
                    stringTokenizer.nextToken();
                } else {
                    stringArray[n2 - 1] = stringTokenizer.nextToken();
                }
                ++n2;
            }
        } else {
            stringArray = new String[]{};
        }
        return new Include(this, stringArray, this.getIncludeDirectories());
    }

    protected VPath parseVPath(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                if (n == 0) {
                    stringTokenizer.nextToken();
                } else if (n == 1) {
                    string2 = stringTokenizer.nextToken();
                } else if (n == 3) {
                    String string3 = " \t\n\r\f" + PATH_SEPARATOR;
                    arrayList.add(stringTokenizer.nextToken(string3));
                } else {
                    arrayList.add(stringTokenizer.nextToken());
                }
                ++n2;
            }
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        if (string2 == null) {
            string2 = new String();
        }
        return new VPath(this, string2, stringArray);
    }

    protected UnExport parseUnExport(String string) {
        int n = 0;
        while (n < string.length()) {
            if (Util.isSpace(string.charAt(n))) {
                string = string.substring(n).trim();
                break;
            }
            ++n;
        }
        return new UnExport(this, string);
    }

    protected GNUTargetRule[] parseGNUTargetRules(String string) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        GNUTargetRule[] gNUTargetRuleArray;
        String string2 = null;
        boolean bl = false;
        int n = Util.indexOf(string, ':');
        if (n != -1) {
            int n2;
            gNUTargetRuleArray = string.substring(0, n);
            stringArray3 = PosixMakefileUtil.findTargets(gNUTargetRuleArray.trim());
            String string3 = string.substring(n + 1);
            bl = string3.startsWith(":");
            if (bl) {
                string3 = string3.substring(1);
            }
            if ((n2 = Util.indexOf(string3, ';')) != -1) {
                string2 = string3.substring(n2 + 1);
                string3 = string3.substring(0, n2);
            }
            String string4 = null;
            String string5 = null;
            int n3 = Util.indexOf(string3, '|');
            if (n3 != -1) {
                string4 = string3.substring(0, n3);
                string5 = string3.substring(n3 + 1);
            } else {
                string4 = string3;
                string5 = "";
            }
            stringArray2 = PosixMakefileUtil.findPrerequisites(string4.trim());
            stringArray = PosixMakefileUtil.findPrerequisites(string5.trim());
        } else {
            stringArray3 = PosixMakefileUtil.findTargets(string);
            stringArray2 = new String[]{};
            stringArray = new String[]{};
        }
        gNUTargetRuleArray = new GNUTargetRule[stringArray3.length];
        int n4 = 0;
        while (n4 < stringArray3.length) {
            gNUTargetRuleArray[n4] = new GNUTargetRule(this, new Target(stringArray3[n4]), bl, stringArray2, stringArray, new Command[0]);
            if (string2 != null) {
                gNUTargetRuleArray[n4].addDirective(new Command(this, string2));
            }
            ++n4;
        }
        return gNUTargetRuleArray;
    }

    protected VariableDefinition parseVariableDefinition(String string) {
        VariableDefinition variableDefinition;
        String string2;
        int n;
        string = string.trim();
        char c = '\u0000';
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (GNUMakefileUtil.isTargetVariable(string)) {
            n = Util.indexOf(string, ':');
            if (n != -1) {
                string3 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            } else {
                string3 = "";
            }
        }
        if (GNUMakefileUtil.isOverride(string)) {
            bl2 = true;
            n = 0;
            while (n < string.length()) {
                if (Util.isSpace(string.charAt(n))) {
                    string = string.substring(n).trim();
                    break;
                }
                ++n;
            }
        }
        if (GNUMakefileUtil.isDefine(string)) {
            bl = true;
            n = 0;
            while (n < string.length()) {
                if (Util.isSpace(string.charAt(n))) {
                    string = string.substring(n).trim();
                    break;
                }
                ++n;
            }
        }
        if (GNUMakefileUtil.isExport(string)) {
            bl4 = true;
            n = 0;
            while (n < string.length()) {
                if (Util.isSpace(string.charAt(n))) {
                    string = string.substring(n).trim();
                    break;
                }
                ++n;
            }
        }
        if ((n = string.indexOf(61)) != -1) {
            int n2 = n;
            if (n > 0) {
                c = string.charAt(n - 1);
                if (c == ':' || c == '+' || c == '?') {
                    n2 = n - 1;
                } else {
                    c = '\u0000';
                }
            }
            string2 = string.substring(0, n2).trim();
            stringBuffer.append(string.substring(n + 1).trim());
        } else {
            string2 = string;
        }
        if (bl3) {
            variableDefinition = new TargetVariable(this, string3, string2, stringBuffer, bl2, c);
        }
        variableDefinition = bl2 && bl ? new OverrideDefine(this, string2, stringBuffer) : (bl ? new DefineVariable(this, string2, stringBuffer) : (bl2 ? new OverrideVariable(this, string2, stringBuffer, c) : (bl4 ? new ExportVariable(this, string2, stringBuffer, c) : new VariableDefinition(this, string2, stringBuffer, c))));
        return variableDefinition;
    }

    protected StaticTargetRule[] parseStaticTargetRule(String string) {
        String[] stringArray;
        String string2;
        String[] stringArray2;
        StaticTargetRule[] staticTargetRuleArray;
        int n = Util.indexOf(string, ':');
        if (n > 1) {
            staticTargetRuleArray = string.substring(0, n).trim();
            stringArray2 = PosixMakefileUtil.findTargets((String)staticTargetRuleArray);
            if ((n = Util.indexOf(string = string.substring(n + 1), ':')) != -1) {
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int n2 = stringTokenizer.countTokens();
                stringArray = new String[n2];
                int n3 = 0;
                while (n3 < n2) {
                    stringArray[n3] = stringTokenizer.nextToken();
                    ++n3;
                }
            } else {
                string2 = "";
                stringArray = new String[]{};
            }
        } else {
            stringArray2 = new String[]{};
            string2 = "";
            stringArray = new String[]{};
        }
        staticTargetRuleArray = new StaticTargetRule[stringArray2.length];
        int n4 = 0;
        while (n4 < stringArray2.length) {
            staticTargetRuleArray[n4] = new StaticTargetRule(this, new Target(stringArray2[n4]), string2, stringArray, new Command[0]);
            ++n4;
        }
        return staticTargetRuleArray;
    }

    protected InferenceRule parseInferenceRule(String string) {
        int n = Util.indexOf(string, ':');
        String string2 = n != -1 ? string.substring(0, n) : string;
        return new InferenceRule(this, new Target(string2));
    }

    public IDirective[] getBuiltins() {
        if (this.builtins == null) {
            String string = "builtin" + File.separator + "gnu.mk";
            try {
                InputStream inputStream = MakeCorePlugin.getDefault().openStream((IPath)new Path(string));
                GNUMakefile gNUMakefile = new GNUMakefile();
                gNUMakefile.parse(new InputStreamReader(inputStream));
                this.builtins = gNUMakefile.getDirectives();
                int n = 0;
                while (n < this.builtins.length) {
                    if (this.builtins[n] instanceof MacroDefinition) {
                        ((MacroDefinition)this.builtins[n]).setFromDefault(true);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
            if (this.builtins == null) {
                this.builtins = new IDirective[0];
            }
        }
        return this.builtins;
    }

    public void setIncludeDirectories(String[] stringArray) {
        this.includeDirectories = stringArray;
    }

    public String[] getIncludeDirectories() {
        return this.includeDirectories;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "Makefile";
            if (stringArray.length == 1) {
                string = stringArray[0];
            }
            GNUMakefile gNUMakefile = new GNUMakefile();
            gNUMakefile.parse(string);
            IDirective[] iDirectiveArray = gNUMakefile.getDirectives();
            int n = 0;
            while (n < iDirectiveArray.length) {
                System.out.print(iDirectiveArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

