/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.make.core.makefile.IMakefileValidator;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefileValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class GNUMakefileChecker
extends ACBuilder {
    protected Map validatorMap = new HashMap();

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        IResourceDelta iResourceDelta = null;
        if (n != 6) {
            iResourceDelta = this.getDelta(this.getProject());
        }
        if (iResourceDelta == null || n == 6) {
            this.checkProject(this.getProject(), iProgressMonitor);
        } else {
            MyResourceDeltaVisitor myResourceDeltaVisitor = new MyResourceDeltaVisitor(iProgressMonitor);
            if (iResourceDelta != null) {
                iResourceDelta.accept((IResourceDeltaVisitor)myResourceDeltaVisitor);
            }
        }
        this.checkCancel(iProgressMonitor);
        return new IProject[0];
    }

    public void checkCancel(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void checkProject(IProject iProject, IProgressMonitor iProgressMonitor) {
        IFile[] iFileArray = this.getCandidateMakefiles(iProject);
        int n = 0;
        while (n < iFileArray.length) {
            this.checkMakefile(iFileArray[n], iProgressMonitor);
            ++n;
        }
    }

    protected boolean isMakefileCandidate(IFile iFile) {
        IFile[] iFileArray = this.getCandidateMakefiles(iFile.getProject());
        int n = 0;
        while (n < iFileArray.length) {
            if (iFileArray[n].getFullPath().equals((Object)iFile.getFullPath())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void checkMakefile(IFile iFile, IProgressMonitor iProgressMonitor) {
        IMakefileValidator iMakefileValidator = this.getMakefileValidator(iFile);
        try {
            this.removeAllMarkers(iFile);
        }
        catch (CoreException coreException) {}
        iMakefileValidator.checkFile(iFile, iProgressMonitor);
    }

    protected IFile[] getCandidateMakefiles(IProject iProject) {
        IFile iFile = iProject.getFile((IPath)new Path("Makefile"));
        if (iFile.exists()) {
            return new IFile[]{iFile};
        }
        return new IFile[0];
    }

    protected IMakefileValidator getMakefileValidator(IFile iFile) {
        IMakefileValidator iMakefileValidator = (IMakefileValidator)this.validatorMap.get(iFile.getProject());
        if (iMakefileValidator == null) {
            iMakefileValidator = new GNUMakefileValidator();
            iMakefileValidator.setMarkerGenerator((IMarkerGenerator)this);
            this.validatorMap.put(iFile.getProject(), iMakefileValidator);
        }
        return iMakefileValidator;
    }

    private void removeAllMarkers(IFile iFile) throws CoreException {
        IWorkspace iWorkspace = iFile.getWorkspace();
        IMarker[] iMarkerArray = iFile.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (iMarkerArray != null) {
            iWorkspace.deleteMarkers(iMarkerArray);
        }
    }

    public class MyResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        IProgressMonitor monitor;

        public MyResourceDeltaVisitor(IProgressMonitor iProgressMonitor) {
            this.monitor = iProgressMonitor;
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IFile iFile;
            IResource iResource = iResourceDelta.getResource();
            if (iResource != null && iResource.getProject() == GNUMakefileChecker.this.getProject() && iResource instanceof IFile && GNUMakefileChecker.this.isMakefileCandidate(iFile = (IFile)iResource) && iResourceDelta.getKind() != 2) {
                GNUMakefileChecker.this.checkMakefile(iFile, this.monitor);
            }
            return true;
        }
    }
}

