/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.make.internal.ui.editor.IMakefileDocumentProvider;
import org.eclipse.cdt.make.internal.ui.editor.MakefileDocumentProvider;
import org.eclipse.cdt.make.internal.ui.editor.WorkingCopyManager;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.cdt.make.ui.actions.UpdateMakeProjectAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MakeUIPlugin
extends AbstractUIPlugin
implements IStartup {
    private static MakeUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private IWorkingCopyManager fWorkingCopyManager;
    private IMakefileDocumentProvider fMakefileDocumentProvider;

    public MakeUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.make.internal.ui.MakeResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static MakeUIPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return MakeUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = MakeUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return MakeUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = MakeUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = MakeUIPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (MakeUIPlugin.getDefault() == null) {
            return "org.eclipse.cdt.make.ui";
        }
        return MakeUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void log(IStatus iStatus) {
        ResourcesPlugin.getPlugin().getLog().log(iStatus);
    }

    public static void logErrorMessage(String string) {
        MakeUIPlugin.log((IStatus)new Status(4, MakeUIPlugin.getUniqueIdentifier(), 4, string, null));
    }

    public static void logException(Throwable throwable, final String string, String string2) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        IStatus iStatus = null;
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
        } else {
            if (string2 == null) {
                string2 = throwable.getMessage();
            }
            if (string2 == null) {
                string2 = throwable.toString();
            }
            iStatus = new Status(4, MakeUIPlugin.getUniqueIdentifier(), 0, string2, throwable);
        }
        ResourcesPlugin.getPlugin().getLog().log(iStatus);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final IStatus iStatus2 = iStatus;
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)string, null, (IStatus)iStatus2);
            }
        });
    }

    public static void logException(Throwable throwable) {
        MakeUIPlugin.logException(throwable, null, null);
    }

    public static void log(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        Object object = null;
        object = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, MakeUIPlugin.getUniqueIdentifier(), 0, throwable.getMessage(), throwable);
        MakeUIPlugin.log(object);
    }

    public static void errorDialog(Shell shell, String string, String string2, IStatus iStatus) {
        MakeUIPlugin.log(iStatus);
        if (iStatus != null && string2.equals(iStatus.getMessage())) {
            string2 = null;
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public static void errorDialog(Shell shell, String string, String string2, Throwable throwable) {
        IStatus iStatus;
        MakeUIPlugin.log(throwable);
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
            if (iStatus != null && string2.equals(iStatus.getMessage())) {
                string2 = null;
            }
        } else {
            iStatus = new Status(4, MakeUIPlugin.getUniqueIdentifier(), -1, "Internal Error: ", throwable);
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public void earlyStartup() {
        final IProject[] iProjectArray = UpdateMakeProjectAction.getOldProjects();
        if (iProjectArray.length > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (MessageDialog.openQuestion((Shell)MakeUIPlugin.this.getShell(), (String)MakeUIPlugin.getResourceString("MakeUIPlugin.update_project"), (String)MakeUIPlugin.getResourceString("MakeUIPlugin.update_project_message"))) {
                        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(MakeUIPlugin.this.getShell());
                        UpdateMakeProjectAction.run(false, (IRunnableContext)progressMonitorDialog, iProjectArray);
                    }
                }
            });
        }
    }

    protected Shell getShell() {
        if (MakeUIPlugin.getActiveWorkbenchShell() != null) {
            return MakeUIPlugin.getActiveWorkbenchShell();
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = MakeUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return iWorkbenchWindowArray[0].getShell();
    }

    public synchronized IMakefileDocumentProvider getMakefileDocumentProvider() {
        if (this.fMakefileDocumentProvider == null) {
            this.fMakefileDocumentProvider = new MakefileDocumentProvider();
        }
        return this.fMakefileDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            IMakefileDocumentProvider iMakefileDocumentProvider = this.getMakefileDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(iMakefileDocumentProvider);
        }
        return this.fWorkingCopyManager;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        if (this.fWorkingCopyManager != null) {
            this.fWorkingCopyManager.shutdown();
            this.fWorkingCopyManager = null;
        }
    }
}

