/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileContentOutlinePage;
import org.eclipse.cdt.make.ui.dialogs.MakeTargetDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;

public class AddBuildTargetAction
extends Action {
    MakefileContentOutlinePage fOutliner;
    static final ITargetRule[] EMPTY_TARGET_RULES = new ITargetRule[0];

    public AddBuildTargetAction(MakefileContentOutlinePage makefileContentOutlinePage) {
        super(MakeUIPlugin.getResourceString("AddBuildTargetAction.title"));
        this.setDescription(MakeUIPlugin.getResourceString("AddBuildTargetAction.description"));
        this.setToolTipText(MakeUIPlugin.getResourceString("AddBuildTargetAction.tooltip"));
        this.fOutliner = makefileContentOutlinePage;
    }

    public void run() {
        IMakeTargetManager iMakeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        IFile iFile = this.getFile();
        Shell shell = this.fOutliner.getControl().getShell();
        ITargetRule[] iTargetRuleArray = this.getTargetRules(this.fOutliner.getSelection());
        if (iFile != null && iTargetRuleArray.length > 0 && shell != null) {
            Object object;
            IMakeTarget iMakeTarget;
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            while (n < iTargetRuleArray.length) {
                string = iTargetRuleArray[n].getTarget().toString().trim();
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append('_').append(string);
                }
                if (stringBuffer2.length() == 0) {
                    stringBuffer2.append(string);
                } else {
                    stringBuffer2.append(' ').append(string);
                }
                ++n;
            }
            String string2 = stringBuffer.toString();
            string = stringBuffer2.toString();
            try {
                iMakeTarget = iMakeTargetManager.findTarget(iFile.getParent(), string2);
                if (iMakeTarget == null && ((String[])(object = iMakeTargetManager.getTargetBuilders(iFile.getProject()))).length > 0) {
                    iMakeTarget = iMakeTargetManager.createTarget(iFile.getProject(), string2, object[0]);
                    iMakeTarget.setBuildTarget(string);
                    iMakeTargetManager.addTarget(iFile.getParent(), iMakeTarget);
                }
            }
            catch (CoreException coreException) {
                MakeUIPlugin.errorDialog(shell, MakeUIPlugin.getResourceString("AddBuildTargetAction.exception.internal"), coreException.toString(), coreException);
                iMakeTarget = null;
            }
            if (iMakeTarget != null) {
                try {
                    object = new MakeTargetDialog(shell, iMakeTarget);
                    object.open();
                }
                catch (CoreException coreException) {
                    MakeUIPlugin.errorDialog(shell, MakeUIPlugin.getResourceString("AddBuildTargetAction.exception.internal"), coreException.toString(), coreException);
                }
            }
        }
    }

    public boolean canActionBeAdded(ISelection iSelection) {
        ITargetRule[] iTargetRuleArray = this.getTargetRules(iSelection);
        int n = 0;
        while (n < iTargetRuleArray.length) {
            IFile iFile = this.getFile();
            if (iFile == null) {
                return false;
            }
            if (!MakeCorePlugin.getDefault().getTargetManager().hasTargetBuilder(iFile.getProject())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private IFile getFile() {
        Object object = this.fOutliner.getInput();
        if (object instanceof IFileEditorInput) {
            return ((IFileEditorInput)object).getFile();
        }
        return null;
    }

    private ITargetRule[] getTargetRules(ISelection iSelection) {
        List list;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (list = ((IStructuredSelection)iSelection).toList()).size() > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            Object[] objectArray = list.toArray();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof ITargetRule) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(EMPTY_TARGET_RULES);
        }
        return EMPTY_TARGET_RULES;
    }
}

