/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IRule;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.text.CompletionProposalComparator;
import org.eclipse.cdt.make.internal.ui.text.WordPartDetector;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class MakefileCompletionProcessor
implements IContentAssistProcessor {
    protected IContextInformationValidator fValidator = new Validator();
    protected Image imageMacro = MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_MACRO);
    protected Image imageTarget = MakeUIImages.getImage(MakeUIImages.IMG_OBJS_MAKEFILE_TARGET_RULE);
    protected CompletionProposalComparator comparator = new CompletionProposalComparator();
    protected IEditorPart fEditor;
    protected IWorkingCopyManager fManager;

    public MakefileCompletionProcessor(IEditorPart iEditorPart) {
        this.fEditor = iEditorPart;
        this.fManager = MakeUIPlugin.getDefault().getWorkingCopyManager();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        Object object;
        WordPartDetector wordPartDetector = new WordPartDetector(iTextViewer, n);
        boolean bl = WordPartDetector.inMacro(iTextViewer, n);
        IMakefile iMakefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        IDirective[] iDirectiveArray = null;
        if (bl) {
            object = iMakefile.getMacroDefinitions();
            IMacroDefinition[] iMacroDefinitionArray = iMakefile.getBuiltinMacroDefinitions();
            iDirectiveArray = new IDirective[((IMacroDefinition[])object).length + iMacroDefinitionArray.length];
            System.arraycopy(object, 0, iDirectiveArray, 0, ((IMacroDefinition[])object).length);
            System.arraycopy(iMacroDefinitionArray, 0, iDirectiveArray, ((Object)object).length, iMacroDefinitionArray.length);
        } else {
            iDirectiveArray = iMakefile.getTargetRules();
        }
        object = new ArrayList(iDirectiveArray.length);
        int n2 = 0;
        while (n2 < iDirectiveArray.length) {
            String string = null;
            Image image = null;
            String string2 = "";
            if (iDirectiveArray[n2] instanceof IMacroDefinition) {
                string = ((IMacroDefinition)iDirectiveArray[n2]).getName();
                image = this.imageMacro;
                string2 = ((IMacroDefinition)iDirectiveArray[n2]).getValue().toString();
            } else if (iDirectiveArray[n2] instanceof IRule) {
                string = ((IRule)iDirectiveArray[n2]).getTarget().toString();
                image = this.imageTarget;
                string2 = string;
            }
            if (string != null && string.startsWith(wordPartDetector.toString())) {
                ContextInformation contextInformation = new ContextInformation(string, string2);
                String string3 = string.equals(string2) ? string : String.valueOf(string) + " - " + string2;
                CompletionProposal completionProposal = new CompletionProposal(string, wordPartDetector.getOffset(), wordPartDetector.toString().length(), string.length(), image, string3, (IContextInformation)contextInformation, string2);
                ((ArrayList)object).add(completionProposal);
            }
            ++n2;
        }
        ICompletionProposal[] iCompletionProposalArray = ((ArrayList)object).toArray(new ICompletionProposal[0]);
        Arrays.sort(iCompletionProposalArray, this.comparator);
        return iCompletionProposalArray;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        String string;
        int n2;
        IMacroDefinition[] iMacroDefinitionArray;
        WordPartDetector wordPartDetector = new WordPartDetector(iTextViewer, n);
        boolean bl = WordPartDetector.inMacro(iTextViewer, n);
        IMakefile iMakefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            String string2;
            iMacroDefinitionArray = iMakefile.getMacroDefinitions();
            n2 = 0;
            while (n2 < iMacroDefinitionArray.length) {
                if (iMacroDefinitionArray[n2] instanceof IMacroDefinition && (string = iMacroDefinitionArray[n2].getName()) != null && string.equals(wordPartDetector.toString()) && (string2 = iMacroDefinitionArray[n2].getValue().toString()) != null && string2.length() > 0) {
                    arrayList.add(string2);
                }
                ++n2;
            }
            iMacroDefinitionArray = iMakefile.getBuiltinMacroDefinitions();
            n2 = 0;
            while (n2 < iMacroDefinitionArray.length) {
                if (iMacroDefinitionArray[n2] instanceof IMacroDefinition && (string = iMacroDefinitionArray[n2].getName()) != null && string.equals(wordPartDetector.toString()) && (string2 = iMacroDefinitionArray[n2].getValue().toString()) != null && string2.length() > 0) {
                    arrayList.add(string2);
                }
                ++n2;
            }
        }
        iMacroDefinitionArray = new IContextInformation[arrayList.size()];
        n2 = 0;
        while (n2 < iMacroDefinitionArray.length) {
            string = (String)arrayList.get(n2);
            iMacroDefinitionArray[n2] = new ContextInformation(this.imageMacro, wordPartDetector.toString(), string);
            ++n2;
        }
        return iMacroDefinitionArray;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int n) {
            return Math.abs(this.fInstallOffset - n) < 5;
        }

        public void install(IContextInformation iContextInformation, ITextViewer iTextViewer, int n) {
            this.fInstallOffset = n;
        }

        public boolean updatePresentation(int n, TextPresentation textPresentation) {
            return false;
        }
    }

    public class DirectiveComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = object instanceof IMacroDefinition ? ((IMacroDefinition)object).getName() : (object instanceof IRule ? ((IRule)object).getTarget().toString() : "");
            String string2 = object2 instanceof IMacroDefinition ? ((IMacroDefinition)object).getName() : (object2 instanceof IRule ? ((IRule)object).getTarget().toString() : "");
            return string.compareToIgnoreCase(string2);
        }
    }
}

