/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MakeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private IPath pathPrefix;
    WorkbenchLabelProvider fLableProvider = new WorkbenchLabelProvider();

    public MakeLabelProvider() {
        this(null);
    }

    public MakeLabelProvider(IPath iPath) {
        this.pathPrefix = iPath;
    }

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof IMakeTarget) {
            return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_BUILD_TARGET);
        }
        if (object instanceof IContainer) {
            return this.fLableProvider.getImage(object);
        }
        return image;
    }

    public String getText(Object object) {
        if (object instanceof IMakeTarget) {
            return ((IMakeTarget)object).getName();
        }
        if (object instanceof IContainer) {
            return this.fLableProvider.getText(object);
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        this.fLableProvider.dispose();
    }

    public Image getColumnImage(Object object, int n) {
        return n == 0 ? this.getImage(object) : null;
    }

    public String getColumnText(Object object, int n) {
        switch (n) {
            case 0: {
                return this.getText(object);
            }
            case 1: {
                if (!(object instanceof IMakeTarget) || this.pathPrefix == null) break;
                IPath iPath = ((IMakeTarget)object).getContainer().getProjectRelativePath();
                if (this.pathPrefix.isPrefixOf(iPath)) {
                    iPath = iPath.removeFirstSegments(this.pathPrefix.segmentCount());
                }
                if (iPath.segmentCount() <= 0) break;
                return iPath.toString();
            }
        }
        return "";
    }
}

