/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.cdt.make.core.MakeScannerProvider;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPathInfoBlock
extends AbstractCOptionPage {
    private static final int PROJECT_LIST_MULTIPLIER = 10;
    private static final String PREF_SYMBOLS = "ScannerSymbols";
    private static final String PREF_INCLUDES = "ScannerIncludes";
    private static final String PREFIX = "BuildPathInfoBlock";
    private static final String LABEL = "BuildPathInfoBlock.label";
    private static final String PATHS = "BuildPathInfoBlock.paths";
    private static final String SYMBOLS = "BuildPathInfoBlock.symbols";
    private static final String BROWSE = "BuildPathInfoBlock.browse";
    private static final String PATH_TITLE = "BuildPathInfoBlock.browse.path";
    private static final String EDIT_PATH_TITLE = "BuildPathInfoBlock.browse.path.edit";
    private static final String PATH_LABEL = "BuildPathInfoBlock.browse.path.label";
    private static final String SYMBOL_TITLE = "BuildPathInfoBlock.browse.symbol";
    private static final String EDIT_SYMBOL_TITLE = "BuildPathInfoBlock.browse.symbol.edit";
    private static final String SYMBOL_LABEL = "BuildPathInfoBlock.browse.symbol.label";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String EDIT = "BuildPropertyCommon.label.edit";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String UP = "BuildPropertyCommon.label.up";
    private static final String DOWN = "BuildPropertyCommon.label.down";
    private List pathList;
    private List symbolList;
    private Composite pathButtonComp;
    private Button addPath;
    private Button editPath;
    private Button removePath;
    private Button pathUp;
    private Button pathDown;
    private Composite symbolButtonComp;
    private Button addSymbol;
    private Button editSymbol;
    private Button removeSymbol;
    private Button symbolUp;
    private Button symbolDown;
    private Shell shell;

    public BuildPathInfoBlock() {
        super(MakeUIPlugin.getResourceString(LABEL));
        this.setDescription(MakeUIPlugin.getResourceString("BuildPathInfoBlock.description"));
    }

    private void createPathListButtons(Composite composite) {
        this.pathButtonComp = ControlFactory.createComposite((Composite)composite, (int)1);
        this.pathButtonComp.setFont(composite.getFont());
        this.addPath = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)MakeUIPlugin.getResourceString(NEW));
        this.addPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleAddPath();
            }
        });
        this.addPath.setEnabled(true);
        this.addPath.setFont(composite.getFont());
        this.addPath.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.addPath);
        this.editPath = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)MakeUIPlugin.getResourceString(EDIT));
        this.editPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.editPathListItem();
            }
        });
        this.editPath.setEnabled(true);
        this.editPath.setFont(composite.getFont());
        this.editPath.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.editPath);
        this.removePath = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)MakeUIPlugin.getResourceString(REMOVE));
        this.removePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleRemovePath();
            }
        });
        this.removePath.setFont(composite.getFont());
        this.removePath.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.removePath);
        this.pathUp = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)MakeUIPlugin.getResourceString(UP));
        this.pathUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handlePathUp();
            }
        });
        this.pathUp.setFont(composite.getFont());
        this.pathUp.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.pathUp);
        this.pathDown = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)MakeUIPlugin.getResourceString(DOWN));
        this.pathDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handlePathDown();
            }
        });
        this.pathDown.setFont(composite.getFont());
        this.pathDown.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.pathDown);
    }

    private void createPathListControl(Composite composite, int n) {
        this.pathList = new List(composite, 2820);
        this.pathList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.enablePathButtons();
            }
        });
        this.pathList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                BuildPathInfoBlock.this.editPathListItem();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = n - 1;
        gridData.heightHint = BuildPathInfoBlock.getDefaultFontHeight((Control)this.pathList, 10);
        this.pathList.setLayoutData((Object)gridData);
        this.pathList.setFont(composite.getFont());
    }

    private static int getDefaultFontHeight(Control control, int n) {
        FontData[] fontDataArray = control.getFont().getFontData();
        int n2 = 10;
        if (fontDataArray.length > 0) {
            n2 = fontDataArray[0].getHeight();
        }
        return n * n2;
    }

    private void createSymbolListButtons(Composite composite) {
        this.symbolButtonComp = ControlFactory.createComposite((Composite)composite, (int)1);
        this.symbolButtonComp.setFont(composite.getFont());
        this.addSymbol = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)MakeUIPlugin.getResourceString(NEW));
        this.addSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleAddSymbol();
            }
        });
        this.addSymbol.setEnabled(true);
        this.addSymbol.setFont(composite.getFont());
        this.addSymbol.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.addSymbol);
        this.editSymbol = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)MakeUIPlugin.getResourceString(EDIT));
        this.editSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.editSymbolListItem();
            }
        });
        this.editSymbol.setEnabled(true);
        this.editSymbol.setFont(composite.getFont());
        this.editSymbol.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.editSymbol);
        this.removeSymbol = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)MakeUIPlugin.getResourceString(REMOVE));
        this.removeSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleRemoveSymbol();
            }
        });
        this.removeSymbol.setFont(composite.getFont());
        this.removeSymbol.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.removeSymbol);
        this.symbolUp = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)MakeUIPlugin.getResourceString(UP));
        this.symbolUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleSymbolUp();
            }
        });
        this.symbolUp.setFont(composite.getFont());
        this.symbolUp.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.symbolUp);
        this.symbolDown = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)MakeUIPlugin.getResourceString(DOWN));
        this.symbolDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleSymbolDown();
            }
        });
        this.symbolDown.setFont(composite.getFont());
        this.symbolDown.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.symbolDown);
    }

    private void createSymbolListControl(Composite composite, int n) {
        this.symbolList = new List(composite, 2820);
        this.symbolList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.enableSymbolButtons();
            }
        });
        this.symbolList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                BuildPathInfoBlock.this.editSymbolListItem();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = n - 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = BuildPathInfoBlock.getDefaultFontHeight((Control)this.pathList, 10);
        this.symbolList.setLayoutData((Object)gridData);
        this.symbolList.setFont(composite.getFont());
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (this.getContainer().getProject() != null) {
            iProgressMonitor.beginTask(MakeUIPlugin.getResourceString("BuildPathInfoBlock.monitor.settingScannerInfo"), 3);
            MakeScannerInfo makeScannerInfo = MakeScannerProvider.getDefault().getMakeScannerInfo(this.getContainer().getProject(), false);
            makeScannerInfo.setIncludePaths(this.getPathListContents());
            iProgressMonitor.worked(1);
            makeScannerInfo.setPreprocessorSymbols(this.getSymbolListContents());
            iProgressMonitor.worked(1);
            makeScannerInfo.update();
            iProgressMonitor.done();
        } else {
            this.setIncludes(MakeCorePlugin.getDefault().getPluginPreferences());
            this.setSymbols(MakeCorePlugin.getDefault().getPluginPreferences());
        }
    }

    public void performDefaults() {
        this.pathList.removeAll();
        this.symbolList.removeAll();
        if (this.getContainer().getProject() != null) {
            this.pathList.setItems(this.getIncludes(MakeCorePlugin.getDefault().getPluginPreferences()));
            this.symbolList.setItems(this.getSymbols(MakeCorePlugin.getDefault().getPluginPreferences()));
        }
        this.getContainer().updateContainer();
    }

    private void setSymbols(Preferences preferences) {
        preferences.setValue(PREF_SYMBOLS, this.stringArrayToString(this.getSymbolListContents()));
    }

    private void setIncludes(Preferences preferences) {
        preferences.setValue(PREF_INCLUDES, this.stringArrayToString(this.getPathListContents()));
    }

    private String stringArrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]).append(';');
            ++n;
        }
        return stringBuffer.toString();
    }

    private String[] getSymbols(Preferences preferences) {
        String string = preferences.getString(PREF_SYMBOLS);
        return this.parseStringToList(string);
    }

    private String[] getIncludes(Preferences preferences) {
        String string = preferences.getString(PREF_INCLUDES);
        return this.parseStringToList(string);
    }

    private String[] parseStringToList(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    protected void editPathListItem() {
        String string;
        int n = this.pathList.getSelectionIndex();
        if (n != -1 && (string = this.pathList.getItem(n)) != null) {
            SelectPathInputDialog selectPathInputDialog = new SelectPathInputDialog(this.shell, MakeUIPlugin.getResourceString(EDIT_PATH_TITLE), MakeUIPlugin.getResourceString(PATH_LABEL), string, null);
            String string2 = null;
            if (selectPathInputDialog.open() == 0 && (string2 = selectPathInputDialog.getValue()) != null && !string2.equals(string)) {
                this.pathList.setItem(n, string2);
            }
        }
    }

    protected void editSymbolListItem() {
        String string;
        int n = this.symbolList.getSelectionIndex();
        if (n != -1 && (string = this.symbolList.getItem(n)) != null) {
            InputDialog inputDialog = new InputDialog(this.shell, MakeUIPlugin.getResourceString(EDIT_SYMBOL_TITLE), MakeUIPlugin.getResourceString(SYMBOL_LABEL), string, null);
            String string2 = null;
            if (inputDialog.open() == 0 && (string2 = inputDialog.getValue()) != null && !string2.equals(string)) {
                this.symbolList.setItem(n, string2);
            }
        }
    }

    void enablePathButtons() {
        int n = this.pathList.getItemCount();
        if (n > 0) {
            this.editPath.setEnabled(true);
            this.removePath.setEnabled(true);
            int n2 = this.pathList.getSelectionIndex();
            this.pathUp.setEnabled(n > 1 && n2 > 0);
            this.pathDown.setEnabled(n > 1 && n2 < n - 1);
        } else {
            this.editPath.setEnabled(false);
            this.removePath.setEnabled(false);
            this.pathUp.setEnabled(false);
            this.pathDown.setEnabled(false);
        }
    }

    void enableSymbolButtons() {
        int n = this.symbolList.getItemCount();
        if (n > 0) {
            this.editSymbol.setEnabled(true);
            this.removeSymbol.setEnabled(true);
            int n2 = this.symbolList.getSelectionIndex();
            this.symbolUp.setEnabled(n > 1 && n2 > 0);
            this.symbolDown.setEnabled(n > 1 && n2 < n - 1);
        } else {
            this.editSymbol.setEnabled(false);
            this.removeSymbol.setEnabled(false);
            this.symbolUp.setEnabled(false);
            this.symbolDown.setEnabled(false);
        }
    }

    public void createControl(Composite composite) {
        int n = 3;
        Font font = composite.getFont();
        Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)n);
        composite2.setFont(font);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.MAKE_PATH_SYMBOL_SETTINGS);
        Label label = ControlFactory.createLabel((Composite)composite2, (String)MakeUIPlugin.getResourceString(PATHS));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        this.createPathListControl(composite2, n);
        this.createPathListButtons(composite2);
        this.enablePathButtons();
        Label label2 = ControlFactory.createLabel((Composite)composite2, (String)MakeUIPlugin.getResourceString(SYMBOLS));
        gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label2.setLayoutData((Object)gridData);
        label2.setFont(font);
        this.createSymbolListControl(composite2, n);
        this.createSymbolListButtons(composite2);
        this.enableSymbolButtons();
        this.setListContents();
        this.pathList.select(0);
        this.enablePathButtons();
        this.symbolList.select(0);
        this.enableSymbolButtons();
    }

    private String[] getPathListContents() {
        return this.pathList.getItems();
    }

    private String[] getSymbolListContents() {
        return this.symbolList.getItems();
    }

    protected void handleAddPath() {
        SelectPathInputDialog selectPathInputDialog = new SelectPathInputDialog(this.shell, MakeUIPlugin.getResourceString(PATH_TITLE), MakeUIPlugin.getResourceString(PATH_LABEL), "", null);
        String string = null;
        if (selectPathInputDialog.open() == 0) {
            string = selectPathInputDialog.getValue();
        }
        if (string != null && string.length() > 0) {
            this.pathList.add(string);
            this.pathList.select(this.pathList.getItemCount() - 1);
            this.enablePathButtons();
        }
    }

    protected void handleAddSymbol() {
        InputDialog inputDialog = new InputDialog(this.shell, MakeUIPlugin.getResourceString(SYMBOL_TITLE), MakeUIPlugin.getResourceString(SYMBOL_LABEL), "", null);
        String string = null;
        if (inputDialog.open() == 0) {
            string = inputDialog.getValue();
        }
        if (string != null && string.length() > 0) {
            this.symbolList.add(string);
            this.symbolList.select(this.symbolList.getItemCount() - 1);
            this.enableSymbolButtons();
        }
    }

    protected void handlePathDown() {
        int n = this.pathList.getSelectionIndex();
        int n2 = this.pathList.getItemCount();
        if (n == -1 || n == n2 - 1) {
            return;
        }
        String string = this.pathList.getItem(n);
        this.pathList.remove(n);
        if (n + 1 == n2) {
            this.pathList.add(string);
        } else {
            this.pathList.add(string, ++n);
        }
        this.pathList.select(n);
        this.enablePathButtons();
    }

    protected void handlePathUp() {
        int n = this.pathList.getSelectionIndex();
        if (n == -1 || n == 0) {
            return;
        }
        String string = this.pathList.getItem(n);
        this.pathList.remove(n);
        this.pathList.add(string, --n);
        this.pathList.select(n);
        this.enablePathButtons();
    }

    protected void handleRemovePath() {
        int n = this.pathList.getSelectionIndex();
        if (n == -1) {
            return;
        }
        this.pathList.remove(n);
        n = n - 1 < 0 ? 0 : n - 1;
        this.pathList.select(n);
        this.enablePathButtons();
    }

    protected void handleRemoveSymbol() {
        int n = this.symbolList.getSelectionIndex();
        if (n == -1) {
            return;
        }
        this.symbolList.remove(n);
        n = n - 1 < 0 ? 0 : n - 1;
        this.symbolList.select(n);
        this.enableSymbolButtons();
    }

    protected void handleSymbolDown() {
        int n = this.symbolList.getSelectionIndex();
        int n2 = this.symbolList.getItemCount();
        if (n == -1 || n == n2 - 1) {
            return;
        }
        String string = this.symbolList.getItem(n);
        this.symbolList.remove(n);
        if (n + 1 == n2) {
            this.symbolList.add(string);
        } else {
            this.symbolList.add(string, ++n);
        }
        this.symbolList.select(n);
        this.enableSymbolButtons();
    }

    protected void handleSymbolUp() {
        int n = this.symbolList.getSelectionIndex();
        if (n == -1 || n == 0) {
            return;
        }
        String string = this.symbolList.getItem(n);
        this.symbolList.remove(n);
        this.symbolList.add(string, --n);
        this.symbolList.select(n);
        this.enableSymbolButtons();
    }

    public boolean isValid() {
        return true;
    }

    private void setListContents() {
        if (this.getContainer().getProject() != null) {
            try {
                MakeScannerInfo makeScannerInfo = MakeScannerProvider.getDefault().getMakeScannerInfo(this.getContainer().getProject(), false);
                this.pathList.setItems(makeScannerInfo.getIncludePaths());
                this.symbolList.setItems(makeScannerInfo.getPreprocessorSymbols());
            }
            catch (CoreException coreException) {}
        } else {
            this.pathList.setItems(this.getIncludes(MakeCorePlugin.getDefault().getPluginPreferences()));
            this.symbolList.setItems(this.getSymbols(MakeCorePlugin.getDefault().getPluginPreferences()));
        }
    }

    class SelectPathInputDialog
    extends InputDialog {
        public SelectPathInputDialog(Shell shell, String string, String string2, String string3, IInputValidator iInputValidator) {
            super(shell, string, string2, string3, iInputValidator);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            super.createButtonsForButtonBar(composite);
            Button button = this.createButton(composite, 3, MakeUIPlugin.getResourceString("BuildPathInfoBlock.button.browse"), true);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SelectPathInputDialog this$1;
                {
                    this.this$1 = selectPathInputDialog;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string;
                    DirectoryDialog directoryDialog = new DirectoryDialog(this.this$1.getShell(), 4096);
                    String string2 = SelectPathInputDialog.access$0(this.this$1).getText();
                    if (string2 != null && string2.trim().length() != 0) {
                        directoryDialog.setFilterPath(string2);
                    }
                    if ((string = directoryDialog.open()) != null) {
                        SelectPathInputDialog.access$0(this.this$1).setText(string);
                    }
                }
            });
        }

        static /* synthetic */ Text access$0(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getText();
        }
    }
}

