/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.TargetBuild;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class BuildTargetAction
extends SelectionListenerAction {
    Shell shell;
    IResource resource;

    public BuildTargetAction(Shell shell) {
        super(MakeUIPlugin.getResourceString("BuildTargetAction.label"));
        this.shell = shell;
        this.setToolTipText(MakeUIPlugin.getResourceString("BuildTargetAction.tooltip"));
        MakeUIImages.setImageDescriptors((IAction)this, "tool16", MakeUIImages.IMG_TOOLS_MAKE_TARGET_BUILD);
    }

    public void run() {
        if (this.canBuild()) {
            IMakeTarget[] iMakeTargetArray = this.getSelectedElements().toArray(new IMakeTarget[0]);
            TargetBuild.runWithProgressDialog(this.shell, iMakeTargetArray);
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return super.updateSelection(iStructuredSelection) && this.canBuild();
    }

    private boolean canBuild() {
        List list = this.getSelectedElements();
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMakeTarget) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List getSelectedElements() {
        return this.getStructuredSelection().toList();
    }
}

