/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.wizards;

import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.part.WizardCheckboxTablePart;
import org.eclipse.cdt.make.internal.ui.wizards.StatusWizardPage;
import org.eclipse.cdt.make.ui.actions.UpdateMakeProjectAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class UpdateMakeProjectWizardPage
extends StatusWizardPage {
    private static final String MAKE_UPDATE_TITLE = "MakeWizardUpdatePage.title";
    private static final String MAKE_UPDATE_DESCRIPTION = "MakeWizardUpdatePage.description";
    private IProject[] selected;
    private CheckboxTableViewer makeProjectListViewer;
    private TablePart tablePart;

    public UpdateMakeProjectWizardPage(IProject[] iProjectArray) {
        super("UpdateMakeProjectWizardPage", true);
        this.setTitle(MakeUIPlugin.getResourceString(MAKE_UPDATE_TITLE));
        this.setDescription(MakeUIPlugin.getResourceString(MAKE_UPDATE_DESCRIPTION));
        this.selected = iProjectArray;
        this.tablePart = new TablePart(MakeUIPlugin.getResourceString("MakeWizardUpdatePage.projectList"));
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 5;
        composite2.setLayout((Layout)gridLayout);
        this.tablePart.createControl(composite2);
        this.makeProjectListViewer = this.tablePart.getTableViewer();
        this.makeProjectListViewer.setContentProvider((IContentProvider)new MakeProjectContentProvider());
        this.makeProjectListViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        GridData gridData = (GridData)this.tablePart.getControl().getLayoutData();
        gridData.heightHint = 300;
        gridData.widthHint = 300;
        this.makeProjectListViewer.setInput((Object)MakeUIPlugin.getWorkspace().getRoot());
        this.tablePart.setSelection(this.selected);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public void storeSettings() {
    }

    public Object[] getSelected() {
        return this.tablePart.getSelection();
    }

    void dialogChanged() {
        IStatus iStatus = this.validatePlugins();
        this.updateStatus(iStatus);
    }

    private IStatus validatePlugins() {
        IProject[] iProjectArray = UpdateMakeProjectAction.getOldProjects();
        if (iProjectArray == null || iProjectArray.length == 0) {
            return StatusWizardPage.createStatus(4, MakeUIPlugin.getResourceString("MakeWizardUpdatePage.status.noProjectsToUpdate"));
        }
        if (this.tablePart.getSelectionCount() == 0) {
            return StatusWizardPage.createStatus(4, MakeUIPlugin.getResourceString("MakeWizardUpdatePage.status.noProjectsSelected"));
        }
        return StatusWizardPage.createStatus(0, "");
    }

    public class MakeProjectContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object object) {
            return UpdateMakeProjectAction.getOldProjects();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String string) {
            super(string);
        }

        public void updateCounter(int n) {
            super.updateCounter(n);
            UpdateMakeProjectWizardPage.this.dialogChanged();
        }

        protected StructuredViewer createStructuredViewer(Composite composite, int n) {
            StructuredViewer structuredViewer = super.createStructuredViewer(composite, n);
            return structuredViewer;
        }
    }
}

