/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionListFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.SummaryFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;

public class BuildOptionSettingsPage
extends BuildSettingsPage {
    private IOptionCategory category;

    BuildOptionSettingsPage(IConfiguration iConfiguration, IOptionCategory iOptionCategory) {
        super(iConfiguration);
        this.category = iOptionCategory;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        IOption[] iOptionArray = this.category.getOptions(this.configuration);
        int n = 0;
        while (n < iOptionArray.length) {
            IOption iOption = iOptionArray[n];
            switch (iOption.getValueType()) {
                case 2: {
                    StringFieldEditor stringFieldEditor = new StringFieldEditor(iOption.getId(), iOption.getName(), this.getFieldEditorParent());
                    this.addField((FieldEditor)stringFieldEditor);
                    break;
                }
                case 0: {
                    BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor(iOption.getId(), iOption.getName(), this.getFieldEditorParent());
                    this.addField((FieldEditor)booleanFieldEditor);
                    break;
                }
                case 1: {
                    String string;
                    try {
                        string = iOption.getSelectedEnum();
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    BuildOptionComboFieldEditor buildOptionComboFieldEditor = new BuildOptionComboFieldEditor(iOption.getId(), iOption.getName(), iOption.getApplicableValues(), string, this.getFieldEditorParent());
                    this.addField(buildOptionComboFieldEditor);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    BuildOptionListFieldEditor buildOptionListFieldEditor = new BuildOptionListFieldEditor(iOption.getId(), iOption.getName(), this.getFieldEditorParent());
                    this.addField(buildOptionListFieldEditor);
                    break;
                }
                default: {
                    SummaryFieldEditor summaryFieldEditor = new SummaryFieldEditor(iOption.getId(), iOption.getName(), this.category.getTool(), this.getFieldEditorParent());
                    this.addField(summaryFieldEditor);
                }
            }
            ++n;
        }
    }

    public boolean isForCategory(IOptionCategory iOptionCategory) {
        if (iOptionCategory != null) {
            return iOptionCategory.equals(this.category);
        }
        return false;
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        IOption[] iOptionArray = this.category.getOptions(this.configuration);
        int n = 0;
        while (n < iOptionArray.length) {
            IOption iOption = iOptionArray[n];
            switch (iOption.getValueType()) {
                case 0: {
                    boolean bl2 = this.getPreferenceStore().getBoolean(iOption.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)iOption, (boolean)bl2);
                    break;
                }
                case 1: {
                    String string = this.getPreferenceStore().getString(iOption.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)iOption, (String)string);
                    break;
                }
                case 2: {
                    String string = this.getPreferenceStore().getString(iOption.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)iOption, (String)string);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String string = this.getPreferenceStore().getString(iOption.getId());
                    String[] stringArray = BuildToolsSettingsStore.parseString(string);
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)iOption, (String[])stringArray);
                    break;
                }
            }
            ++n;
        }
        return bl;
    }
}

