/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;

public class BuildToolSettingsPage
extends BuildSettingsPage {
    private static final String COMMAND = "FieldEditors.tool.command";
    private ITool tool;

    BuildToolSettingsPage(IConfiguration iConfiguration, ITool iTool) {
        super(iConfiguration);
        this.tool = iTool;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        StringFieldEditor stringFieldEditor = new StringFieldEditor(this.tool.getId(), ManagedBuilderUIPlugin.getResourceString(COMMAND), this.getFieldEditorParent());
        stringFieldEditor.setEmptyStringAllowed(false);
        this.addField((FieldEditor)stringFieldEditor);
    }

    public boolean isForTool(ITool iTool) {
        if (iTool != null) {
            return iTool.equals(this.tool);
        }
        return false;
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        String string = this.getPreferenceStore().getString(this.tool.getId());
        if (string.length() == 0) {
            return bl;
        }
        if (this.tool instanceof ToolReference) {
            ((ToolReference)this.tool).setToolCommand(string);
        } else {
            this.configuration.setToolCommand(this.tool, string);
        }
        return bl;
    }
}

