/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;

public class BuildToolsSettingsStore
implements IPreferenceStore {
    public static final String DEFAULT_SEPERATOR = ";";
    private ListenerList listenerList = new ListenerList();
    private Map settingsMap;
    private boolean dirtyFlag = false;
    private IConfiguration owner;

    public BuildToolsSettingsStore(IConfiguration iConfiguration) {
        this.owner = iConfiguration;
        this.populateSettingsMap();
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listenerList.add((Object)iPropertyChangeListener);
    }

    public boolean contains(String string) {
        return this.getSettingsMap().containsKey(string);
    }

    public static String createList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append(DEFAULT_SEPERATOR);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.listenerList.getListeners();
        if (!(objectArray.length <= 0 || object != null && object.equals(object2))) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
            int n = 0;
            while (n < objectArray.length) {
                IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
                iPropertyChangeListener.propertyChange(propertyChangeEvent);
                ++n;
            }
        }
    }

    public boolean getBoolean(String string) {
        Object v = this.getSettingsMap().get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return false;
    }

    public boolean getDefaultBoolean(String string) {
        return false;
    }

    public double getDefaultDouble(String string) {
        return 0.0;
    }

    public float getDefaultFloat(String string) {
        return 0.0f;
    }

    public int getDefaultInt(String string) {
        return 0;
    }

    public long getDefaultLong(String string) {
        return 0L;
    }

    public String getDefaultString(String string) {
        return new String();
    }

    public double getDouble(String string) {
        return this.getDefaultDouble(string);
    }

    public float getFloat(String string) {
        return this.getDefaultFloat(string);
    }

    public int getInt(String string) {
        return this.getDefaultInt(string);
    }

    public long getLong(String string) {
        return this.getDefaultLong(string);
    }

    private Map getSettingsMap() {
        if (this.settingsMap == null) {
            this.settingsMap = new HashMap();
        }
        return this.settingsMap;
    }

    private void getOptionsForCategory(IOptionCategory iOptionCategory) {
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        int n = 0;
        while (n < iOptionCategoryArray.length) {
            this.getOptionsForCategory(iOptionCategoryArray[n]);
            ++n;
        }
        IOption[] iOptionArray = iOptionCategory.getOptions(this.owner);
        int n2 = 0;
        while (n2 < iOptionArray.length) {
            IOption iOption = iOptionArray[n2];
            String string = iOption.getId();
            switch (iOption.getValueType()) {
                case 0: {
                    Object object;
                    try {
                        object = new Boolean(iOption.getBooleanValue());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getSettingsMap().put(string, object);
                    break;
                }
                case 1: {
                    Object object = BuildToolsSettingsStore.createList(iOption.getApplicableValues());
                    this.getSettingsMap().put(string, object);
                    break;
                }
                case 2: {
                    Object object;
                    try {
                        object = iOption.getStringValue();
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getSettingsMap().put(string, object);
                    break;
                }
                case 3: {
                    Object object;
                    try {
                        object = BuildToolsSettingsStore.createList(iOption.getStringListValue());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getSettingsMap().put(string, object);
                    break;
                }
                case 4: {
                    Object object;
                    try {
                        object = BuildToolsSettingsStore.createList(iOption.getIncludePaths());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getSettingsMap().put(string, object);
                    break;
                }
                case 5: {
                    Object object;
                    try {
                        object = BuildToolsSettingsStore.createList(iOption.getDefinedSymbols());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getSettingsMap().put(string, object);
                    break;
                }
                case 6: {
                    Object object;
                    try {
                        object = BuildToolsSettingsStore.createList(iOption.getLibraries());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getSettingsMap().put(string, object);
                    break;
                }
                case 7: {
                    Object object;
                    try {
                        object = BuildToolsSettingsStore.createList(iOption.getUserObjects());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getSettingsMap().put(string, object);
                    break;
                }
            }
            ++n2;
        }
    }

    public String getString(String string) {
        Object v = this.getSettingsMap().get(string);
        if (v instanceof String) {
            return (String)v;
        }
        return this.getDefaultString(string);
    }

    public boolean isDefault(String string) {
        return false;
    }

    public boolean needsSaving() {
        return this.dirtyFlag;
    }

    public static String[] parseString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_SEPERATOR);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void populateSettingsMap() {
        ITool[] iToolArray = this.owner.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            this.getSettingsMap().put(iTool.getId(), iTool.getToolCommand());
            IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
            this.getOptionsForCategory(iOptionCategory);
            ++n;
        }
    }

    public void putValue(String string, String string2) {
        Object v = this.getSettingsMap().get(string);
        if (v == null || !v.equals(string2)) {
            this.getSettingsMap().put(string, string2);
            this.setDirty(true);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
    }

    public void setDefault(String string, double d) {
    }

    public void setDefault(String string, float f) {
    }

    public void setDefault(String string, int n) {
    }

    public void setDefault(String string, long l) {
    }

    public void setDefault(String string, String string2) {
    }

    public void setDefault(String string, boolean bl) {
    }

    protected void setDirty(boolean bl) {
        this.dirtyFlag = bl;
    }

    public void setToDefault(String string) {
    }

    public void setValue(String string, double d) {
    }

    public void setValue(String string, float f) {
    }

    public void setValue(String string, int n) {
    }

    public void setValue(String string, long l) {
    }

    public void setValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || !string3.equals(string2)) {
            this.getSettingsMap().put(string, string2);
            this.setDirty(true);
            this.firePropertyChangeEvent(string, string3, string2);
        }
    }

    public void setValue(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        if (bl2 != bl) {
            this.getSettingsMap().put(string, new Boolean(bl));
            this.setDirty(true);
            this.firePropertyChangeEvent(string, new Boolean(bl2), new Boolean(bl));
        }
    }
}

