/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationDialog
extends Dialog {
    private static final String PREFIX = "NewConfiguration";
    private static final String LABEL = "NewConfiguration.label";
    private static final String ERROR = "NewConfiguration.error";
    private static final String NAME = "NewConfiguration.label.name";
    private static final String COPY = "NewConfiguration.label.copy";
    private static final String TITLE = "NewConfiguration.error.title";
    private static final String DUPLICATE = "NewConfiguration.error.duplicateName";
    private Combo configSelector;
    private Button btnOk;
    private Text configName;
    private IConfiguration[] definedConfigurations;
    private IConfiguration parentConfig;
    private ITarget target;
    private String newName;
    private String[] allNames;
    private String title = "";

    protected NewConfigurationDialog(Shell shell, IConfiguration[] iConfigurationArray, ITarget iTarget, String string) {
        super(shell);
        this.title = string;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = new String();
        this.parentConfig = null;
        this.definedConfigurations = iConfigurationArray == null ? new IConfiguration[]{} : iConfigurationArray;
        this.allNames = this.getConfigurationNames();
        this.target = iTarget;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.newName = this.configName.getText().trim();
            String string = this.configSelector.getItem(this.configSelector.getSelectionIndex());
            int n2 = 0;
            while (n2 < this.definedConfigurations.length) {
                IConfiguration iConfiguration = this.definedConfigurations[n2];
                if (iConfiguration.getName().equals(string)) {
                    this.parentConfig = iConfiguration;
                    break;
                }
                ++n2;
            }
        } else {
            this.newName = null;
            this.parentConfig = null;
        }
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.btnOk = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.updateButtonState();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)3);
        Label label = ControlFactory.createLabel((Composite)composite2, (String)ManagedBuilderUIPlugin.getResourceString(NAME));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.configName = ControlFactory.createTextField((Composite)composite2);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.configName.setLayoutData((Object)gridData);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        Label label2 = ControlFactory.createLabel((Composite)composite2, (String)ManagedBuilderUIPlugin.getResourceString(COPY));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label2.setLayoutData((Object)gridData);
        this.configSelector = ControlFactory.createSelectCombo((Composite)composite2, (String[])this.allNames, (String)this.newName);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.configSelector.setLayoutData((Object)gridData);
        this.configSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        return composite2;
    }

    public IConfiguration getParentConfiguration() {
        return this.parentConfig;
    }

    private String[] getConfigurationNames() {
        String[] stringArray = new String[this.definedConfigurations.length];
        int n = 0;
        while (n < this.definedConfigurations.length) {
            IConfiguration iConfiguration = this.definedConfigurations[n];
            stringArray[n] = iConfiguration.getName();
            ++n;
        }
        return stringArray;
    }

    public String getNewName() {
        return this.newName;
    }

    protected boolean isDuplicateName(String string) {
        IConfiguration[] iConfigurationArray = this.target.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            IConfiguration iConfiguration = iConfigurationArray[n];
            if (iConfiguration.getName() == string) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void updateButtonState() {
        if (this.btnOk != null) {
            int n = this.configSelector.getSelectionIndex();
            this.btnOk.setEnabled(this.validateName() && n != -1);
        }
    }

    private boolean validateName() {
        String string = this.configName.getText().trim();
        int n = string.length();
        if (this.isDuplicateName(string)) {
            MessageDialog.openError((Shell)this.getShell(), (String)ManagedBuilderUIPlugin.getResourceString(TITLE), (String)ManagedBuilderUIPlugin.getFormattedString(DUPLICATE, string));
            return false;
        }
        return n > 0;
    }
}

