/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.Random;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.wizards.CProjectPlatformPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectOptionPage;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class NewManagedProjectWizard
extends NewCProjectWizard {
    protected static final String PREFIX = "MngMakeProjectWizard";
    protected static final String OP_ERROR = "MngMakeProjectWizard.op_error";
    protected static final String WZ_TITLE = "MngMakeProjectWizard.title";
    protected static final String WZ_DESC = "MngMakeProjectWizard.description";
    protected static final String CONF_TITLE = "MngMakeProjectWizard.config.title";
    protected static final String CONF_DESC = "MngMakeProjectWizard.config.desc";
    protected static final String OPTIONS_TITLE = "MngMakeProjectWizard.options.title";
    protected static final String OPTIONS_DESC = "MngMakeProjectWizard.options.desc";
    protected static final String MSG_ADD_NATURE = "MngMakeProjectWizard.message.add_nature";
    protected static final String MSG_ADD_BUILDER = "MngMakeProjectWizard.message.add_builder";
    protected static final String MSG_SAVE = "MngMakeProjectWizard.message.save";
    protected static final String SETTINGS_TITLE = "MngMakeWizardSettings.title";
    protected static final String SETTINGS_DESC = "MngMakeWizardSettings.description";
    protected CProjectPlatformPage targetConfigurationPage;
    protected NewManagedProjectOptionPage optionPage;

    public NewManagedProjectWizard() {
        this(ManagedBuilderUIPlugin.getResourceString(WZ_TITLE), ManagedBuilderUIPlugin.getResourceString(WZ_DESC));
    }

    public NewManagedProjectWizard(String string, String string2) {
        super(string, string2);
    }

    public void addPages() {
        super.addPages();
        this.targetConfigurationPage = new CProjectPlatformPage(PREFIX);
        this.targetConfigurationPage.setTitle(ManagedBuilderUIPlugin.getResourceString(CONF_TITLE));
        this.targetConfigurationPage.setDescription(ManagedBuilderUIPlugin.getResourceString(CONF_DESC));
        this.addPage((IWizardPage)this.targetConfigurationPage);
        this.optionPage = new NewManagedProjectOptionPage(PREFIX);
        this.optionPage.setTitle(ManagedBuilderUIPlugin.getResourceString(OPTIONS_TITLE));
        this.optionPage.setDescription(ManagedBuilderUIPlugin.getResourceString(OPTIONS_DESC));
        this.addPage((IWizardPage)this.optionPage);
    }

    protected void doRun(IProgressMonitor iProgressMonitor) throws CoreException {
        ITarget iTarget;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        super.doRun((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 5));
        try {
            iProgressMonitor.subTask(ManagedBuilderUIPlugin.getResourceString(MSG_ADD_NATURE));
            ManagedCProjectNature.addManagedNature((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        catch (CoreException coreException) {}
        try {
            iProgressMonitor.subTask(ManagedBuilderUIPlugin.getResourceString(MSG_ADD_BUILDER));
            ManagedCProjectNature.addManagedBuilder((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        catch (CoreException coreException) {}
        if (this.newProject != null) {
            this.optionPage.performApply((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
        }
        ITarget iTarget2 = null;
        try {
            iTarget = this.targetConfigurationPage.getSelectedTarget();
            iTarget2 = ManagedBuildManager.createTarget((IResource)this.newProject, (ITarget)iTarget);
            if (iTarget2 != null) {
                String string = this.newProject.getName();
                iTarget2.setArtifactName(string);
                IConfiguration[] iConfigurationArray = this.targetConfigurationPage.getSelectedConfigurations();
                Random random = new Random();
                random.setSeed(System.currentTimeMillis());
                int n = 0;
                while (n < iConfigurationArray.length) {
                    IConfiguration iConfiguration = iConfigurationArray[n];
                    int n2 = random.nextInt();
                    if (n2 < 0) {
                        n2 *= -1;
                    }
                    iTarget2.createConfiguration(iConfiguration, String.valueOf(iConfiguration.getId()) + "." + n2);
                    ++n;
                }
                IConfiguration[] iConfigurationArray2 = iTarget2.getConfigurations();
                if (iConfigurationArray2.length > 0) {
                    ManagedBuildManager.setDefaultConfiguration((IProject)this.newProject, (IConfiguration)iConfigurationArray2[0]);
                }
            }
        }
        catch (BuildException buildException) {}
        try {
            iTarget = CCorePlugin.getDefault().getCProjectDescription(this.newProject);
            iTarget.remove("org.eclipse.cdt.core.ScannerInfoProvider");
            iTarget.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
            iTarget.remove("org.eclipse.cdt.core.BinaryParser");
            iTarget.create("org.eclipse.cdt.core.BinaryParser", iTarget2.getBinaryParserId());
        }
        catch (CoreException coreException) {}
        iProgressMonitor.subTask(ManagedBuilderUIPlugin.getResourceString(MSG_SAVE));
        ManagedBuildManager.saveBuildInfo((IProject)this.newProject);
        iProgressMonitor.done();
    }

    protected void doRunPrologue(IProgressMonitor iProgressMonitor) {
    }

    protected void doRunEpilogue(IProgressMonitor iProgressMonitor) {
    }

    public String getProjectID() {
        return "org.eclipse.cdt.make.core.make";
    }
}

