/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;

public class ManagedCProjectNature
implements IProjectNature {
    public static final String BUILDER_NAME = "genmakebuilder";
    public static final String BUILDER_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "." + "genmakebuilder";
    private static final String MNG_NATURE_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".managedBuildNature";
    private IProject project;

    public static void addManagedNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        ManagedCProjectNature.addNature(iProject, MNG_NATURE_ID, iProgressMonitor);
    }

    public static void addManagedBuilder(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        ICommand[] iCommandArray;
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray2 = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray2.length) {
            ICommand iCommand = iCommandArray2[n];
            if (iCommand.getBuilderName().equals("org.eclipse.cdt.core.cbuilder")) {
                iCommandArray = new Vector(Arrays.asList(iCommandArray2));
                iCommandArray.removeElementAt(n);
                iCommandArray.trimToSize();
                ICommand[] iCommandArray3 = iCommandArray.toArray(new ICommand[iCommandArray2.length - 1]);
                iProjectDescription.setBuildSpec(iCommandArray3);
                break;
            }
            ++n;
        }
        iCommandArray2 = iProjectDescription.getBuildSpec();
        n = 0;
        int n2 = 0;
        while (n2 < iCommandArray2.length) {
            if (iCommandArray2[n2].getBuilderName().equals(ManagedCProjectNature.getBuilderID())) {
                n = 1;
                break;
            }
            ++n2;
        }
        if (n == 0) {
            ICommand iCommand = iProjectDescription.newCommand();
            iCommand.setBuilderName(ManagedCProjectNature.getBuilderID());
            iCommandArray = new ICommand[iCommandArray2.length + 1];
            System.arraycopy(iCommandArray2, 0, iCommandArray, 1, iCommandArray2.length);
            iCommandArray[0] = iCommand;
            iProjectDescription.setBuildSpec(iCommandArray);
            iProject.setDescription(iProjectDescription, null);
        }
    }

    public static void addNature(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return;
            }
            ++n;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    public static String getBuilderID() {
        ManagedBuilderCorePlugin managedBuilderCorePlugin = ManagedBuilderCorePlugin.getDefault();
        IPluginDescriptor iPluginDescriptor = managedBuilderCorePlugin.getDescriptor();
        if (iPluginDescriptor.getExtension(BUILDER_NAME) != null) {
            return String.valueOf(iPluginDescriptor.getUniqueIdentifier()) + "." + BUILDER_NAME;
        }
        return BUILDER_ID;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public static void removeManagedNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        ManagedCProjectNature.removeNature(iProject, MNG_NATURE_ID, iProgressMonitor);
    }

    public static void removeNature(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.remove(string);
        iProjectDescription.setNatureIds(arrayList.toArray(new String[arrayList.size()]));
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }
}

