/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.MakefileGenerator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GeneratedMakefileBuilder
extends ACBuilder {
    private static final String MESSAGE = "ManagedMakeBuilder.message";
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String REFRESH_ERROR = "ManagedMakeBuilder.message.error.refresh";
    private static final String BUILD_FINISHED = "ManagedMakeBuilder.message.finished";
    private static final String INCREMENTAL = "ManagedMakeBuilder.message.incremental";
    private static final String MAKE = "ManagedMakeBuilder.message.make";
    private static final String REBUILD = "ManagedMakeBuilder.message.rebuild";
    private static final String START = "ManagedMakeBuilder.message.starting";
    private static final String REFRESH = "ManagedMakeBuilder.message.updating";
    private static final String MARKERS = "ManagedMakeBuilder.message.creating.markers";
    protected List resourcesToBuild;
    protected List ruleList;

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject[] iProjectArray;
        String string = ManagedBuilderCorePlugin.getFormattedString(START, this.getProject().getName());
        if (string != null) {
            iProgressMonitor.subTask(string);
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (n == 6 || iManagedBuildInfo.isDirty()) {
            this.fullBuild(iProgressMonitor, iManagedBuildInfo);
        } else if (n == 9 && iManagedBuildInfo.isDirty()) {
            this.fullBuild(iProgressMonitor, iManagedBuildInfo);
        } else {
            iProjectArray = new ResourceDeltaVisitor();
            IResourceDelta iResourceDelta = this.getDelta(this.getProject());
            if (iResourceDelta == null) {
                this.fullBuild(iProgressMonitor, iManagedBuildInfo);
            } else {
                iResourceDelta.accept((IResourceDeltaVisitor)iProjectArray);
                if (iProjectArray.shouldBuild()) {
                    this.incrementalBuild(iResourceDelta, iManagedBuildInfo, iProgressMonitor);
                }
            }
        }
        iManagedBuildInfo.setDirty(false);
        iProjectArray = this.getProject().getReferencedProjects();
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            IProject iProject = iProjectArray[n2];
            IManagedBuildInfo iManagedBuildInfo2 = ManagedBuildManager.getBuildInfo((IResource)iProject);
            if (iManagedBuildInfo2 != null) {
                iManagedBuildInfo2.setDirty(false);
            }
            ++n2;
        }
        return iProjectArray;
    }

    public void checkCancel(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void fullBuild(IProgressMonitor iProgressMonitor, IManagedBuildInfo iManagedBuildInfo) throws CoreException {
        IManagedBuildInfo iManagedBuildInfo2;
        Object object;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IProject[] iProjectArray = this.getProject().getReferencedProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            object = iProjectArray[n];
            if (ManagedBuildManager.manages((IResource)object)) {
                iManagedBuildInfo2 = ManagedBuildManager.getBuildInfo((IResource)object);
                MakefileGenerator makefileGenerator = new MakefileGenerator((IProject)object, iManagedBuildInfo2, iProgressMonitor);
                makefileGenerator.regenerateMakefiles();
            }
            ++n;
        }
        String string = ManagedBuilderCorePlugin.getFormattedString(REBUILD, this.getProject().getName());
        iProgressMonitor.subTask(string);
        object = new MakefileGenerator(this.getProject(), iManagedBuildInfo, iProgressMonitor);
        ((MakefileGenerator)object).regenerateMakefiles();
        iManagedBuildInfo2 = ((MakefileGenerator)object).getTopBuildDir();
        if (iManagedBuildInfo2 != null) {
            this.invokeMake(true, iManagedBuildInfo2.removeFirstSegments(1), iManagedBuildInfo, iProgressMonitor);
        } else {
            iProgressMonitor.done();
        }
    }

    protected String[] getMakeTargets(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("clean");
        }
        arrayList.add("all");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected List getResourcesToBuild() {
        if (this.resourcesToBuild == null) {
            this.resourcesToBuild = new ArrayList();
        }
        return this.resourcesToBuild;
    }

    protected List getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList();
        }
        return this.ruleList;
    }

    public IPath getWorkingDirectory() {
        IProject iProject = this.getProject();
        IPath iPath = iProject.getLocation();
        return iPath;
    }

    protected void incrementalBuild(IResourceDelta iResourceDelta, IManagedBuildInfo iManagedBuildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject;
        String string = null;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        string = ManagedBuilderCorePlugin.getFormattedString(INCREMENTAL, this.getProject().getName());
        iProgressMonitor.subTask(string);
        IProject[] iProjectArray = this.getProject().getReferencedProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            iProject = iProjectArray[n];
            if (ManagedBuildManager.manages((IResource)iProject)) {
                IManagedBuildInfo iManagedBuildInfo2 = ManagedBuildManager.getBuildInfo((IResource)iProject);
                MakefileGenerator makefileGenerator = new MakefileGenerator(iProject, iManagedBuildInfo2, iProgressMonitor);
                makefileGenerator.regenerateMakefiles();
            }
            ++n;
        }
        MakefileGenerator makefileGenerator = new MakefileGenerator(this.getProject(), iManagedBuildInfo, iProgressMonitor);
        makefileGenerator.generateMakefiles(iResourceDelta);
        iProject = new Path(iManagedBuildInfo.getConfigurationName());
        this.invokeMake(false, (IPath)iProject, iManagedBuildInfo, iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invokeMake(boolean bl, IPath iPath, IManagedBuildInfo iManagedBuildInfo, IProgressMonitor iProgressMonitor) {
        block29: {
            block28: {
                block27: {
                    block26: {
                        IProject iProject = this.getProject();
                        if (iProgressMonitor == null) {
                            iProgressMonitor = new NullProgressMonitor();
                        }
                        try {
                            try {
                                String string;
                                Object object;
                                String[] stringArray;
                                ArrayList<String> arrayList;
                                IProject[] iProjectArray;
                                ConsoleOutputStream consoleOutputStream;
                                Path path;
                                IPath iPath2;
                                block30: {
                                    int n;
                                    iPath2 = this.getWorkingDirectory().append(iPath);
                                    IWorkspace iWorkspace = iProject.getWorkspace();
                                    if (iWorkspace == null) {
                                        Object var30_9 = null;
                                        break block26;
                                    }
                                    IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
                                    if (iWorkspaceRoot == null) {
                                        break block27;
                                    }
                                    IPath iPath3 = iPath2.addTrailingSeparator().append("makefile");
                                    if (iWorkspaceRoot.getFileForLocation(iPath3) == null) {
                                        break block28;
                                    }
                                    path = new Path(iManagedBuildInfo.getMakeCommand());
                                    if (path == null) break block29;
                                    String[] stringArray2 = new String[]{path.toString(), iProject.getName()};
                                    iProgressMonitor.beginTask(ManagedBuilderCorePlugin.getFormattedString(MAKE, stringArray2), -1);
                                    IConsole iConsole = CCorePlugin.getDefault().getConsole();
                                    iConsole.start(iProject);
                                    consoleOutputStream = iConsole.getOutputStream();
                                    this.removeAllMarkers(iProject);
                                    iProjectArray = iProject.getReferencedProjects();
                                    int n2 = 0;
                                    while (true) {
                                        Object object2;
                                        if (n2 >= iProjectArray.length) {
                                            arrayList = new ArrayList<String>();
                                            object2 = iManagedBuildInfo.getMakeArguments();
                                            if (((String)object2).length() > 0) {
                                                stringArray = ((String)object2).split("\\s");
                                                n = 0;
                                                break;
                                            }
                                            break block30;
                                        }
                                        object2 = iProjectArray[n2];
                                        this.removeAllMarkers((IProject)object2);
                                        ++n2;
                                    }
                                    while (n < stringArray.length) {
                                        arrayList.add(stringArray[n]);
                                        ++n;
                                    }
                                }
                                arrayList.addAll(Arrays.asList(this.getMakeTargets(bl)));
                                stringArray = arrayList.toArray(new String[arrayList.size()]);
                                String string2 = null;
                                CommandLauncher commandLauncher = new CommandLauncher();
                                commandLauncher.showCommand(true);
                                Properties properties = commandLauncher.getEnvironment();
                                ((Hashtable)properties).put("CWD", iPath2.toOSString());
                                ((Hashtable)properties).put("PWD", iPath2.toOSString());
                                String[] stringArray3 = null;
                                ArrayList<String> arrayList2 = new ArrayList<String>();
                                Enumeration<?> enumeration = properties.propertyNames();
                                if (enumeration != null) {
                                    while (true) {
                                        if (!enumeration.hasMoreElements()) {
                                            stringArray3 = arrayList2.toArray(new String[arrayList2.size()]);
                                            break;
                                        }
                                        object = (String)enumeration.nextElement();
                                        arrayList2.add(String.valueOf(object) + "=" + properties.getProperty((String)object));
                                    }
                                }
                                object = new ErrorParserManager((ACBuilder)this);
                                object.setOutputStream((OutputStream)consoleOutputStream);
                                OutputStream outputStream = object.getOutputStream();
                                OutputStream outputStream2 = object.getOutputStream();
                                Process process = commandLauncher.execute((IPath)path, stringArray, stringArray3, iPath2);
                                if (process != null) {
                                    try {
                                        process.getOutputStream().close();
                                    }
                                    catch (IOException iOException) {}
                                    if (commandLauncher.waitAndRead(outputStream, outputStream2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, -1)) != 0) {
                                        string2 = commandLauncher.getErrorMessage();
                                    }
                                    iProgressMonitor.subTask(ManagedBuilderCorePlugin.getResourceString(REFRESH));
                                    try {
                                        iProject.refreshLocal(2, null);
                                        int n = 0;
                                        while (n < iProjectArray.length) {
                                            string = iProjectArray[n];
                                            string.refreshLocal(2, null);
                                            ++n;
                                        }
                                    }
                                    catch (CoreException coreException) {
                                        iProgressMonitor.subTask(ManagedBuilderCorePlugin.getResourceString(REFRESH_ERROR));
                                    }
                                } else {
                                    string2 = commandLauncher.getErrorMessage();
                                }
                                StringBuffer stringBuffer = new StringBuffer();
                                if (string2 != null && string2.length() > 0) {
                                    string = ManagedBuilderCorePlugin.getResourceString(BUILD_ERROR);
                                    stringBuffer.append(string);
                                    stringBuffer.append(System.getProperty("line.separator", "\n"));
                                    stringBuffer.append("(").append(string2).append(")");
                                } else {
                                    string = ManagedBuilderCorePlugin.getFormattedString(BUILD_FINISHED, iProject.getName());
                                    stringBuffer.append(string);
                                    stringBuffer.append(System.getProperty("line.separator", "\n"));
                                }
                                consoleOutputStream.write(stringBuffer.toString().getBytes());
                                consoleOutputStream.flush();
                                outputStream.close();
                                outputStream2.close();
                                iProgressMonitor.subTask(ManagedBuilderCorePlugin.getResourceString(MARKERS));
                                object.reportProblems();
                            }
                            catch (Exception exception) {
                                CCorePlugin.log((Throwable)exception);
                                this.forgetLastBuiltState();
                            }
                            break block29;
                        }
                        catch (Throwable throwable) {
                            Object var30_12 = null;
                            iProgressMonitor.done();
                            throw throwable;
                        }
                    }
                    iProgressMonitor.done();
                    return;
                }
                Object var30_10 = null;
                iProgressMonitor.done();
                return;
            }
            Object var30_11 = null;
            iProgressMonitor.done();
            return;
        }
        Object var30_13 = null;
        iProgressMonitor.done();
    }

    private void removeAllMarkers(IProject iProject) throws CoreException {
        IWorkspace iWorkspace = iProject.getWorkspace();
        IMarker[] iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (iMarkerArray != null) {
            iWorkspace.deleteMarkers(iMarkerArray);
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean buildNeeded = false;

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource = iResourceDelta.getResource();
            if (iResource != null && iResource.getProject() == GeneratedMakefileBuilder.this.getProject()) {
                this.buildNeeded = true;
                return false;
            }
            return true;
        }

        public boolean shouldBuild() {
            return this.buildNeeded;
        }
    }
}

