/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.runtime.IConfigurationElement;

public class Option
extends BuildObject
implements IOption {
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private List builtIns;
    private IOptionCategory category;
    private String command;
    private String defaultEnumName;
    private Map enumCommands;
    private ITool tool;
    private Object value;
    private int valueType;

    public Option(ITool iTool) {
        this.tool = iTool;
    }

    public Option(Tool tool, IConfigurationElement iConfigurationElement) {
        this(tool);
        this.setId(iConfigurationElement.getAttribute("id"));
        tool.addOption(this);
        this.setName(iConfigurationElement.getAttribute("name"));
        String string = iConfigurationElement.getAttribute("category");
        if (string != null) {
            this.setCategory(tool.getOptionCategory(string));
        }
        this.command = iConfigurationElement.getAttribute("command");
        String string2 = iConfigurationElement.getAttribute("valueType");
        this.valueType = string2 == null ? -1 : (string2.equals("string") ? 2 : (string2.equals("stringList") ? 3 : (string2.equals("boolean") ? 0 : (string2.equals("enumerated") ? 1 : (string2.equals("includePath") ? 4 : (string2.equals("libs") ? 6 : (string2.equals("userObjs") ? 7 : 5)))))));
        this.enumCommands = new HashMap();
        switch (this.valueType) {
            case 0: {
                this.value = new Boolean(iConfigurationElement.getAttribute("defaultValue"));
                break;
            }
            case 2: {
                this.value = iConfigurationElement.getAttribute("defaultValue");
                break;
            }
            case 1: {
                ArrayList<String> arrayList = new ArrayList<String>();
                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("enumeratedOptionValue");
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    String string3 = iConfigurationElementArray[n].getAttribute("name");
                    String string4 = iConfigurationElementArray[n].getAttribute("command");
                    arrayList.add(string3);
                    this.enumCommands.put(string3, string4);
                    Boolean bl = new Boolean(iConfigurationElementArray[n].getAttribute("isDefault"));
                    if (bl.booleanValue()) {
                        this.defaultEnumName = string3;
                    }
                    ++n;
                }
                this.value = arrayList;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> arrayList = new ArrayList<String>();
                this.builtIns = new ArrayList();
                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("listOptionValue");
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
                    Boolean bl = new Boolean(iConfigurationElement2.getAttribute("builtIn"));
                    if (bl.booleanValue()) {
                        this.builtIns.add(iConfigurationElement2.getAttribute("value"));
                    } else {
                        arrayList.add(iConfigurationElement2.getAttribute("value"));
                    }
                    ++n;
                }
                this.value = arrayList;
                break;
            }
        }
    }

    public String[] getApplicableValues() {
        List list = (List)this.value;
        return list != null ? list.toArray(new String[list.size()]) : EMPTY_STRING_ARRAY;
    }

    public boolean getBooleanValue() {
        Boolean bl = (Boolean)this.value;
        return bl;
    }

    public String[] getBuiltIns() {
        return this.builtIns == null ? EMPTY_STRING_ARRAY : this.builtIns.toArray(new String[this.builtIns.size()]);
    }

    public IOptionCategory getCategory() {
        return this.category != null ? this.category : this.getTool().getTopOptionCategory();
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.valueType != 5) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getEnumCommand(String string) {
        String string2 = (String)this.enumCommands.get(string);
        return string2 == null ? EMPTY_STRING : string2;
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.valueType != 4) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getLibraries() throws BuildException {
        if (this.valueType != 6) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getSelectedEnum() throws BuildException {
        if (this.valueType != 1) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        return this.defaultEnumName == null ? EMPTY_STRING : this.defaultEnumName;
    }

    public String[] getStringListValue() throws BuildException {
        if (this.valueType != 3) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getStringValue() throws BuildException {
        if (this.valueType != 2) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        return this.value == null ? EMPTY_STRING : (String)this.value;
    }

    public ITool getTool() {
        return this.tool;
    }

    public String[] getUserObjects() throws BuildException {
        if (this.valueType != 7) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setCategory(IOptionCategory iOptionCategory) {
        this.category = iOptionCategory;
    }

    public IOption setValue(IConfiguration iConfiguration, String string) throws BuildException {
        if (this.valueType != 2 || this.valueType != 1) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        if (iConfiguration == null) {
            this.value = string;
            return this;
        }
        return null;
    }

    public IOption setValue(IConfiguration iConfiguration, String[] stringArray) throws BuildException {
        if (this.valueType != 3 || this.valueType != 4 || this.valueType != 5 || this.valueType != 6 || this.valueType != 7) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        if (iConfiguration == null) {
            this.value = stringArray;
            return this;
        }
        return null;
    }
}

