/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.runtime.IConfigurationElement;

public class OptionCategory
extends BuildObject
implements IOptionCategory {
    private IOptionCategory owner;
    private List children;
    private static final IOptionCategory[] emtpyCategories = new IOptionCategory[0];

    public OptionCategory(IOptionCategory iOptionCategory) {
        this.owner = iOptionCategory;
    }

    public OptionCategory(Tool tool, IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("owner");
        this.owner = string != null ? tool.getOptionCategory(string) : tool;
        this.setId(iConfigurationElement.getAttribute("id"));
        this.setName(iConfigurationElement.getAttribute("name"));
        if (this.owner instanceof Tool) {
            ((Tool)this.owner).addChildCategory(this);
        } else {
            ((OptionCategory)this.owner).addChildCategory(this);
        }
        tool.addOptionCategory(this);
    }

    public IOptionCategory[] getChildCategories() {
        if (this.children != null) {
            return this.children.toArray(new IOptionCategory[this.children.size()]);
        }
        return emtpyCategories;
    }

    public void addChildCategory(OptionCategory optionCategory) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(optionCategory);
    }

    public IOptionCategory getOwner() {
        return this.owner;
    }

    public ITool getTool() {
        return this.owner.getTool();
    }

    public IOption[] getOptions(IConfiguration iConfiguration) {
        IBuildObject[] iBuildObjectArray;
        IBuildObject iBuildObject = this.getTool();
        if (iConfiguration != null) {
            iBuildObjectArray = iConfiguration.getTools();
            int n = 0;
            while (n < iBuildObjectArray.length) {
                if (iBuildObjectArray[n] instanceof IToolReference) {
                    if (((IToolReference)iBuildObjectArray[n]).references((ITool)iBuildObject)) {
                        iBuildObject = iBuildObjectArray[n];
                        break;
                    }
                } else if (iBuildObjectArray[n].equals(iBuildObject)) break;
                ++n;
            }
        }
        iBuildObjectArray = iBuildObject.getOptions();
        ArrayList<IBuildObject> arrayList = new ArrayList<IBuildObject>();
        int n = 0;
        while (n < iBuildObjectArray.length) {
            IBuildObject iBuildObject2 = iBuildObjectArray[n];
            if (iBuildObject2.getCategory().equals(this)) {
                arrayList.add(iBuildObject2);
            }
            ++n;
        }
        return arrayList.toArray(new IOption[arrayList.size()]);
    }
}

