/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OptionReference
implements IOption {
    private List builtIns;
    private String command;
    private IOption option;
    private ToolReference owner;
    private Object value;

    public OptionReference(ToolReference toolReference, IConfigurationElement iConfigurationElement) {
        this.owner = toolReference;
        this.option = toolReference.getTool().getOption(iConfigurationElement.getAttribute("id"));
        toolReference.addOptionReference(this);
        switch (this.option.getValueType()) {
            case 0: {
                this.value = new Boolean(iConfigurationElement.getAttribute("defaultValue"));
                break;
            }
            case 2: {
                this.value = iConfigurationElement.getAttribute("defaultValue");
                break;
            }
            case 1: {
                String string = iConfigurationElement.getAttribute("defaultValue");
                if (string == null) {
                    try {
                        string = this.option.getSelectedEnum();
                    }
                    catch (BuildException buildException) {
                        string = new String();
                    }
                }
                this.value = string;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> arrayList = new ArrayList<String>();
                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("listOptionValue");
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
                    Boolean bl = new Boolean(iConfigurationElement2.getAttribute("builtIn"));
                    if (bl.booleanValue()) {
                        this.getBuiltInList().add(iConfigurationElement2.getAttribute("value"));
                    } else {
                        arrayList.add(iConfigurationElement2.getAttribute("value"));
                    }
                    ++n;
                }
                this.value = arrayList;
            }
        }
    }

    public OptionReference(ToolReference toolReference, IOption iOption) {
        this.owner = toolReference;
        this.option = iOption;
        toolReference.addOptionReference(this);
    }

    public OptionReference(ToolReference toolReference, Element element) {
        this.owner = toolReference;
        this.option = toolReference.getTool().getOption(element.getAttribute("id"));
        if (this.option == null) {
            return;
        }
        toolReference.addOptionReference(this);
        switch (this.option.getValueType()) {
            case 0: {
                this.value = new Boolean(element.getAttribute("defaultValue"));
                break;
            }
            case 1: 
            case 2: {
                this.value = element.getAttribute("defaultValue");
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> arrayList = new ArrayList<String>();
                NodeList nodeList = element.getElementsByTagName("listOptionValue");
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node = nodeList.item(n);
                    if (node.getNodeType() == 1) {
                        Boolean bl = new Boolean(((Element)node).getAttribute("builtIn"));
                        if (bl.booleanValue()) {
                            this.getBuiltInList().add(((Element)node).getAttribute("value"));
                        } else {
                            arrayList.add(((Element)node).getAttribute("value"));
                        }
                    }
                    ++n;
                }
                this.value = arrayList;
            }
        }
    }

    public void serialize(Document document, Element element) {
        element.setAttribute("id", this.option.getId());
        switch (this.option.getValueType()) {
            case 0: {
                element.setAttribute("defaultValue", ((Boolean)this.value).toString());
                break;
            }
            case 1: 
            case 2: {
                element.setAttribute("defaultValue", (String)this.value);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Element element2;
                ArrayList arrayList = (ArrayList)this.value;
                ListIterator listIterator = ((AbstractList)arrayList).listIterator();
                while (listIterator.hasNext()) {
                    element2 = document.createElement("listOptionValue");
                    element2.setAttribute("value", (String)listIterator.next());
                    element2.setAttribute("builtIn", "false");
                    element.appendChild(element2);
                }
                if (this.builtIns == null) break;
                listIterator = this.builtIns.listIterator();
                while (listIterator.hasNext()) {
                    element2 = document.createElement("listOptionValue");
                    element2.setAttribute("value", (String)listIterator.next());
                    element2.setAttribute("builtIn", "true");
                    element.appendChild(element2);
                }
                break;
            }
        }
    }

    public String[] getApplicableValues() {
        return this.option.getApplicableValues();
    }

    public IOptionCategory getCategory() {
        return this.option.getCategory();
    }

    public String getCommand() {
        return this.option.getCommand();
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.value == null) {
            return this.option.getDefinedSymbols();
        }
        if (this.getValueType() == 5) {
            ArrayList arrayList = (ArrayList)this.value;
            return arrayList.toArray(new String[arrayList.size()]);
        }
        throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
    }

    public String getEnumCommand(String string) {
        return this.option.getEnumCommand(string);
    }

    public String getId() {
        return this.option.getId();
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.value == null) {
            return this.option.getIncludePaths();
        }
        if (this.getValueType() == 4) {
            ArrayList arrayList = (ArrayList)this.value;
            return arrayList.toArray(new String[arrayList.size()]);
        }
        throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
    }

    public String[] getLibraries() throws BuildException {
        if (this.value == null) {
            return this.option.getLibraries();
        }
        if (this.getValueType() == 6) {
            ArrayList arrayList = (ArrayList)this.value;
            return arrayList.toArray(new String[arrayList.size()]);
        }
        throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
    }

    public String getName() {
        return this.option.getName();
    }

    public boolean getBooleanValue() throws BuildException {
        if (this.value == null) {
            return this.option.getBooleanValue();
        }
        if (this.getValueType() == 0) {
            Boolean bl = (Boolean)this.value;
            return bl;
        }
        throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
    }

    private List getBuiltInList() {
        if (this.builtIns == null) {
            this.builtIns = new ArrayList();
        }
        return this.builtIns;
    }

    public String[] getBuiltIns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.builtIns != null) {
            arrayList.addAll(this.builtIns);
        }
        if (this.option != null) {
            String[] stringArray = this.option.getBuiltIns();
            int n = 0;
            while (n < stringArray.length) {
                if (!arrayList.contains(stringArray[n])) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public IOption getOption() {
        return this.option;
    }

    public String getSelectedEnum() throws BuildException {
        if (this.value == null) {
            return this.option.getSelectedEnum();
        }
        if (this.getValueType() == 1) {
            return (String)this.value;
        }
        throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
    }

    public String[] getStringListValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringListValue();
        }
        if (this.getValueType() == 3) {
            ArrayList arrayList = (ArrayList)this.value;
            return arrayList.toArray(new String[arrayList.size()]);
        }
        throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
    }

    public String getStringValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringValue();
        }
        if (this.getValueType() == 2) {
            return (String)this.value;
        }
        throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
    }

    public ITool getTool() {
        return this.owner;
    }

    public ToolReference getToolReference() {
        return this.owner;
    }

    public String[] getUserObjects() throws BuildException {
        if (this.value == null) {
            return this.option.getDefinedSymbols();
        }
        if (this.getValueType() == 7) {
            ArrayList arrayList = (ArrayList)this.value;
            return arrayList.toArray(new String[arrayList.size()]);
        }
        throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
    }

    public int getValueType() {
        return this.option.getValueType();
    }

    public boolean references(IOption iOption) {
        if (this.equals(iOption)) {
            return true;
        }
        if (this.option instanceof OptionReference) {
            return ((OptionReference)this.option).references(iOption);
        }
        return this.option.equals(iOption);
    }

    public void setValue(boolean bl) throws BuildException {
        if (this.getValueType() != 0) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        this.value = new Boolean(bl);
    }

    public void setValue(String string) throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        this.value = string;
    }

    public void setValue(String[] stringArray) throws BuildException {
        if (this.getValueType() != 3 && this.getValueType() != 4 && this.getValueType() != 5 && this.getValueType() != 6 && this.getValueType() != 7) {
            throw new BuildException(ManagedBuilderCorePlugin.getResourceString("Option.error.bad_value_type"));
        }
        this.value = new ArrayList<String>(Arrays.asList(stringArray));
    }

    public String toString() {
        String string = new String();
        if (this.option != null) {
            string = String.valueOf(string) + "Reference to " + this.option.getName();
        }
        if (string.length() > 0) {
            return string;
        }
        return super.toString();
    }
}

