/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.AbstractToolReference;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ToolReference
extends AbstractToolReference {
    private String command;
    private List optionReferences;
    private IBuildObject owner;

    public ToolReference(BuildObject buildObject, Element element) {
        Object object;
        this.owner = buildObject;
        if (buildObject instanceof Configuration) {
            if (this.parent == null) {
                object = (Target)((Configuration)buildObject).getTarget();
                this.parent = ((Target)((Target)object).getParent()).getTool(element.getAttribute("id"));
            }
            ((Configuration)buildObject).addToolReference(this);
        } else if (buildObject instanceof Target) {
            if (this.parent == null) {
                this.parent = ((Target)((Target)buildObject).getParent()).getTool(element.getAttribute("id"));
            }
            ((Target)buildObject).addToolReference(this);
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        object = element.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node = object.item(n);
            if (node.getNodeName().equals("optionReference")) {
                new OptionReference(this, (Element)node);
            }
            ++n;
        }
    }

    public ToolReference(BuildObject buildObject, IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray;
        this.owner = buildObject;
        if (buildObject instanceof Configuration) {
            iConfigurationElementArray = (IConfigurationElement[])((Configuration)buildObject).getTarget();
            this.parent = iConfigurationElementArray.getTool(iConfigurationElement.getAttribute("id"));
            ((Configuration)buildObject).addToolReference(this);
        } else if (buildObject instanceof Target) {
            this.parent = ((Target)buildObject).getTool(iConfigurationElement.getAttribute("id"));
            ((Target)buildObject).addToolReference(this);
        }
        iConfigurationElementArray = iConfigurationElement.getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            if (iConfigurationElement2.getName().equals("optionReference")) {
                new OptionReference(this, iConfigurationElement2);
            }
            ++n;
        }
    }

    public ToolReference(BuildObject buildObject, ITool iTool) {
        super(iTool);
        this.owner = buildObject;
        if (buildObject instanceof Configuration) {
            ((Configuration)buildObject).addToolReference(this);
        } else if (buildObject instanceof Target) {
            ((Target)buildObject).addToolReference(this);
        }
    }

    public void addOptionReference(OptionReference optionReference) {
        this.getOptionReferenceList().add(optionReference);
    }

    public OptionReference createOptionReference(IOption iOption) {
        OptionReference optionReference = this.getOptionReference(iOption);
        if (optionReference == null) {
            optionReference = new OptionReference(this, iOption);
        }
        return optionReference;
    }

    public String getToolCommand() {
        return this.command == null ? this.parent.getToolCommand() : this.command;
    }

    public String getToolFlags() throws BuildException {
        StringBuffer stringBuffer = new StringBuffer();
        IOption[] iOptionArray = this.getOptions();
        int n = 0;
        while (n < iOptionArray.length) {
            IOption iOption = iOptionArray[n];
            switch (iOption.getValueType()) {
                case 0: {
                    if (!iOption.getBooleanValue()) break;
                    stringBuffer.append(String.valueOf(iOption.getCommand()) + " ");
                    break;
                }
                case 1: {
                    String string = iOption.getEnumCommand(iOption.getSelectedEnum());
                    if (string.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string) + " ");
                    break;
                }
                case 2: {
                    String string = iOption.getStringValue();
                    if (string.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string) + " ");
                    break;
                }
                case 3: {
                    Object object2;
                    String string = iOption.getCommand();
                    String[] stringArray = iOption.getStringListValue();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        object2 = stringArray[n2];
                        stringBuffer.append(String.valueOf(string) + (String)object2 + " ");
                        ++n2;
                    }
                    break;
                }
                case 4: {
                    Object object;
                    String string = iOption.getCommand();
                    Object object2 = iOption.getIncludePaths();
                    int n3 = 0;
                    while (n3 < ((String[])object2).length) {
                        object = object2[n3];
                        stringBuffer.append(String.valueOf(string) + (String)object + " ");
                        ++n3;
                    }
                    break;
                }
                case 5: {
                    String string = iOption.getCommand();
                    Object object = iOption.getDefinedSymbols();
                    int n4 = 0;
                    while (n4 < ((String[])object).length) {
                        String string2 = object[n4];
                        stringBuffer.append(String.valueOf(string) + string2 + " ");
                        ++n4;
                    }
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public IOption[] getOptions() {
        IOption[] iOptionArray = this.parent.getOptions();
        int n = 0;
        while (n < iOptionArray.length) {
            OptionReference optionReference = this.getOptionReference(iOptionArray[n]);
            if (optionReference != null) {
                iOptionArray[n] = optionReference;
            }
            ++n;
        }
        return iOptionArray;
    }

    protected List getAllOptionRefs() {
        return ((Configuration)this.owner).getOptionReferences(this.parent);
    }

    private OptionReference getOptionReference(IOption iOption) {
        ListIterator listIterator = this.getAllOptionRefs().listIterator();
        while (listIterator.hasNext()) {
            OptionReference optionReference = (OptionReference)listIterator.next();
            if (!optionReference.references(iOption)) continue;
            return optionReference;
        }
        return null;
    }

    protected List getOptionReferenceList() {
        if (this.optionReferences == null) {
            this.optionReferences = new ArrayList();
            this.optionReferences.clear();
        }
        return this.optionReferences;
    }

    public IOption getOption(String string) {
        return null;
    }

    public boolean ownedByConfiguration(IConfiguration iConfiguration) {
        if (this.owner instanceof Configuration) {
            return ((IConfiguration)this.owner).equals(iConfiguration);
        }
        return false;
    }

    public void serialize(Document document, Element element) {
        element.setAttribute("id", this.parent.getId());
        if (this.command != null) {
            element.setAttribute("command", this.command);
        }
        ListIterator listIterator = this.getOptionReferenceList().listIterator();
        while (listIterator.hasNext()) {
            OptionReference optionReference = (OptionReference)listIterator.next();
            Element element2 = document.createElement("optionReference");
            element.appendChild(element2);
            optionReference.serialize(document, element2);
        }
    }

    public void setToolCommand(String string) {
        if (string != null && !string.equals(this.command)) {
            this.command = string;
        }
    }

    public String toString() {
        String string = new String();
        if (this.parent != null) {
            string = String.valueOf(string) + "Reference to " + this.parent.getName();
        }
        if (string.length() > 0) {
            return string;
        }
        return super.toString();
    }
}

