/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build.managed.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.cdt.testplugin.FileManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ManagedBuildTests
extends TestCase {
    private static final boolean boolVal = true;
    private static final String testConfigId = "test.config.override";
    private static final String testConfigName = "Tester";
    private static final String enumVal = "Another Enum";
    private static final String[] listVal = new String[]{"_DEBUG", "/usr/include", "libglade.a"};
    private static final String newExt = "wen";
    private static final String projectName = "ManagedBuildTest";
    private static final String projectRename = "ManagedBuildRedux";
    private static final String rootExt = "toor";
    private static final String stringVal = "-c -Wall";
    private static final String subExt = "bus";
    static /* synthetic */ Class class$0;

    public ManagedBuildTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.build.managed.tests.ManagedBuildTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedBuildTests("testExtensions"));
        testSuite.addTest((Test)new ManagedBuildTests("testProjectCreation"));
        testSuite.addTest((Test)new ManagedBuildTests("testConfigurations"));
        testSuite.addTest((Test)new ManagedBuildTests("testConfigurationReset"));
        testSuite.addTest((Test)new ManagedBuildTests("testTargetBuildArtifact"));
        testSuite.addTest((Test)new ManagedBuildTests("testMakeCommandManipulation"));
        testSuite.addTest((Test)new ManagedBuildTests("testScannerInfoInterface"));
        testSuite.addTest((Test)new ManagedBuildTests("testBug43450"));
        testSuite.addTest((Test)new ManagedBuildTests("testProjectRename"));
        testSuite.addTest((Test)new ManagedBuildTests("cleanup"));
        return testSuite;
    }

    public void testExtensions() throws Exception {
        ITarget iTarget = null;
        ITarget iTarget2 = null;
        ITarget iTarget3 = null;
        ITarget[] iTargetArray = ManagedBuildManager.getDefinedTargets(null);
        int n = 0;
        while (n < iTargetArray.length) {
            ITarget iTarget4 = iTargetArray[n];
            if (iTarget4.getName().equals("Test Root")) {
                iTarget = iTarget4;
                this.checkRootTarget(iTarget);
            } else if (iTarget4.getName().equals("Test Sub")) {
                iTarget2 = iTarget4;
                this.checkSubTarget(iTarget2);
            } else if (iTarget4.getName().equals("Test Sub Sub")) {
                iTarget3 = iTarget4;
                this.checkSubSubTarget(iTarget3);
            }
            ++n;
        }
        Assert.assertNotNull(iTarget);
        Assert.assertNotNull(iTarget2);
        Assert.assertNotNull(iTarget3);
    }

    public void testMakeCommandManipulation() {
        String string = "make";
        String string2 = "Ant";
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open project in 'testMakeCommandManipulation': " + coreException.getLocalizedMessage()));
        }
        Assert.assertNotNull((Object)iProject);
        ITarget[] iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)1, (int)iTargetArray.length);
        Assert.assertFalse((boolean)iTargetArray[0].hasOverridenMakeCommand());
        Assert.assertEquals((String)string, (String)iTargetArray[0].getMakeCommand());
        iTargetArray[0].setMakeCommand(string2);
        Assert.assertEquals((String)string2, (String)iTargetArray[0].getMakeCommand());
        Assert.assertTrue((boolean)iTargetArray[0].hasOverridenMakeCommand());
        iTargetArray[0].resetMakeCommand();
        Assert.assertFalse((boolean)iTargetArray[0].hasOverridenMakeCommand());
        Assert.assertEquals((String)string, (String)iTargetArray[0].getMakeCommand());
    }

    public void testScannerInfoInterface() {
        IOption[] iOptionArray;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open project in 'testScannerInfoInterface': " + coreException.getLocalizedMessage()));
        }
        Object[] objectArray = new String[]{"/usr/gnu/include", new Path("/usr/include").toOSString(), new Path("/opt/gnome/include").toOSString(), new Path("C:\\home\\tester/include").toOSString(), iProject.getLocation().append("Sub Config\\\"..\\includes\"").toOSString()};
        ITarget iTarget = ManagedBuildManager.getTarget((IResource)iProject, (String)"test.sub");
        Assert.assertNotNull((Object)iTarget);
        ITarget iTarget2 = null;
        try {
            iTarget2 = ManagedBuildManager.createTarget((IResource)iProject, (ITarget)iTarget);
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failed adding new target to project: " + buildException.getLocalizedMessage()));
        }
        Assert.assertNotNull((Object)iTarget2);
        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            iTarget2.createConfiguration(iConfigurationArray[n], String.valueOf(iConfigurationArray[n].getId()) + "." + n);
            ++n;
        }
        IConfiguration[] iConfigurationArray2 = iTarget2.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray2.length);
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        iManagedBuildInfo.setDefaultConfiguration(iTarget2.getConfiguration(iConfigurationArray2[3].getId()));
        IExtensionPoint iExtensionPoint = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("ScannerInfoProvider");
        if (iExtensionPoint == null) {
            Assert.fail((String)"Failed to retrieve the extension point ScannerInfoProvider.");
        }
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        Assert.assertNotNull((Object)iScannerInfoProvider);
        IScannerInfo iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject);
        Map map = iScannerInfo.getDefinedSymbols();
        Assert.assertTrue((boolean)map.containsKey("BUILTIN"));
        Assert.assertEquals((String)((String)map.get("BUILTIN")), (String)"");
        Object[] objectArray2 = iScannerInfo.getIncludePaths();
        Assert.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        iScannerInfoProvider.subscribe((IResource)iProject, new IScannerInfoChangeListener((String[])objectArray){
            private final /* synthetic */ String[] val$expectedPaths;
            {
                this.val$expectedPaths = stringArray;
            }

            public void changeNotification(IResource iResource, IScannerInfo iScannerInfo) {
                Map map = iScannerInfo.getDefinedSymbols();
                Assert.assertTrue((boolean)map.containsKey("BUILTIN"));
                Assert.assertTrue((boolean)map.containsKey("DEBUG"));
                Assert.assertTrue((boolean)map.containsKey("GNOME"));
                Assert.assertTrue((boolean)map.containsValue("ME"));
                Assert.assertEquals((String)((String)map.get("BUILTIN")), (String)"");
                Assert.assertEquals((String)((String)map.get("DEBUG")), (String)"");
                Assert.assertEquals((String)((String)map.get("GNOME")), (String)"ME");
                Object[] objectArray = iScannerInfo.getIncludePaths();
                Assert.assertTrue((boolean)Arrays.equals(this.val$expectedPaths, objectArray));
            }
        });
        String[] stringArray = new String[]{"DEBUG", "GNOME = ME "};
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration(iTarget2);
        ITool[] iToolArray = iConfiguration.getTools();
        IOption[] iOptionArray2 = null;
        int n2 = 0;
        while (n2 < iToolArray.length) {
            iOptionArray = iToolArray[n2];
            if ("tool.sub".equalsIgnoreCase(iOptionArray.getId())) {
                iOptionArray2 = iOptionArray;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(iOptionArray2);
        IOption iOption = null;
        iOptionArray = iOptionArray2.getOptions();
        int n3 = 0;
        while (n3 < iOptionArray.length) {
            IOption iOption2 = iOptionArray[n3];
            if (iOption2.getValueType() == 5) {
                iOption = iOption2;
                break;
            }
            ++n3;
        }
        Assert.assertNotNull(iOption);
        IManagedBuildInfo iManagedBuildInfo2 = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertFalse((boolean)iManagedBuildInfo2.isDirty());
        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (String[])stringArray);
        Assert.assertTrue((boolean)iManagedBuildInfo2.isDirty());
        iManagedBuildInfo2.setDirty(false);
        Assert.assertFalse((boolean)iManagedBuildInfo2.isDirty());
    }

    public void testConfigurations() throws CoreException, BuildException {
        IProject iProject = this.createProject(projectName);
        ITarget[] iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)1, (int)iTargetArray.length);
        ITarget iTarget = iTargetArray[0];
        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iConfigurationArray[0];
        Assert.assertEquals((String)iConfigurationArray[0].getName(), (String)"Root Config");
        Assert.assertEquals((String)iConfigurationArray[1].getName(), (String)"Root Override Config");
        Assert.assertEquals((String)iConfigurationArray[2].getName(), (String)"Complete Override Config");
        IConfiguration iConfiguration2 = iTarget.createConfiguration(iConfiguration, testConfigId);
        Assert.assertEquals((int)4, (int)iTarget.getConfigurations().length);
        iConfiguration2.setName(testConfigName);
        Assert.assertEquals((String)iConfiguration2.getId(), (String)testConfigId);
        Assert.assertEquals((String)iConfiguration2.getName(), (String)testConfigName);
        ITool[] iToolArray = iConfiguration2.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        Assert.assertEquals((String)iTool.getToolCommand(), (String)"doIt");
        iConfiguration2.setToolCommand(iTool, "never");
        Assert.assertEquals((String)iTool.getToolCommand(), (String)"never");
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        IOption[] iOptionArray = iOptionCategory.getOptions(null);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IOption)iOptionArray[0], (String[])listVal);
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IOption)iOptionArray[1], (boolean)true);
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        iOptionArray = iOptionCategoryArray[0].getOptions(null);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IOption)iOptionArray[0], (String)stringVal);
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IOption)iOptionArray[1], (String)enumVal);
        ManagedBuildManager.saveBuildInfo((IProject)iProject);
        iProject.close(null);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        iProject.open(null);
        this.checkOptionReferences(iProject);
        iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)1, (int)iTargetArray.length);
        iTarget = iTargetArray[0];
        iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        iTarget.removeConfiguration(testConfigId);
        iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        Assert.assertEquals((String)iConfigurationArray[0].getName(), (String)"Root Config");
        Assert.assertEquals((String)iConfigurationArray[1].getName(), (String)"Root Override Config");
    }

    public void testConfigurationReset() {
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open project: " + coreException.getLocalizedMessage()));
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertNotNull((Object)iManagedBuildInfo);
        ITarget iTarget = iManagedBuildInfo.getDefaultTarget();
        Assert.assertNotNull((Object)iTarget);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration(iTarget);
        Assert.assertNotNull((Object)iConfiguration);
        try {
            this.checkRootTarget(iTarget);
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Overridden root target check failed: " + buildException.getLocalizedMessage()));
        }
        ManagedBuildManager.resetConfiguration((IProject)iProject, (IConfiguration)iConfiguration);
        try {
            this.checkRootTarget(iTarget);
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Reset root target check failed: " + buildException.getLocalizedMessage()));
        }
    }

    public void testProjectCreation() throws BuildException {
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            this.addManagedBuildNature(iProject);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on project creation: " + coreException.getLocalizedMessage()));
        }
        Assert.assertEquals((int)0, (int)ManagedBuildManager.getTargets((IResource)iProject).length);
        ITarget iTarget = ManagedBuildManager.getTarget((IResource)iProject, (String)"test.root");
        Assert.assertNotNull((Object)iTarget);
        ITarget iTarget2 = ManagedBuildManager.createTarget((IResource)iProject, (ITarget)iTarget);
        Assert.assertEquals((String)iTarget2.getName(), (String)iTarget.getName());
        Assert.assertFalse((boolean)iTarget2.equals(iTarget));
        String string = projectName;
        iTarget2.setArtifactName(string);
        iTarget2.setArtifactExtension(newExt);
        ITarget[] iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)1, (int)iTargetArray.length);
        ITarget iTarget3 = iTargetArray[0];
        Assert.assertEquals((Object)iTarget3, (Object)iTarget2);
        Assert.assertFalse((boolean)iTarget3.equals(iTarget));
        IConfiguration iConfiguration = null;
        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            if (n == 0) {
                iConfiguration = iTarget3.createConfiguration(iConfigurationArray[n], String.valueOf(iTarget3.getId()) + "." + n);
            } else {
                iTarget3.createConfiguration(iConfigurationArray[n], String.valueOf(iTarget3.getId()) + "." + n);
            }
            ++n;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)iProject, iConfiguration);
        this.checkRootTarget(iTarget3);
        iConfigurationArray = iTarget3.getConfigurations();
        ITool[] iToolArray = iConfigurationArray[0].getTools();
        IOptionCategory iOptionCategory = iToolArray[0].getTopOptionCategory();
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        IOption[] iOptionArray = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        iConfigurationArray[0].setOption(iOptionArray[0], "z");
        iOptionArray = iOptionCategoryArray[0].getOptions(null);
        Assert.assertEquals((String)"x", (String)iOptionArray[0].getStringValue());
        iOptionArray = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        Assert.assertEquals((String)"z", (String)iOptionArray[0].getStringValue());
        ManagedBuildManager.saveBuildInfo((IProject)iProject);
        try {
            iProject.close(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project close: " + coreException.getLocalizedMessage()));
        }
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        try {
            iProject.open(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project open: " + coreException.getLocalizedMessage()));
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertEquals((String)iConfiguration.getId(), (String)iManagedBuildInfo.getDefaultConfiguration(iTarget3).getId());
        iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)1, (int)iTargetArray.length);
        Assert.assertEquals((String)iTargetArray[0].getArtifactName(), (String)string);
        this.checkRootTarget(iTargetArray[0]);
        this.checkBuildTestSettings(iManagedBuildInfo);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
    }

    public void testProjectRename() {
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open project: " + coreException.getLocalizedMessage()));
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(projectRename);
        if (iResource != null) {
            try {
                iResource.delete(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                Assert.fail((String)("Failed to delete old project ManagedBuildRedux: " + coreException.getLocalizedMessage()));
            }
        }
        IProjectDescription iProjectDescription = null;
        try {
            iProjectDescription = iProject.getDescription();
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to find project descriptor for ManagedBuildTest: " + coreException.getLocalizedMessage()));
        }
        iProjectDescription.setName(projectRename);
        try {
            iProject.move(iProjectDescription, 33, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to rename project: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject = this.createProject(projectRename);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open renamed project: " + coreException.getLocalizedMessage()));
        }
        ITarget[] iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)2, (int)iTargetArray.length);
        ITarget iTarget = iTargetArray[0];
        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iConfigurationArray[0];
        ITool[] iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        IOption[] iOptionArray = iOptionCategory.getOptions(null);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        iOptionArray = iOptionCategoryArray[0].getOptions(null);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        iResource = iWorkspaceRoot.findMember(projectName);
        if (iResource != null) {
            try {
                iResource.delete(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                Assert.fail((String)("Failed to delete old project ManagedBuildTest: " + coreException.getLocalizedMessage()));
            }
        }
        try {
            iProjectDescription = iProject.getDescription();
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to find project descriptor for ManagedBuildRedux: " + coreException.getLocalizedMessage()));
        }
        iProjectDescription.setName(projectName);
        try {
            iProject.move(iProjectDescription, 33, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to re-rename project: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject = this.createProject(projectName);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open re-renamed project: " + coreException.getLocalizedMessage()));
        }
        iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)2, (int)iTargetArray.length);
        iTarget = iTargetArray[0];
        iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        iConfiguration = iConfigurationArray[0];
        iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        iTool = iToolArray[0];
        iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        iOptionArray = iOptionCategory.getOptions(null);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        iOptionArray = iOptionCategoryArray[0].getOptions(null);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
    }

    private void addManagedBuildNature(IProject iProject) {
        try {
            ManagedCProjectNature.addManagedNature((IProject)iProject, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on adding managed build nature: " + coreException.getLocalizedMessage()));
        }
        try {
            ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
            iCDescriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
            iCDescriptor.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on adding managed builder as scanner info provider: " + coreException.getLocalizedMessage()));
        }
    }

    private void checkBuildTestSettings(IManagedBuildInfo iManagedBuildInfo) {
        String string = "foo";
        String string2 = "bar";
        String string3 = "cpp";
        String string4 = rootExt;
        String string5 = "doIt";
        Assert.assertNotNull((Object)iManagedBuildInfo);
        Assert.assertEquals((String)iManagedBuildInfo.getBuildArtifactName(), (String)projectName);
        ITarget iTarget = iManagedBuildInfo.getDefaultTarget();
        Assert.assertNotNull((Object)iTarget);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration(iTarget);
        Assert.assertNotNull((Object)iConfiguration);
        List list = iManagedBuildInfo.getTargets();
        Assert.assertEquals((int)list.size(), (int)1);
        ITarget iTarget2 = (ITarget)list.get(0);
        Assert.assertEquals((Object)iTarget2, (Object)iTarget);
        Assert.assertEquals((String)iManagedBuildInfo.getOutputExtension(string), (String)string4);
        Assert.assertEquals((String)iManagedBuildInfo.getOutputExtension(string2), (String)string4);
        Assert.assertNull((Object)iManagedBuildInfo.getOutputExtension(string3));
        Assert.assertEquals((String)iManagedBuildInfo.getToolForSource(string), (String)string5);
        Assert.assertEquals((String)iManagedBuildInfo.getToolForSource(string2), (String)string5);
        Assert.assertNull((Object)iManagedBuildInfo.getToolForTarget(string));
        Assert.assertNull((Object)iManagedBuildInfo.getToolForTarget(string2));
        Assert.assertNull((Object)iManagedBuildInfo.getToolForSource(string4));
        Assert.assertEquals((String)iManagedBuildInfo.getToolForTarget(string4), (String)string5);
        Assert.assertEquals((String)iManagedBuildInfo.getFlagsForSource(string), (String)"-La -Lb z -e1");
        Assert.assertEquals((String)iManagedBuildInfo.getFlagsForSource(string), (String)iManagedBuildInfo.getFlagsForSource(string2));
    }

    private void checkOptionReferences(IProject iProject) throws BuildException {
        ITarget[] iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)1, (int)iTargetArray.length);
        ITarget iTarget = iTargetArray[0];
        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iTarget.getConfiguration(testConfigId);
        Assert.assertNotNull((Object)iConfiguration);
        ITool[] iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        IOption[] iOptionArray = iTool.getOptions();
        Assert.assertEquals((int)4, (int)iOptionArray.length);
        Assert.assertEquals((String)"List Option in Top", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)3, (int)iOptionArray[0].getValueType());
        Object[] objectArray = iOptionArray[0].getStringListValue();
        Assert.assertEquals((int)3, (int)objectArray.length);
        Assert.assertTrue((boolean)Arrays.equals(listVal, objectArray));
        Assert.assertEquals((String)iOptionArray[0].getCommand(), (String)"-L");
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[1].getValueType());
        Assert.assertEquals((boolean)true, (boolean)iOptionArray[1].getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOptionArray[1].getCommand());
        Assert.assertEquals((String)"String Option in Category", (String)iOptionArray[2].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[2].getValueType());
        Assert.assertEquals((String)stringVal, (String)iOptionArray[2].getStringValue());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOptionArray[3].getName());
        Assert.assertEquals((int)1, (int)iOptionArray[3].getValueType());
        String string = iOptionArray[3].getSelectedEnum();
        Assert.assertEquals((String)enumVal, (String)string);
        String[] stringArray = iOptionArray[3].getApplicableValues();
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"Default Enum", (String)stringArray[0]);
        Assert.assertEquals((String)enumVal, (String)stringArray[1]);
        Assert.assertEquals((String)"-e1", (String)iOptionArray[3].getEnumCommand(stringArray[0]));
        Assert.assertEquals((String)"-e2", (String)iOptionArray[3].getEnumCommand(stringArray[1]));
        Assert.assertEquals((String)"-e2", (String)iOptionArray[3].getEnumCommand(string));
    }

    private void checkRootTarget(ITarget iTarget) throws BuildException {
        String string = "del /myworld";
        String string2 = "org.eclipse.cdt.core.PE";
        Object[] objectArray = new String[]{"win32"};
        Assert.assertTrue((boolean)iTarget.isTestTarget());
        if (iTarget.getArtifactName().equals(projectName)) {
            Assert.assertEquals((String)iTarget.getArtifactExtension(), (String)newExt);
        } else {
            Assert.assertEquals((String)iTarget.getArtifactExtension(), (String)rootExt);
        }
        Assert.assertEquals((String)string, (String)iTarget.getCleanCommand());
        Assert.assertEquals((String)"make", (String)iTarget.getMakeCommand());
        Assert.assertEquals((String)string2, (String)iTarget.getBinaryParserId());
        Assert.assertTrue((boolean)Arrays.equals(objectArray, iTarget.getTargetOSList()));
        ITool[] iToolArray = iTarget.getTools();
        ITool iTool = iToolArray[0];
        Assert.assertEquals((String)"Root Tool", (String)iTool.getName());
        IOption[] iOptionArray = iTool.getOptions();
        Assert.assertEquals((int)4, (int)iOptionArray.length);
        Assert.assertEquals((String)"List Option in Top", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)3, (int)iOptionArray[0].getValueType());
        String[] stringArray = iOptionArray[0].getStringListValue();
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"a", (String)stringArray[0]);
        Assert.assertEquals((String)"b", (String)stringArray[1]);
        String[] stringArray2 = iOptionArray[0].getBuiltIns();
        Assert.assertEquals((int)1, (int)stringArray2.length);
        Assert.assertEquals((String)"c", (String)stringArray2[0]);
        Assert.assertEquals((String)iOptionArray[0].getCommand(), (String)"-L");
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[1].getValueType());
        Assert.assertEquals((boolean)false, (boolean)iOptionArray[1].getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOptionArray[1].getCommand());
        Assert.assertEquals((String)"String Option in Category", (String)iOptionArray[2].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[2].getValueType());
        Assert.assertEquals((String)"x", (String)iOptionArray[2].getStringValue());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOptionArray[3].getName());
        Assert.assertEquals((int)1, (int)iOptionArray[3].getValueType());
        Assert.assertEquals((String)"Default Enum", (String)iOptionArray[3].getSelectedEnum());
        stringArray = iOptionArray[3].getApplicableValues();
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"Default Enum", (String)stringArray[0]);
        Assert.assertEquals((String)enumVal, (String)stringArray[1]);
        Assert.assertEquals((String)"-e1", (String)iOptionArray[3].getEnumCommand(stringArray[0]));
        Assert.assertEquals((String)"-e2", (String)iOptionArray[3].getEnumCommand(stringArray[1]));
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        iOptionArray = iOptionCategory.getOptions(null);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        Assert.assertEquals((String)"List Option in Top", (String)iOptionArray[0].getName());
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        Assert.assertEquals((String)"Category", (String)iOptionCategoryArray[0].getName());
        iOptionArray = iOptionCategoryArray[0].getOptions(null);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        Assert.assertEquals((String)"String Option in Category", (String)iOptionArray[0].getName());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOptionArray[1].getName());
        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iConfigurationArray[0];
        Assert.assertEquals((String)"Root Config", (String)iConfiguration.getName());
        iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        Assert.assertEquals((String)"-r", (String)iToolArray[0].getOutputFlag());
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("foo"));
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("bar"));
        Assert.assertTrue((boolean)iToolArray[0].producesFileType(rootExt));
        Assert.assertEquals((String)"doIt", (String)iToolArray[0].getToolCommand());
        Assert.assertEquals((String)"", (String)iToolArray[0].getOutputPrefix());
        Assert.assertTrue((boolean)iTool.isHeaderFile("baz"));
        Assert.assertTrue((boolean)iToolArray[0].isHeaderFile("baz"));
        Assert.assertEquals((int)0, (int)iTool.getNatureFilter());
        Assert.assertEquals((String)"Root Override Config", (String)iConfigurationArray[1].getName());
        iToolArray = iConfigurationArray[1].getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertTrue((boolean)(iToolArray[0] instanceof ToolReference));
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        iOptionCategory = iToolArray[0].getTopOptionCategory();
        iOptionArray = iOptionCategory.getOptions(iConfigurationArray[1]);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        Assert.assertEquals((String)"List Option in Top", (String)iOptionArray[0].getName());
        stringArray = iOptionArray[0].getStringListValue();
        Assert.assertEquals((String)"a", (String)stringArray[0]);
        Assert.assertEquals((String)"b", (String)stringArray[1]);
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        Assert.assertEquals((boolean)true, (boolean)iOptionArray[1].getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOptionArray[1].getCommand());
        iOptionCategoryArray = iOptionCategory.getChildCategories();
        iOptionArray = iOptionCategoryArray[0].getOptions(iConfigurationArray[1]);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        Assert.assertEquals((String)"String Option in Category", (String)iOptionArray[0].getName());
        Assert.assertEquals((String)"y", (String)iOptionArray[0].getStringValue());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOptionArray[1].getName());
        stringArray = iOptionArray[1].getApplicableValues();
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"Default Enum", (String)stringArray[0]);
        Assert.assertEquals((String)enumVal, (String)stringArray[1]);
        Assert.assertEquals((String)"-e1", (String)iOptionArray[1].getEnumCommand(stringArray[0]));
        Assert.assertEquals((String)"-e2", (String)iOptionArray[1].getEnumCommand(stringArray[1]));
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        Assert.assertEquals((String)"-r", (String)iToolArray[0].getOutputFlag());
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("foo"));
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("bar"));
        Assert.assertTrue((boolean)iToolArray[0].producesFileType(rootExt));
        Assert.assertTrue((boolean)iToolArray[0].isHeaderFile("baz"));
        Assert.assertEquals((String)"doIt", (String)iToolArray[0].getToolCommand());
        Assert.assertEquals((String)"Complete Override Config", (String)iConfigurationArray[2].getName());
        iToolArray = iConfigurationArray[2].getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertTrue((boolean)(iToolArray[0] instanceof ToolReference));
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        iOptionCategory = iToolArray[0].getTopOptionCategory();
        iOptionArray = iOptionCategory.getOptions(iConfigurationArray[2]);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        Assert.assertTrue((boolean)(iOptionArray[0] instanceof OptionReference));
        Assert.assertEquals((String)"List Option in Top", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)3, (int)iOptionArray[0].getValueType());
        stringArray = iOptionArray[0].getStringListValue();
        Assert.assertTrue((stringArray.length == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"-L", (String)iOptionArray[0].getCommand());
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        Assert.assertTrue((boolean)(iOptionArray[1] instanceof OptionReference));
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[1].getValueType());
        Assert.assertEquals((boolean)true, (boolean)iOptionArray[1].getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOptionArray[1].getCommand());
        iOptionCategoryArray = iOptionCategory.getChildCategories();
        iOptionArray = iOptionCategoryArray[0].getOptions(iConfigurationArray[2]);
        Assert.assertEquals((int)2, (int)iOptionArray.length);
        Assert.assertTrue((boolean)(iOptionArray[0] instanceof OptionReference));
        Assert.assertEquals((String)"String Option in Category", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[0].getValueType());
        Assert.assertEquals((String)"overridden", (String)iOptionArray[0].getStringValue());
        Assert.assertTrue((boolean)(iOptionArray[1] instanceof OptionReference));
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)1, (int)iOptionArray[1].getValueType());
        Assert.assertEquals((String)"-e2", (String)iOptionArray[1].getSelectedEnum());
    }

    private void checkSubSubTarget(ITarget iTarget) {
        Assert.assertEquals((String)"rm -yourworld", (String)iTarget.getCleanCommand());
        Assert.assertEquals((String)"nmake", (String)iTarget.getMakeCommand());
        Assert.assertEquals((String)"org.eclipse.cdt.core.ELF", (String)iTarget.getBinaryParserId());
        Object[] objectArray = new String[]{"win32", "linux", "solaris"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, iTarget.getTargetOSList()));
        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        ITool[] iToolArray = iTarget.getTools();
        Assert.assertEquals((int)3, (int)iToolArray.length);
        ITool iTool = iToolArray[2];
        Assert.assertTrue((boolean)(iTool instanceof ToolReference));
        Assert.assertEquals((String)iTool.getName(), (String)"Target Independent Tool");
        Assert.assertEquals((String)iTool.getToolCommand(), (String)"RC.EXE");
        Assert.assertTrue((boolean)iTool.buildsFileType("rc"));
        Assert.assertEquals((String)iTool.getOutputExtension("rc"), (String)"free");
        Assert.assertEquals((String)iTool.getOutputFlag(), (String)"/fo");
        Assert.assertTrue((boolean)iTool.isHeaderFile("h"));
        Assert.assertFalse((boolean)iTool.isHeaderFile("j"));
        Assert.assertEquals((int)iTool.getNatureFilter(), (int)2);
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        Assert.assertEquals((String)iOptionCategoryArray[0].getName(), (String)"Free");
        IOptionCategory[] iOptionCategoryArray2 = iOptionCategoryArray[0].getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray2.length);
        Assert.assertEquals((String)iOptionCategoryArray2[0].getName(), (String)"Chained");
        IOption[] iOptionArray = iOptionCategoryArray[0].getOptions(null);
        Assert.assertEquals((int)1, (int)iOptionArray.length);
        Assert.assertEquals((String)"String in Free", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[0].getValueType());
        try {
            Assert.assertEquals((String)"Live free or die", (String)iOptionArray[0].getStringValue());
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failed getting string value in subsubtarget :" + buildException.getLocalizedMessage()));
        }
        IOption[] iOptionArray2 = iOptionCategoryArray2[0].getOptions(null);
        Assert.assertEquals((int)1, (int)iOptionArray2.length);
        Assert.assertEquals((String)"Boolean in Chained", (String)iOptionArray2[0].getName());
        Assert.assertEquals((int)0, (int)iOptionArray2[0].getValueType());
        try {
            Assert.assertFalse((boolean)iOptionArray2[0].getBooleanValue());
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failure getting boolean value in subsubtarget: " + buildException.getLocalizedMessage()));
        }
        ((ToolReference)iTool).setToolCommand("Let the Wookie win");
        Assert.assertEquals((String)iTool.getToolCommand(), (String)"Let the Wookie win");
    }

    private void checkSubTarget(ITarget iTarget) throws BuildException {
        Assert.assertEquals((String)"rm -yourworld", (String)iTarget.getCleanCommand());
        Assert.assertEquals((String)"make", (String)iTarget.getMakeCommand());
        Assert.assertEquals((String)"org.eclipse.cdt.core.PE", (String)iTarget.getBinaryParserId());
        Object[] objectArray = new String[]{"win32", "linux", "solaris"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, iTarget.getTargetOSList()));
        Assert.assertTrue((boolean)iTarget.isTestTarget());
        Assert.assertEquals((String)iTarget.getArtifactExtension(), (String)subExt);
        ITool[] iToolArray = iTarget.getTools();
        ITool iTool = iToolArray[0];
        Assert.assertEquals((String)"Root Tool", (String)iTool.getName());
        ITool iTool2 = iToolArray[1];
        Assert.assertEquals((String)"Sub Tool", (String)iTool2.getName());
        IOption[] iOptionArray = iTool2.getOptions();
        Assert.assertEquals((int)4, (int)iOptionArray.length);
        Assert.assertEquals((String)"", (String)iTool2.getOutputFlag());
        Assert.assertTrue((boolean)iTool2.buildsFileType("yarf"));
        Assert.assertTrue((boolean)iTool2.producesFileType(subExt));
        Assert.assertEquals((String)"", (String)iTool2.getToolCommand());
        Assert.assertEquals((String)"lib", (String)iTool2.getOutputPrefix());
        Assert.assertTrue((boolean)iTool2.isHeaderFile("arf"));
        Assert.assertTrue((boolean)iTool2.isHeaderFile("barf"));
        Assert.assertEquals((int)2, (int)iTool2.getNatureFilter());
        Assert.assertEquals((String)"Include Paths", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)4, (int)iOptionArray[0].getValueType());
        String[] stringArray = iOptionArray[0].getIncludePaths();
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"/usr/include", (String)stringArray[0]);
        Assert.assertEquals((String)"/opt/gnome/include", (String)stringArray[1]);
        String[] stringArray2 = iOptionArray[0].getBuiltIns();
        Assert.assertEquals((int)1, (int)stringArray2.length);
        Assert.assertEquals((String)"/usr/gnu/include", (String)stringArray2[0]);
        Assert.assertEquals((String)"-I", (String)iOptionArray[0].getCommand());
        Assert.assertEquals((String)"Defined Symbols", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)5, (int)iOptionArray[1].getValueType());
        String[] stringArray3 = iOptionArray[1].getDefinedSymbols();
        Assert.assertEquals((int)0, (int)stringArray3.length);
        Assert.assertEquals((String)"-D", (String)iOptionArray[1].getCommand());
        String[] stringArray4 = iOptionArray[1].getBuiltIns();
        Assert.assertEquals((int)1, (int)stringArray4.length);
        Assert.assertEquals((String)"BUILTIN", (String)stringArray4[0]);
        Assert.assertEquals((String)"More Includes", (String)iOptionArray[2].getName());
        Assert.assertEquals((int)4, (int)iOptionArray[2].getValueType());
        String[] stringArray5 = iOptionArray[2].getIncludePaths();
        Assert.assertEquals((int)2, (int)stringArray5.length);
        Assert.assertEquals((String)"C:\\home\\tester/include", (String)stringArray5[0]);
        Assert.assertEquals((String)"-I", (String)iOptionArray[2].getCommand());
        Assert.assertEquals((String)"User Objects", (String)iOptionArray[3].getName());
        Assert.assertEquals((int)7, (int)iOptionArray[3].getValueType());
        String[] stringArray6 = iOptionArray[3].getUserObjects();
        Assert.assertEquals((int)2, (int)stringArray6.length);
        Assert.assertEquals((String)"obj1.o", (String)stringArray6[0]);
        Assert.assertEquals((String)"obj2.o", (String)stringArray6[1]);
        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iConfigurationArray[0];
        Assert.assertEquals((String)"Root Config", (String)iConfiguration.getName());
        Assert.assertEquals((String)"Root Override Config", (String)iConfigurationArray[1].getName());
        Assert.assertEquals((String)"Complete Override Config", (String)iConfigurationArray[2].getName());
        Assert.assertEquals((String)"Sub Config", (String)iConfigurationArray[3].getName());
    }

    public void cleanup() {
        this.removeProject(projectName);
    }

    private IProject createProject(String string) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        IProject iProject2 = null;
        if (!iProject.exists()) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
            iProject2 = CCorePlugin.getDefault().createCProject(iProjectDescription, iProject, (IProgressMonitor)new NullProgressMonitor(), MakeCorePlugin.MAKE_PROJECT_ID);
        } else {
            iProject.refreshLocal(2, null);
            iProject2 = iProject;
        }
        if (!iProject2.isOpen()) {
            iProject2.open(null);
        }
        return iProject2;
    }

    private void removeProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject.exists()) {
            try {
                iProject.delete(true, false, null);
            }
            catch (CoreException coreException) {
                Assert.assertTrue((boolean)false);
            }
        }
    }

    public void testTargetBuildArtifact() throws CoreException {
        IProject iProject = this.createProject(projectName);
        ITarget[] iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)1, (int)iTargetArray.length);
        ITarget iTarget = iTargetArray[0];
        String string = iTarget.getArtifactExtension();
        String string2 = String.valueOf(iProject.getName()) + "." + string;
        iTarget.setArtifactName(string2);
        ManagedBuildManager.saveBuildInfo((IProject)iProject);
        iProject.close(null);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        iProject.open(null);
        iTargetArray = ManagedBuildManager.getTargets((IResource)iProject);
        Assert.assertEquals((int)1, (int)iTargetArray.length);
        iTarget = iTargetArray[0];
        Assert.assertEquals((String)string2, (String)iTarget.getArtifactName());
    }

    public void testThatAlwaysFails() {
        Assert.assertTrue((boolean)false);
    }

    public void testBug43450() throws Exception {
        IFile iFile;
        IProject iProject = this.createProject(projectName);
        new FileManager();
        IFolder iFolder = iProject.getProject().getFolder("includes");
        if (!iFolder.exists()) {
            iFolder.create(false, true, null);
        }
        if (!(iFile = iProject.getProject().getFile("includes/header.h")).exists()) {
            iFile.create((InputStream)new ByteArrayInputStream("class A { public : static int i; };".getBytes()), false, null);
        }
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        IScannerInfo iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject);
        NullSourceElementRequestor nullSourceElementRequestor = new NullSourceElementRequestor();
        IScanner iScanner = ParserFactory.createScanner((Reader)new StringReader("#include <header.h>\n int A::i = 1;"), (String)"TEST", (IScannerInfo)iScannerInfo, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)nullSourceElementRequestor, (IParserLogService)new NullLogService());
        IParser iParser = ParserFactory.createParser((IScanner)iScanner, (ISourceElementRequestor)nullSourceElementRequestor, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)ParserLanguage.CPP, null);
        Assert.assertTrue((boolean)iParser.parse());
    }
}

