/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.FunctionTemplate;
import org.eclipse.cdt.internal.core.model.MethodTemplate;
import org.eclipse.cdt.internal.core.model.StructureTemplate;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CModelElementsTests
extends TestCase {
    private ICProject fCProject;
    private IFile headerFile;
    private NullProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.CModelElementsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new CModelElementsTests("testCModelElements"));
        return testSuite;
    }

    public CModelElementsTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCCProject("TestProject1", "bin");
        this.headerFile = this.fCProject.getProject().getFile("CModelElementsTest.h");
        if (!this.headerFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/cfiles/CModelElementsTestStart.h")));
                this.headerFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    protected void tearDown() {
        CProjectHelper.delete(this.fCProject);
    }

    public void testCModelElements() {
        TranslationUnit translationUnit = new TranslationUnit((ICElement)this.fCProject, this.headerFile);
        translationUnit.parse();
        this.checkInclude((IParent)translationUnit);
        this.checkMacro((IParent)translationUnit);
        ArrayList arrayList = translationUnit.getChildrenOfType(61);
        INamespace iNamespace = (INamespace)arrayList.get(0);
        Assert.assertEquals((String)iNamespace.getElementName(), (String)new String("MyPackage"));
        this.checkElementOffset((CElement)iNamespace);
        this.checkLineNumbers((CElement)iNamespace, 8, 130);
        this.checkClass((IParent)iNamespace);
        this.checkEnums((IParent)iNamespace);
        this.checkVariables((IParent)iNamespace);
        this.checkVariableDeclarations((IParent)iNamespace);
        this.checkFunctions((IParent)iNamespace);
        this.checkStructs((IParent)iNamespace);
        this.checkTemplates((IParent)iNamespace);
        this.checkArrays((IParent)translationUnit);
    }

    private void checkInclude(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(72);
        IInclude iInclude = (IInclude)arrayList.get(0);
        Assert.assertEquals((String)iInclude.getElementName(), (String)new String("stdio.h"));
        this.checkElementOffset((CElement)iInclude);
        this.checkLineNumbers((CElement)iInclude, 2, 2);
    }

    private void checkMacro(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(77);
        IMacro iMacro = (IMacro)arrayList.get(0);
        Assert.assertEquals((String)iMacro.getElementName(), (String)new String("PRINT"));
        this.checkElementOffset((CElement)iMacro);
        this.checkLineNumbers((CElement)iMacro, 5, 5);
    }

    private void checkClass(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(64);
        IStructure iStructure = (IStructure)arrayList.get(0);
        Assert.assertEquals((String)iStructure.getElementName(), (String)new String("Hello"));
        this.checkElementOffset((CElement)iStructure);
        this.checkLineNumbers((CElement)iStructure, 12, 53);
        ArrayList arrayList2 = iStructure.getChildrenOfType(69);
        IField iField = (IField)arrayList2.get(0);
        Assert.assertEquals((String)iField.getElementName(), (String)new String("x"));
        this.checkElementOffset((CElement)iField);
        Assert.assertEquals((String)iField.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((CElement)iField, 17, 17);
        ASTAccessVisibility aSTAccessVisibility = iField.getVisibility();
        if (aSTAccessVisibility != ASTAccessVisibility.PROTECTED) {
            Assert.fail((String)"visibility should be protected!");
        }
        ArrayList arrayList3 = iStructure.getChildrenOfType(67);
        IMethod iMethod = (IMethod)arrayList3.get(0);
        Assert.assertEquals((String)iMethod.getElementName(), (String)new String("setX"));
        this.checkElementOffset((CElement)iMethod);
        Assert.assertEquals((String)iMethod.getReturnType(), (String)new String("void"));
        this.checkLineNumbers((CElement)iMethod, 19, 22);
        int n = iMethod.getNumberOfParameters();
        if (n != 1) {
            Assert.fail((String)"setX should have one parameter!");
        }
        String[] stringArray = iMethod.getParameterTypes();
        String string = stringArray[0];
        Assert.assertEquals((String)string, (String)new String("int"));
        this.checkNestedNamespace((IParent)iStructure);
    }

    private void checkNestedNamespace(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(61);
        INamespace iNamespace = (INamespace)arrayList.get(0);
        Assert.assertEquals((String)iNamespace.getElementName(), (String)new String("MyNestedPackage"));
        this.checkElementOffset((CElement)iNamespace);
        this.checkLineNumbers((CElement)iNamespace, 25, 52);
        this.checkParentNestedClass((IParent)iNamespace);
        this.checkDerivedNestedClass((IParent)iNamespace);
    }

    private void checkParentNestedClass(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(64);
        IStructure iStructure = (IStructure)arrayList.get(0);
        Assert.assertEquals((String)iStructure.getElementName(), (String)new String("Y"));
        this.checkElementOffset((CElement)iStructure);
        this.checkLineNumbers((CElement)iStructure, 28, 35);
        ArrayList arrayList2 = iStructure.getChildrenOfType(68);
        IMethodDeclaration iMethodDeclaration = (IMethodDeclaration)arrayList2.get(0);
        Assert.assertEquals((String)iMethodDeclaration.getElementName(), (String)new String("Y"));
        this.checkElementOffset((CElement)iMethodDeclaration);
        Assert.assertTrue((boolean)iMethodDeclaration.isConstructor());
        this.checkLineNumbers((CElement)iMethodDeclaration, 32, 32);
        IMethodDeclaration iMethodDeclaration2 = (IMethodDeclaration)arrayList2.get(1);
        Assert.assertEquals((String)iMethodDeclaration2.getElementName(), (String)new String("~Y"));
        this.checkElementOffset((CElement)iMethodDeclaration2);
        Assert.assertTrue((boolean)iMethodDeclaration2.isDestructor());
        this.checkLineNumbers((CElement)iMethodDeclaration2, 34, 34);
    }

    private void checkDerivedNestedClass(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(64);
        IStructure iStructure = (IStructure)arrayList.get(1);
        Assert.assertEquals((String)iStructure.getElementName(), (String)new String("X"));
        this.checkElementOffset((CElement)iStructure);
        this.checkLineNumbers((CElement)iStructure, 38, 51);
        ArrayList arrayList2 = iStructure.getChildrenOfType(69);
        IField iField = (IField)arrayList2.get(0);
        Assert.assertEquals((String)iField.getElementName(), (String)new String("b"));
        this.checkElementOffset((CElement)iField);
        Assert.assertEquals((String)iField.getTypeName(), (String)new String("B"));
        this.checkLineNumbers((CElement)iField, 42, 42);
        ASTAccessVisibility aSTAccessVisibility = iField.getVisibility();
        if (aSTAccessVisibility != ASTAccessVisibility.PRIVATE) {
            Assert.fail((String)"visibility should be private!");
        }
        ArrayList arrayList3 = iStructure.getChildrenOfType(67);
        IMethod iMethod = (IMethod)arrayList3.get(0);
        Assert.assertEquals((String)iMethod.getElementName(), (String)new String("X"));
        this.checkElementOffset((CElement)iMethod);
        Assert.assertTrue((boolean)iMethod.isConstructor());
        this.checkLineNumbers((CElement)iMethod, 46, 48);
        ArrayList arrayList4 = iStructure.getChildrenOfType(68);
        IMethodDeclaration iMethodDeclaration = (IMethodDeclaration)arrayList4.get(0);
        Assert.assertEquals((String)iMethodDeclaration.getElementName(), (String)new String("doNothing"));
        this.checkElementOffset((CElement)iMethodDeclaration);
        Assert.assertEquals((String)iMethodDeclaration.getReturnType(), (String)new String("int"));
        this.checkLineNumbers((CElement)iMethodDeclaration, 50, 50);
    }

    private void checkEnums(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(63);
        IEnumeration iEnumeration = (IEnumeration)arrayList.get(0);
        Assert.assertEquals((String)iEnumeration.getElementName(), (String)new String(""));
        this.checkElementOffset((CElement)iEnumeration);
        this.checkLineNumbers((CElement)iEnumeration, 57, 61);
        ArrayList arrayList2 = iEnumeration.getChildrenOfType(79);
        IEnumerator iEnumerator = (IEnumerator)arrayList2.get(0);
        Assert.assertEquals((String)iEnumerator.getElementName(), (String)new String("first"));
        Assert.assertEquals((String)"1", (String)iEnumerator.getConstantExpression());
        this.checkElementOffset((CElement)iEnumerator);
        IEnumerator iEnumerator2 = (IEnumerator)arrayList2.get(1);
        Assert.assertEquals((String)iEnumerator2.getElementName(), (String)new String("second"));
        this.checkElementOffset((CElement)iEnumerator2);
        IEnumerator iEnumerator3 = (IEnumerator)arrayList2.get(2);
        this.checkElementOffset((CElement)iEnumerator3);
        Assert.assertEquals((String)iEnumerator3.getElementName(), (String)new String("third"));
        this.checkElementOffset((CElement)iEnumerator3);
        IEnumeration iEnumeration2 = (IEnumeration)arrayList.get(1);
        Assert.assertEquals((String)iEnumeration2.getElementName(), (String)new String("MyEnum"));
        this.checkElementOffset((CElement)iEnumeration2);
        this.checkLineNumbers((CElement)iEnumeration2, 64, 67);
        ArrayList arrayList3 = iEnumeration2.getChildrenOfType(79);
        IEnumerator iEnumerator4 = (IEnumerator)arrayList3.get(0);
        Assert.assertEquals((String)iEnumerator4.getElementName(), (String)new String("f"));
        this.checkElementOffset((CElement)iEnumerator4);
        IEnumerator iEnumerator5 = (IEnumerator)arrayList3.get(1);
        Assert.assertEquals((String)iEnumerator5.getElementName(), (String)new String("s"));
        this.checkElementOffset((CElement)iEnumerator5);
        IEnumerator iEnumerator6 = (IEnumerator)arrayList3.get(2);
        Assert.assertEquals((String)iEnumerator6.getElementName(), (String)new String("t"));
        this.checkElementOffset((CElement)iEnumerator6);
    }

    private void checkVariables(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(74);
        IVariable iVariable = (IVariable)arrayList.get(0);
        Assert.assertEquals((String)iVariable.getElementName(), (String)new String("v"));
        this.checkElementOffset((CElement)iVariable);
        Assert.assertEquals((String)iVariable.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((CElement)iVariable, 71, 71);
        IVariable iVariable2 = (IVariable)arrayList.get(1);
        Assert.assertEquals((String)iVariable2.getElementName(), (String)new String("vuLong"));
        this.checkElementOffset((CElement)iVariable2);
        Assert.assertEquals((String)iVariable2.getTypeName(), (String)new String("unsigned long int"));
        this.checkLineNumbers((CElement)iVariable2, 73, 73);
        IVariable iVariable3 = (IVariable)arrayList.get(2);
        Assert.assertEquals((String)iVariable3.getElementName(), (String)new String("vuShort"));
        this.checkElementOffset((CElement)iVariable3);
        Assert.assertEquals((String)iVariable3.getTypeName(), (String)new String("unsigned short int"));
        this.checkLineNumbers((CElement)iVariable3, 75, 75);
        IVariable iVariable4 = (IVariable)arrayList.get(3);
        Assert.assertEquals((String)iVariable4.getElementName(), (String)new String("orig_malloc_hook"));
        this.checkElementOffset((CElement)iVariable4);
        Assert.assertEquals((String)iVariable4.getTypeName(), (String)new String("void*(*)(const char*, int, size_t)"));
        this.checkLineNumbers((CElement)iVariable4, 81, 81);
    }

    private void checkVariableDeclarations(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(75);
        IVariableDeclaration iVariableDeclaration = (IVariableDeclaration)arrayList.get(0);
        Assert.assertEquals((String)iVariableDeclaration.getElementName(), (String)new String("evar"));
        this.checkElementOffset((CElement)iVariableDeclaration);
        Assert.assertEquals((String)iVariableDeclaration.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((CElement)iVariableDeclaration, 79, 79);
    }

    private void checkFunctions(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(70);
        IFunctionDeclaration iFunctionDeclaration = (IFunctionDeclaration)arrayList.get(0);
        Assert.assertEquals((String)iFunctionDeclaration.getElementName(), (String)new String("foo"));
        this.checkElementOffset((CElement)iFunctionDeclaration);
        Assert.assertEquals((String)iFunctionDeclaration.getReturnType(), (String)new String("void"));
        this.checkLineNumbers((CElement)iFunctionDeclaration, 85, 85);
        IFunctionDeclaration iFunctionDeclaration2 = (IFunctionDeclaration)arrayList.get(1);
        Assert.assertEquals((String)iFunctionDeclaration2.getElementName(), (String)new String("foo"));
        this.checkElementOffset((CElement)iFunctionDeclaration2);
        Assert.assertEquals((String)iFunctionDeclaration2.getReturnType(), (String)new String("char*"));
        this.checkLineNumbers((CElement)iFunctionDeclaration2, 87, 88);
        int n = iFunctionDeclaration2.getNumberOfParameters();
        if (n != 2) {
            Assert.fail((String)"foo should have two parameter!");
        }
        String[] stringArray = iFunctionDeclaration2.getParameterTypes();
        Assert.assertEquals((String)stringArray[0], (String)new String("int&"));
        Assert.assertEquals((String)stringArray[1], (String)new String("char**"));
        ArrayList arrayList2 = iParent.getChildrenOfType(71);
        IFunction iFunction = (IFunction)arrayList2.get(0);
        Assert.assertEquals((String)iFunction.getElementName(), (String)new String("boo"));
        this.checkElementOffset((CElement)iFunction);
        Assert.assertEquals((String)iFunction.getReturnType(), (String)new String("void"));
        this.checkLineNumbers((CElement)iFunction, 90, 92);
    }

    private void checkStructs(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(65);
        IStructure iStructure = (IStructure)arrayList.get(0);
        Assert.assertEquals((String)iStructure.getElementName(), (String)new String("MyStruct"));
        this.checkElementOffset((CElement)iStructure);
        this.checkLineNumbers((CElement)iStructure, 95, 97);
        ArrayList arrayList2 = iStructure.getChildrenOfType(69);
        IField iField = (IField)arrayList2.get(0);
        Assert.assertEquals((String)iField.getElementName(), (String)new String("sint"));
        this.checkElementOffset((CElement)iField);
        Assert.assertEquals((String)iField.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((CElement)iField, 96, 96);
        if (iField.getVisibility() != ASTAccessVisibility.PUBLIC) {
            Assert.fail((String)"field visibility should be public!");
        }
        IStructure iStructure2 = (IStructure)arrayList.get(1);
        Assert.assertEquals((String)iStructure2.getElementName(), (String)new String(""));
        this.checkElementOffset((CElement)iStructure2);
        this.checkLineNumbers((CElement)iStructure2, 101, 103);
        ArrayList arrayList3 = iStructure2.getChildrenOfType(69);
        IField iField2 = (IField)arrayList3.get(0);
        Assert.assertEquals((String)iField2.getElementName(), (String)new String("ss"));
        this.checkElementOffset((CElement)iField2);
        Assert.assertEquals((String)iField2.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((CElement)iField2, 102, 102);
        if (iField2.getVisibility() != ASTAccessVisibility.PUBLIC) {
            Assert.fail((String)"field visibility should be public!");
        }
        ArrayList arrayList4 = iParent.getChildrenOfType(78);
        ITypeDef iTypeDef = (ITypeDef)arrayList4.get(0);
        Assert.assertEquals((String)iTypeDef.getElementName(), (String)new String("myStruct"));
        this.checkElementOffset((CElement)iTypeDef);
        Assert.assertEquals((String)iTypeDef.getTypeName(), (String)new String("struct MyStruct"));
        this.checkLineNumbers((CElement)iTypeDef, 99, 99);
        ITypeDef iTypeDef2 = (ITypeDef)arrayList4.get(1);
        Assert.assertEquals((String)iTypeDef2.getElementName(), (String)new String("myTypedef"));
        this.checkElementOffset((CElement)iTypeDef2);
        Assert.assertEquals((String)iTypeDef2.getTypeName(), (String)new String(""));
        this.checkLineNumbers((CElement)iTypeDef2, 101, 103);
        ArrayList arrayList5 = iParent.getChildrenOfType(66);
        IStructure iStructure3 = (IStructure)arrayList5.get(0);
        Assert.assertEquals((String)iStructure3.getElementName(), (String)new String("U"));
        this.checkElementOffset((CElement)iStructure3);
        this.checkLineNumbers((CElement)iStructure3, 105, 107);
        ArrayList arrayList6 = iStructure3.getChildrenOfType(69);
        IField iField3 = (IField)arrayList6.get(0);
        Assert.assertEquals((String)iField3.getElementName(), (String)new String("U1"));
        this.checkElementOffset((CElement)iField3);
        Assert.assertEquals((String)iField3.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((CElement)iField3, 106, 106);
        if (iField3.getVisibility() != ASTAccessVisibility.PUBLIC) {
            Assert.fail((String)"field visibility should be public!");
        }
    }

    private void checkTemplates(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(80);
        FunctionTemplate functionTemplate = (FunctionTemplate)arrayList.get(0);
        Assert.assertEquals((String)functionTemplate.getElementName(), (String)new String("aTemplatedFunction"));
        this.checkElementOffset((CElement)functionTemplate);
        functionTemplate.getTemplateSignature();
        Assert.assertEquals((String)functionTemplate.getTemplateSignature(), (String)new String("aTemplatedFunction<A, B>(B) : A"));
        this.checkLineNumbers((CElement)functionTemplate, 112, 113);
        ArrayList arrayList2 = iParent.getChildrenOfType(64);
        IStructure iStructure = (IStructure)arrayList2.get(1);
        this.checkLineNumbers((CElement)iStructure, 115, 120);
        ArrayList arrayList3 = iStructure.getChildrenOfType(81);
        MethodTemplate methodTemplate = (MethodTemplate)arrayList3.get(0);
        Assert.assertEquals((String)methodTemplate.getElementName(), (String)new String("aTemplatedMethod"));
        this.checkElementOffset((CElement)methodTemplate);
        Assert.assertEquals((String)methodTemplate.getTemplateSignature(), (String)new String("aTemplatedMethod<A, B>(B) : A"));
        this.checkLineNumbers((CElement)methodTemplate, 118, 119);
        Assert.assertEquals((Object)methodTemplate.getVisibility(), (Object)ASTAccessVisibility.PUBLIC);
        ArrayList arrayList4 = iParent.getChildrenOfType(73);
        StructureTemplate structureTemplate = (StructureTemplate)arrayList4.get(0);
        Assert.assertEquals((String)structureTemplate.getElementName(), (String)new String("myarray"));
        this.checkElementOffset((CElement)structureTemplate);
        Assert.assertEquals((String)structureTemplate.getTemplateSignature(), (String)new String("myarray<T, Tibor>"));
        this.checkLineNumbers((CElement)structureTemplate, 122, 123);
        ArrayList arrayList5 = iParent.getChildrenOfType(82);
        StructureTemplate structureTemplate2 = (StructureTemplate)arrayList5.get(0);
        Assert.assertEquals((String)structureTemplate2.getElementName(), (String)new String("mystruct"));
        this.checkElementOffset((CElement)structureTemplate2);
        Assert.assertEquals((String)structureTemplate2.getTemplateSignature(), (String)new String("mystruct<T, Tibor>"));
        this.checkLineNumbers((CElement)structureTemplate2, 125, 126);
    }

    private void checkArrays(IParent iParent) {
        ArrayList arrayList = iParent.getChildrenOfType(74);
        IVariable iVariable = (IVariable)arrayList.get(0);
        Assert.assertEquals((String)iVariable.getElementName(), (String)new String("myArray"));
        this.checkElementOffset((CElement)iVariable);
        Assert.assertEquals((String)iVariable.getTypeName(), (String)new String("int[][]"));
        this.checkLineNumbers((CElement)iVariable, 133, 133);
        ArrayList arrayList2 = iParent.getChildrenOfType(71);
        IFunction iFunction = (IFunction)arrayList2.get(0);
        Assert.assertEquals((String)iFunction.getElementName(), (String)new String("main"));
        this.checkElementOffset((CElement)iFunction);
        Assert.assertEquals((String)iFunction.getReturnType(), (String)new String("int"));
        this.checkLineNumbers((CElement)iFunction, 134, 136);
        int n = iFunction.getNumberOfParameters();
        if (n != 2) {
            Assert.fail((String)"main should have two parameter!");
        }
        String[] stringArray = iFunction.getParameterTypes();
        Assert.assertEquals((String)stringArray[0], (String)new String("int"));
        Assert.assertEquals((String)stringArray[1], (String)new String("char*[]"));
    }

    private void checkLineNumbers(CElement cElement, int n, int n2) {
        Assert.assertEquals((int)n, (int)cElement.getStartLine());
        Assert.assertEquals((int)n2, (int)cElement.getEndLine());
    }

    private void checkElementOffset(CElement cElement) {
        if (cElement.getElementName().length() > 0) {
            Assert.assertTrue((cElement.getStartPos() <= cElement.getIdStartPos() ? 1 : 0) != 0);
            Assert.assertEquals((int)cElement.getIdLength(), (int)cElement.getElementName().length());
        } else {
            Assert.assertEquals((int)cElement.getStartPos(), (int)cElement.getIdStartPos());
            if (cElement instanceof ITypeDef) {
                Assert.assertEquals((int)cElement.getIdLength(), (int)((ITypeDef)cElement).getTypeName().length());
            } else if (cElement instanceof IEnumeration) {
                Assert.assertEquals((int)cElement.getIdLength(), (int)((IEnumeration)cElement).getTypeName().length());
            } else if (cElement instanceof IStructure) {
                Assert.assertEquals((int)cElement.getIdLength(), (int)((IStructure)cElement).getTypeName().length());
            }
        }
    }
}

