/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CModelTests
extends TestCase {
    IWorkspace workspace;
    IWorkspaceRoot root;
    IProject project_c;
    IProject project_cc;
    NullProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    public CModelTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.root = this.workspace.getRoot();
        this.monitor = new NullProgressMonitor();
        if (this.workspace == null) {
            Assert.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            Assert.fail((String)"Workspace root was not setup");
        }
        IWorkspaceDescription iWorkspaceDescription = this.workspace.getDescription();
        iWorkspaceDescription.setAutoBuilding(false);
        this.workspace.setDescription(iWorkspaceDescription);
    }

    protected void tearDown() {
    }

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.CModelTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CModelTests.suite());
    }

    public void testHasNature() throws CoreException {
        ICProject iCProject = CProjectHelper.createCProject("naturetest", "none");
        if (iCProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        Assert.assertTrue((String)"hasCNature works", (boolean)CoreModel.getDefault().hasCNature(iCProject.getProject()));
        Assert.assertTrue((String)"hasCCNature works without ccnature", (!CoreModel.getDefault().hasCCNature(iCProject.getProject()) ? 1 : 0) != 0);
        CCProjectNature.addCCNature((IProject)iCProject.getProject(), (IProgressMonitor)this.monitor);
        Assert.assertTrue((String)"hasCCNature works", (boolean)CoreModel.getDefault().hasCCNature(iCProject.getProject()));
        CCProjectNature.removeCCNature((IProject)iCProject.getProject(), (IProgressMonitor)this.monitor);
        CProjectNature.removeCNature((IProject)iCProject.getProject(), (IProgressMonitor)this.monitor);
        Assert.assertTrue((String)"hasCNature works without cnature", (!CoreModel.getDefault().hasCNature(iCProject.getProject()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"hasCCNature works without ccnature or cnature", (!CoreModel.getDefault().hasCCNature(iCProject.getProject()) ? 1 : 0) != 0);
        try {
            iCProject.getProject().delete(true, true, (IProgressMonitor)this.monitor);
        }
        catch (ResourceException resourceException) {
        }
        catch (CoreException coreException) {}
    }

    public void testFileType() throws CoreException, FileNotFoundException {
        IFile iFile;
        ICProject iCProject = CProjectHelper.createCProject("filetest", "none");
        if (iCProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        if (!(iFile = iCProject.getProject().getFile("exetest_g")).exists()) {
            iFile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o.g/exe_g"))), false, (IProgressMonitor)this.monitor);
        }
        Assert.assertTrue((String)"isBinary", (boolean)CoreModel.getDefault().isBinary(iFile));
        Assert.assertTrue((String)"isExecutable", (boolean)CoreModel.getDefault().isExecutable(iFile));
        Assert.assertTrue((String)"isSharedLib", (!CoreModel.getDefault().isSharedLib(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isArchive", (!CoreModel.getDefault().isArchive(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isObject", (!CoreModel.getDefault().isObject(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isTranslationUnit", (!CoreModel.getDefault().isTranslationUnit(iFile) ? 1 : 0) != 0);
        iFile = iCProject.getProject().getFile("exetest.c");
        if (!iFile.exists()) {
            iFile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/main.c"))), false, (IProgressMonitor)this.monitor);
        }
        Assert.assertTrue((String)"isBinary", (!CoreModel.getDefault().isBinary(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isExecutable", (!CoreModel.getDefault().isExecutable(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isSharedLib", (!CoreModel.getDefault().isSharedLib(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isArchive", (!CoreModel.getDefault().isArchive(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isObject", (!CoreModel.getDefault().isObject(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isTranslationUnit", (boolean)CoreModel.getDefault().isTranslationUnit(iFile));
        iFile = iCProject.getProject().getFile("exetest.o");
        if (!iFile.exists()) {
            iFile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o.g/main.o"))), false, (IProgressMonitor)this.monitor);
        }
        Assert.assertTrue((String)"isBinary", (boolean)CoreModel.getDefault().isBinary(iFile));
        Assert.assertTrue((String)"isExecutable", (!CoreModel.getDefault().isExecutable(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isSharedLib", (!CoreModel.getDefault().isSharedLib(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isArchive", (!CoreModel.getDefault().isArchive(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isObject", (boolean)CoreModel.getDefault().isObject(iFile));
        Assert.assertTrue((String)"isTranslationUnit", (!CoreModel.getDefault().isTranslationUnit(iFile) ? 1 : 0) != 0);
        iFile = iCProject.getProject().getFile("liblibtest_g.so");
        if (!iFile.exists()) {
            iFile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/testlib/x86/so.g/libtestlib_g.so"))), false, (IProgressMonitor)this.monitor);
        }
        Assert.assertTrue((String)"isBinary", (boolean)CoreModel.getDefault().isBinary(iFile));
        Assert.assertTrue((String)"isExecutable", (!CoreModel.getDefault().isExecutable(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isSharedLib", (boolean)CoreModel.getDefault().isSharedLib(iFile));
        Assert.assertTrue((String)"isArchive", (!CoreModel.getDefault().isArchive(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isObject", (!CoreModel.getDefault().isObject(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isTranslationUnit", (!CoreModel.getDefault().isTranslationUnit(iFile) ? 1 : 0) != 0);
        iFile = iCProject.getProject().getFile("liblibtest_g.a");
        if (!iFile.exists()) {
            iFile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/testlib/x86/a.g/libtestlib_g.a"))), false, (IProgressMonitor)this.monitor);
        } else {
            Assert.fail((String)"Does not exist?");
        }
        Assert.assertTrue((String)"isArchive", (boolean)CoreModel.getDefault().isArchive(iFile));
        Assert.assertTrue((String)"isBinary:", (!CoreModel.getDefault().isBinary(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isExecutable", (!CoreModel.getDefault().isExecutable(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isSharedLib", (!CoreModel.getDefault().isSharedLib(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isArchive", (boolean)CoreModel.getDefault().isArchive(iFile));
        Assert.assertTrue((String)"isObject", (!CoreModel.getDefault().isObject(iFile) ? 1 : 0) != 0);
        Assert.assertTrue((String)"isTranslationUnit", (!CoreModel.getDefault().isTranslationUnit(iFile) ? 1 : 0) != 0);
        try {
            iCProject.getProject().delete(true, true, (IProgressMonitor)this.monitor);
        }
        catch (ResourceException resourceException) {
        }
        catch (CoreException coreException) {}
    }

    public void testIsValidTranslationUnitName() throws CoreException {
        Assert.assertTrue((String)"Invalid C file", (!CoreModel.getDefault().isValidTranslationUnitName("notcfile") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Invalid C file", (!CoreModel.getDefault().isValidTranslationUnitName("not.c.file") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Invalid C file", (!CoreModel.getDefault().isValidTranslationUnitName("not.ca") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Valid C file", (boolean)CoreModel.getDefault().isValidTranslationUnitName("areal.c"));
    }
}

