/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.cdt.testplugin.TestPluginLauncher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ElementDeltaTests
extends TestCase
implements IElementChangedListener {
    private ICProject fCProject;
    private IFile headerFile;
    private NullProgressMonitor monitor;
    private Vector addedElements;
    private Vector removedElements;
    private Vector changedElements;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void main(String[] stringArray) {
        String string = TestPluginLauncher.getLocationFromProperties();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.WorkingCopyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestPluginLauncher.run(string, clazz, stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.tests.ElementDeltaTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ElementDeltaTests("testElementDeltas"));
        return testSuite;
    }

    public ElementDeltaTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCCProject("TestProject1", "bin");
        this.headerFile = this.fCProject.getProject().getFile("WorkingCopyTest.h");
        if (!this.headerFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/cfiles/WorkingCopyTestStart.h")));
                this.headerFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        CModelManager.getDefault().addElementChangedListener((IElementChangedListener)this);
        this.addedElements = new Vector(10);
        this.removedElements = new Vector(10);
        this.changedElements = new Vector(20);
    }

    protected void tearDown() {
        CProjectHelper.delete(this.fCProject);
    }

    public void testElementDeltas() throws Exception {
        TranslationUnit translationUnit = new TranslationUnit((ICElement)this.fCProject, this.headerFile);
        Assert.assertNotNull((Object)translationUnit);
        IWorkingCopy iWorkingCopy = translationUnit.getWorkingCopy();
        Assert.assertNotNull((Object)iWorkingCopy);
        Assert.assertNotNull((Object)iWorkingCopy.getBuffer());
        Assert.assertTrue((boolean)iWorkingCopy.exists());
        IBuffer iBuffer = iWorkingCopy.getBuffer();
        iBuffer.setContents("\n class Hello{ \n};");
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        this.assertChangedElement(10, "");
        this.assertChangedElement(11, "TestProject1");
        this.assertChangedElement(60, "WorkingCopyTest.h");
        this.assertAddedElement(64, "Hello");
        this.assertRemovedElement(72, "stdio.h");
        this.assertEmptyDelta();
        iBuffer.setContents("\n class Hello{\n int x; \n};");
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        this.assertChangedElement(10, "");
        this.assertChangedElement(11, "TestProject1");
        this.assertChangedElement(60, "WorkingCopyTest.h");
        this.assertChangedElement(64, "Hello");
        this.assertAddedElement(69, "x");
        this.assertEmptyDelta();
        iBuffer.setContents("\n class Hello{\n int x; \n void setValue(int val); \n};");
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        this.assertChangedElement(10, "");
        this.assertChangedElement(11, "TestProject1");
        this.assertChangedElement(60, "WorkingCopyTest.h");
        this.assertChangedElement(64, "Hello");
        this.assertAddedElement(68, "setValue");
        this.assertEmptyDelta();
        iBuffer.setContents("\n class Hello{\n int y; \n void setValue(int val); \n};");
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        this.assertChangedElement(10, "");
        this.assertChangedElement(11, "TestProject1");
        this.assertChangedElement(60, "WorkingCopyTest.h");
        this.assertChangedElement(64, "Hello");
        this.assertAddedElement(69, "y");
        this.assertRemovedElement(69, "x");
        this.assertEmptyDelta();
        iBuffer.setContents("\n class Hello{\n String y; \n};");
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        this.assertChangedElement(10, "");
        this.assertChangedElement(11, "TestProject1");
        this.assertChangedElement(60, "WorkingCopyTest.h");
        this.assertChangedElement(64, "Hello");
        this.assertChangedElement(69, "y");
        this.assertRemovedElement(68, "setValue");
        this.assertEmptyDelta();
        iBuffer.setContents("\n class Hello{ \n};");
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        this.assertChangedElement(10, "");
        this.assertChangedElement(11, "TestProject1");
        this.assertChangedElement(60, "WorkingCopyTest.h");
        this.assertChangedElement(64, "Hello");
        this.assertRemovedElement(69, "y");
        this.assertEmptyDelta();
        iBuffer.setContents("");
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        this.assertChangedElement(10, "");
        this.assertChangedElement(11, "TestProject1");
        this.assertChangedElement(60, "WorkingCopyTest.h");
        this.assertRemovedElement(64, "Hello");
        this.assertEmptyDelta();
        iWorkingCopy.destroy();
        Assert.assertFalse((boolean)iWorkingCopy.exists());
    }

    public void assertAddedElement(int n, String string) {
        if (!this.isElementInList(n, string, this.addedElements)) {
            Assert.fail((String)"Element NOT found in Added list");
        }
    }

    public void assertRemovedElement(int n, String string) {
        if (!this.isElementInList(n, string, this.removedElements)) {
            Assert.fail((String)"Element NOT found in Removed list");
        }
    }

    public void assertChangedElement(int n, String string) {
        if (!this.isElementInList(n, string, this.changedElements)) {
            Assert.fail((String)"Element NOT found in Changed list");
        }
    }

    public void assertEmptyDelta() {
        Assert.assertTrue((boolean)this.addedElements.isEmpty());
        Assert.assertTrue((boolean)this.removedElements.isEmpty());
        Assert.assertTrue((boolean)this.changedElements.isEmpty());
    }

    public boolean isElementInList(int n, String string, Vector vector) {
        boolean bl = false;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            ICElement iCElement = (ICElement)iterator.next();
            if (!iCElement.getElementName().equals(string) || iCElement.getElementType() != n) continue;
            bl = true;
            vector.remove(iCElement);
            break;
        }
        return bl;
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.addedElements.clear();
            this.removedElements.clear();
            this.changedElements.clear();
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (CModelException cModelException) {}
    }

    protected void processDelta(ICElementDelta iCElementDelta) throws CModelException {
        int n = iCElementDelta.getKind();
        int n2 = iCElementDelta.getFlags();
        ICElement iCElement = iCElementDelta.getElement();
        if (n == 2) {
            this.removedElements.add(iCElement);
        }
        if (n == 1) {
            this.addedElements.add(iCElement);
        }
        if (n == 4) {
            this.changedElements.add(iCElement);
        }
        ICElementDelta[] iCElementDeltaArray = iCElementDelta.getAffectedChildren();
        int n3 = 0;
        while (n3 < iCElementDeltaArray.length) {
            this.processDelta(iCElementDeltaArray[n3]);
            ++n3;
        }
    }
}

