/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.cdt.testplugin.TestPluginLauncher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkingCopyTests
extends TestCase {
    private ICProject fCProject;
    private IFile headerFile;
    private NullProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    public static void main(String[] stringArray) {
        String string = TestPluginLauncher.getLocationFromProperties();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.WorkingCopyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestPluginLauncher.run(string, clazz, stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.WorkingCopyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new WorkingCopyTests("testWorkingCopy"));
        return testSuite;
    }

    public WorkingCopyTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCCProject("TestProject1", "bin");
        this.headerFile = this.fCProject.getProject().getFile("WorkingCopyTest.h");
        if (!this.headerFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/cfiles/WorkingCopyTestStart.h")));
                this.headerFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    protected void tearDown() {
        CProjectHelper.delete(this.fCProject);
    }

    public void testWorkingCopy() throws Exception {
        TranslationUnit translationUnit = new TranslationUnit((ICElement)this.fCProject, this.headerFile);
        Assert.assertNotNull((Object)translationUnit);
        IWorkingCopy iWorkingCopy = translationUnit.getWorkingCopy();
        Assert.assertNotNull((Object)iWorkingCopy);
        Assert.assertNotNull((Object)iWorkingCopy.getBuffer());
        Assert.assertTrue((boolean)iWorkingCopy.exists());
        IBuffer iBuffer = iWorkingCopy.getBuffer();
        iBuffer.append("\n class Hello{ int x; };");
        if (translationUnit.getBuffer().getContents().equals(iWorkingCopy.getBuffer().getContents())) {
            Assert.fail((String)"Buffers should NOT be equal at this point!");
        }
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        if (!translationUnit.getBuffer().getContents().equals(iWorkingCopy.getBuffer().getContents())) {
            Assert.fail((String)"Buffers should be equal at this point!");
        }
        iWorkingCopy.destroy();
        Assert.assertFalse((boolean)iWorkingCopy.exists());
        Thread.sleep(1000L);
    }
}

