/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;

public class CompleteParseASTExpressionTest
extends CompleteParseBaseTest {
    public CompleteParseASTExpressionTest(String string) {
        super(string);
    }

    public void testPrimaryEmpty() throws Exception {
        Iterator iterator = this.parse("int f(char); \n int f(void); \n int x = f();").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPrimaryIntegerLiteral() throws Exception {
        Iterator iterator = this.parse("int f(int, int); \n int f(int); \n int x = f(1, 2+3);").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPrimaryCharLiteral() throws Exception {
        Iterator iterator = this.parse("int f(char, int); \n int f(char); \n int x = f('c');").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPrimaryFloatLiteral() throws Exception {
        Iterator iterator = this.parse("int f(char); \n int f(float); \n int x = f(1.13);").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPrimaryStringLiteral() throws Exception {
        Iterator iterator = this.parse("int f(char); \n int f(char*); \n int x = f(\"str\");").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPrimaryBooleanLiteral() throws Exception {
        Iterator iterator = this.parse("int f(bool); \n int f(float); \n int x = f(true);").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPrimaryThis() throws Exception {
        Iterator iterator = this.parse("class A{ int m(); }; A a;  \n int f(void); \n int f(A * a); \n int A::m(){ int x = f(this); }").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_2 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTMethod cfr_ignored_3 = (IASTMethod)iterator.next();
        this.callback.getReferences().iterator();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPrimaryBracketedExpression() throws Exception {
        Iterator iterator = this.parse("int f(int, int); \n int f(int); \n int x = f(1, (2+3));").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testIdExpression() throws Exception {
        Iterator iterator = this.parse("class A{}a;  \n int f(A a); \n int f(void); \n int x = f(a);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testIdExpressionToPointer() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A * pa; \n int f(A *ia){} \n int f(void); \n int x = f(pa);").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testPostfixSubscript() throws Exception {
        Iterator iterator = this.parse("int pa[10]; \n int f(int ia){} \n int f(void); \n int x = f(pa[1]);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testPostfixSubscriptA() throws Exception {
        Iterator iterator = this.parse("int pa[10][5] ; \n int f(int ia){} \n int f(void); \n int x = f(pa[1][2]);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testPostfixSubscriptB() throws Exception {
        Iterator iterator = this.parse("int* pa[10][5] ; \n int f(int* ia){} \n int f(void); \n int x = f(pa[1][2]);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testPostfixSubscriptWithReferences() throws Exception {
        Iterator iterator = this.parse("class A{}; \n A *pa[10][5] ; \n int f(A* ia){} \n int f(void); \n int x = f(pa[1][2]);").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixFunctioncallBug42822() throws Exception {
        Iterator iterator = this.parse("int foo( float b );  int bar( int a, int b ); int test( void ) { int x = bar( foo( 3.0 ), foo( 5.0 ) ) ; }").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 2)));
    }

    public void testPostfixSimpletypesBug42823() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( int anInt, short aShort, double aDouble, float aFloat, char aChar, wchar_t aWchar, signed aSigned, unsigned anUnsigned, bool aBool, long aLong );");
        stringBuffer.append("void test( void ) { int someInt = foo( int(3), short(4), double(3.0), float(4.0), char( 'a'), wchar_t( 'a' ), signed( 2 ), unsigned( 3 ), bool( false ), long( 3L ) ); }");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixTypenameIdentifier() throws Exception {
        Iterator iterator = this.parse("class A {}; \n int foo(); int foo( A a ); \n int x = foo( typename A() );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixDotExpression() throws Exception {
        Iterator iterator = this.parse("class A {int m;}; \n A  a; \n int foo(char); int foo( int ); \n int x = foo( a.m );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixArrowExpression() throws Exception {
        Iterator iterator = this.parse("class A {int m;}; \n A * a; \n int foo(char); int foo( int ); \n int x = foo( a->m );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixIncrement() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); void test( void ) { int x = 5; int y = foo( x++ ); } ").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixDecrement() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); void test( void ) { int x = 5; int y = foo( x-- ); } ").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixDynamicCast() throws Exception {
        Iterator iterator = this.parse("class A {}; class B : public A{}; \n A *a; \n int foo(); int foo( B* ); \n int x = foo( dynamic_cast<B*>(a) );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(6, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixReinterpretCast() throws Exception {
        Iterator iterator = this.parse("int *a; \n int foo(); int foo( double* ); \n int x = foo( reinterpret_cast<double*>(a) );").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixStaticCast() throws Exception {
        Iterator iterator = this.parse("int a; \n int foo(); int foo( char ); \n int x = foo( static_cast<char>(a) );").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixConstCast() throws Exception {
        Iterator iterator = this.parse("const int a; \n int foo(); int foo( int * ); \n int x = foo( const_cast<int *>(&a) );").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixTypeIdExpression() throws Exception {
        Iterator iterator = this.parse("int foo(char); int foo( int ); \n int x = foo( typeid(5) );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixTypeIdExpression2() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A  a; \n int foo(A); int foo( int ); \n int x = foo( typeid(a) );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixTypeIdTypeId() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A  a; \n int foo(A); int foo( int ); \n int x = foo( typeid(A) );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixTypeIdTypeId2() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A  a; \n int foo(A); int foo( int ); \n int x = foo( typeid(const A) );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testUnaryIncrement() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); void test( void ) { int x = 5; int y = foo( ++x ); } ").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testUnaryDecrement() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); void test( void ) { int x = 5; int y = foo( --x ); } ").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testUnaryStarCastExpression() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A * pa; \n int f(A ia){} \n int f(void); \n int x = f(*pa);").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testUnaryAmpersandCastExpression() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A * pa; \n int f(A ** ia){} \n int f(void); \n int x = f(&pa);").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testUnaryPlusCastExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = foo( +5 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testUnaryMinusCastExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = foo( -5 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testUnaryNotCastExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); bool b=true; int x = foo( !b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testTildeNotCastExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = 5; int y = foo( ~x );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testUnarySizeofUnaryExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = 5; int y = foo( sizeof(5) );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testUnarySizeofTypeId() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = 5; int y = foo( sizeof(x) );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testNewTypeId() throws Exception {
        Iterator iterator = this.parse("class A{}; void foo(); int foo( A * a ); int x = foo( new A() );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testCastExpression() throws Exception {
        Iterator iterator = this.parse("class A {}; class B : public A{}; \n B *b; \n int foo(); int foo( A* ); \n int x = foo( (A*)b );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(6, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2, 1), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testMultiplicativeMultiply() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( a * b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testMultiplicativeDivide() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( b / a );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testMultiplicativeModulus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( b % a );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAdditivePlus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( b + a );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAdditiveMinus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( b - a );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testShiftLeft() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a << 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testShiftRight() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a >> 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testRelationalLessThan() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b < 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testRelationalGreaterThan() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b > 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testRelationalLessThanOrEqual() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b <= 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testRelationalGreaterThanOrEqual() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b >= 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testEqualityEquals() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b == 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testEqualityNotEquals() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b != 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAndExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( int ); int a = 3; int b= 5; int x = foo( a & b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testExclusiveOrExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( int ); int a = 3; int b= 5; int x = foo( a ^ b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testInclusiveOrExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( int ); int a = 3; int b= 5; int x = foo( a | b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testLogicalAndExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( bool ); bool a = true; bool b= false; int x = foo( a && b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testLogicalOrExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( bool ); bool a = true; bool b= false; int x = foo( a || b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testConditionalExpression() throws Exception {
        Iterator iterator = this.parse("int foo(bool); int foo(int); int a = 10, b = 4, c = 2; int x = foo( a > 5 ? b : c );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testConditionalExpressionWithReferencesA() throws Exception {
        Iterator iterator = this.parse("class A{}; class B : public A{}; int foo(); int foo(A*); A *a ; B *b; int c = 0; int x = foo( c > 5 ? b : a );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(8, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testConditionalExpressionWithReferencesB_Bug43106() throws Exception {
        Iterator iterator = this.parse("class A{}; class B : public A{}; int foo(); int foo(A&); A a ; B b; int c = 0; int x = foo( c > 5 ? b : a );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(8, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionNormal() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a = 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionPlus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a += 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionMinus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a -= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionMulti() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a *= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionDiv() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a /= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionMod() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a %= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionLShift() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a >>= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionRShift() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a <<= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionAnd() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a &= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionOr() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a |= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testAssignmentExpressionXOr() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a ^= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }
}

