/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class CompleteParseASTTest
extends CompleteParseBaseTest {
    public CompleteParseASTTest(String string) {
        super(string);
    }

    public void testEmptyCompilationUnit() throws Exception {
        IASTScope iASTScope = this.parse("// no real code ");
        Assert.assertNotNull((Object)iASTScope);
        Assert.assertFalse((boolean)iASTScope.getDeclarations().hasNext());
    }

    public void testSimpleNamespace() throws Exception {
        Iterator iterator = this.parse("namespace A { }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        Assert.assertFalse((boolean)this.getDeclarations((IASTScope)iASTNamespaceDefinition).hasNext());
    }

    public void testMultipleNamespaceDefinitions() throws Exception {
        Iterator iterator = this.parse("namespace A { } namespace A { }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        Assert.assertFalse((boolean)this.getDeclarations((IASTScope)iASTNamespaceDefinition).hasNext());
    }

    public void testNestedNamespaceDefinitions() throws Exception {
        Iterator iterator = this.parse("namespace A { namespace B { } }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTNamespaceDefinition iASTNamespaceDefinition2 = (IASTNamespaceDefinition)iterator2.next();
        Assert.assertEquals((String)iASTNamespaceDefinition2.getName(), (String)"B");
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testEmptyClassDeclaration() throws Exception {
        Iterator iterator = this.parse("class A { };").getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"A");
        Assert.assertFalse((boolean)this.getDeclarations((IASTScope)iASTClassSpecifier).hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleSubclass() throws Exception {
        Iterator iterator = this.parse("class A { };  class B : public A { };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = iASTClassSpecifier2.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
        Assert.assertEquals((Object)iASTClassSpecifier, (Object)iASTBaseSpecifier.getParentClassSpecifier());
        Assert.assertEquals((String)iASTBaseSpecifier.getParentClassName(), (String)"A");
        Assert.assertEquals((Object)iASTBaseSpecifier.getAccess(), (Object)ASTAccessVisibility.PUBLIC);
        Assert.assertFalse((boolean)iASTBaseSpecifier.isVirtual());
    }

    public void testNestedSubclass() throws Exception {
        Iterator iterator = this.parse("namespace N { class A { }; } class B : protected virtual N::A { };").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = iASTClassSpecifier2.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
        Assert.assertEquals((Object)iASTClassSpecifier, (Object)iASTBaseSpecifier.getParentClassSpecifier());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testSimpleVariable() throws Exception {
        Iterator iterator = this.parse("int x;").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
    }

    public void testSimpleClassReferenceVariable() throws Exception {
        Iterator iterator = this.parse("class A { }; A x;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
    }

    public void testNestedClassReferenceVariable() throws Exception {
        Iterator iterator = this.parse("namespace N { class A { }; } N::A x;").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testMultipleDeclaratorsVariable() throws Exception {
        Iterator iterator = this.parse("class A { }; A x, y, z;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
        Iterator iterator2 = this.callback.getReferences().iterator();
        while (iterator2.hasNext()) {
            Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTClassSpecifier);
        }
    }

    public void testSimpleField() throws Exception {
        Iterator iterator = this.parse("class A { double x; };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        Assert.assertEquals((String)iASTField.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.DOUBLE);
    }

    public void testUsingClauses() throws Exception {
        Iterator iterator = this.parse("namespace A { namespace B { int x;  class C { static int y = 5; }; } } \n using namespace A::B;\n using A::B::x;using A::B::C;using A::B::C::y;").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTNamespaceDefinition iASTNamespaceDefinition2 = (IASTNamespaceDefinition)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        IASTField iASTField = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        this.assertQualifiedName(iASTField.getFullyQualifiedName(), new String[]{"A", "B", "C", "y"});
        IASTUsingDirective iASTUsingDirective = (IASTUsingDirective)iterator.next();
        Assert.assertEquals((Object)iASTUsingDirective.getNamespaceDefinition(), (Object)iASTNamespaceDefinition2);
        Assert.assertEquals((String)iASTUsingDirective.getNamespaceName(), (String)"A::B");
        IASTUsingDeclaration iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals(iASTUsingDeclaration.getUsingTypes().next(), (Object)iASTVariable);
        iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals(iASTUsingDeclaration.getUsingTypes().next(), (Object)iASTClassSpecifier);
        iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals(iASTUsingDeclaration.getUsingTypes().next(), (Object)iASTField);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)12);
    }

    public void testEnumerations() throws Exception {
        Iterator iterator = this.parse("namespace A { enum E { e1, e2, e3 }; E varE;}").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTEnumerationSpecifier.getName(), (String)"E");
        this.assertQualifiedName(iASTEnumerationSpecifier.getFullyQualifiedName(), new String[]{"A", "E"});
        Iterator iterator3 = iASTEnumerationSpecifier.getEnumerators();
        IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator3.next();
        IASTEnumerator iASTEnumerator2 = (IASTEnumerator)iterator3.next();
        IASTEnumerator iASTEnumerator3 = (IASTEnumerator)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertEquals((String)iASTEnumerator.getName(), (String)"e1");
        Assert.assertEquals((String)iASTEnumerator2.getName(), (String)"e2");
        Assert.assertEquals((String)iASTEnumerator3.getName(), (String)"e3");
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTEnumerationSpecifier);
    }

    public void testSimpleFunction() throws Exception {
        Iterator iterator = this.parse("void foo( void );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"foo");
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)0);
    }

    public void testSimpleFunctionWithTypes() throws Exception {
        Iterator iterator = this.parse("class A { public: \n class B { }; }; const A::B &  foo( A * myParam );").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
    }

    public void testSimpleMethod() throws Exception {
        Iterator iterator = this.parse("class A { void foo(); };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"foo");
    }

    public void testSimpleMethodWithTypes() throws Exception {
        Iterator iterator = this.parse("class U { }; class A { U foo( U areDumb ); };").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"foo");
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testUsingDeclarationWithFunctionsAndMethods() throws Exception {
        Iterator iterator = this.parse("namespace N { int foo(void); } class A { static int bar(void); }; using N::foo; using ::A::bar;").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTUsingDeclaration cfr_ignored_0 = (IASTUsingDeclaration)iterator.next();
        IASTUsingDeclaration cfr_ignored_1 = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)4);
        Iterator iterator2 = this.callback.getReferences().iterator();
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTNamespaceDefinition);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTFunction);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTClassSpecifier);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTMethod);
    }

    public void testLinkageSpec() throws Exception {
        IASTLinkageSpecification iASTLinkageSpecification = (IASTLinkageSpecification)this.parse("extern \"C\" { int foo(); }").getDeclarations().next();
        Iterator iterator = this.getDeclarations((IASTScope)iASTLinkageSpecification);
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"foo");
    }

    public void testBogdansExample() throws Exception {
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)this.parse("namespace A { namespace B {\tenum e1{e_1,e_2};\tint x;\tclass C\t{\tstatic int y = 5;\t}; }} ").getDeclarations().next();
        IASTNamespaceDefinition iASTNamespaceDefinition2 = (IASTNamespaceDefinition)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next();
        Iterator iterator = this.getDeclarations((IASTScope)iASTNamespaceDefinition2);
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = iASTEnumerationSpecifier.getEnumerators();
        IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator2.next();
        Assert.assertEquals((Object)iASTEnumerator.getOwnerEnumerationSpecifier(), (Object)iASTEnumerationSpecifier);
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTClassSpecifier cfr_ignored_1 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
    }

    public void testAndrewsExample() throws Exception {
        Iterator iterator = this.parse("namespace N{ class A {}; }\tusing namespace N;\tclass B: public A{};").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next()).getTypeSpecifier();
        IASTUsingDirective cfr_ignored_0 = (IASTUsingDirective)iterator.next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iASTClassSpecifier2.getBaseClauses().next();
        Assert.assertEquals((Object)iASTBaseSpecifier.getParentClassSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testSimpleTypedef() throws Exception {
        Iterator iterator = this.parse("typedef int myInt;\n myInt var;").getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"myInt");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"var");
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testComplexTypedef() throws Exception {
        Iterator iterator = this.parse("class A{ }; typedef A ** A_DOUBLEPTR;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    protected void assertQualifiedName(String[] stringArray, String[] stringArray2) {
        Assert.assertNotNull((Object)stringArray);
        Assert.assertNotNull((Object)stringArray2);
        Assert.assertEquals((int)stringArray.length, (int)stringArray2.length);
        int n = 0;
        while (n < stringArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)stringArray2[n]);
            ++n;
        }
    }

    public void testBug40842() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {} a;\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)0);
    }

    public void testNestedClassname() throws Exception {
        Iterator iterator = this.parse("namespace A { } \n class A::B { };").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((Object)iASTClassSpecifier.getOwnerScope(), (Object)iASTNamespaceDefinition);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testForwardDeclaration() throws Exception {
        Iterator iterator = this.parse("class forward;").getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"forward");
        Assert.assertEquals((Object)iASTElaboratedTypeSpecifier.getClassKind(), (Object)ASTClassKind.CLASS);
    }

    public void testElaboratedType() throws Exception {
        Iterator iterator = this.parse("class A; class A * a;").getDeclarations();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"A");
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"a");
        Assert.assertEquals((Object)iASTVariable.getAbstractDeclaration().getTypeSpecifier(), (Object)iASTElaboratedTypeSpecifier);
    }

    public void testForewardDeclarationWithUsage() throws Exception {
        Iterator iterator = this.parse("class A; A * anA;class A { };").getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration2 = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration2.getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)iASTClassSpecifier.getName());
        String[] stringArray = iASTClassSpecifier.getFullyQualifiedName();
        String[] stringArray2 = iASTElaboratedTypeSpecifier.getFullyQualifiedName();
        Assert.assertEquals((int)stringArray.length, (int)stringArray2.length);
        int n = 0;
        while (n < stringArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)stringArray2[n]);
            ++n;
        }
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        Assert.assertEquals((int)this.callback.getForewardDecls().size(), (int)1);
        IASTClassReference iASTClassReference = (IASTClassReference)this.callback.getReferences().get(0);
        Assert.assertTrue((boolean)(iASTClassReference.getReferencedElement() instanceof IASTElaboratedTypeSpecifier));
        Assert.assertEquals((Object)iASTClassReference.getReferencedElement(), (Object)iASTElaboratedTypeSpecifier);
    }

    public void testASM() throws Exception {
        IASTASMDefinition iASTASMDefinition = (IASTASMDefinition)this.parse("asm ( \"blah blah blah\" );").getDeclarations().next();
        Assert.assertEquals((String)iASTASMDefinition.getBody(), (String)"blah blah blah");
    }

    public void testOverride() throws Exception {
        Iterator iterator = this.parse("void foo();\n void foo( int );\n").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleExpression() throws Exception {
        Iterator iterator = this.parse("int x; int y = x;").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testParameterExpressions() throws Exception {
        Iterator iterator = this.parse("int x = 5; void foo( int sub = x ) { }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testNestedNamespaceExpression() throws Exception {
        Iterator iterator = this.parse("namespace A { int x = 666; } int y  = A::x;").getDeclarations();
        IASTNamespaceDefinition cfr_ignored_0 = (IASTNamespaceDefinition)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testConstructorChain() throws Exception {
        Iterator iterator = this.parse("int x = 5;\n class A \n{ public : \n int a; \n A() : a( x ) { } };").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
        IASTFieldReference iASTFieldReference = (IASTFieldReference)this.callback.getReferences().get(0);
        IASTVariableReference iASTVariableReference = (IASTVariableReference)this.callback.getReferences().get(1);
        Assert.assertEquals((Object)iASTFieldReference.getReferencedElement(), (Object)iASTField);
        Assert.assertEquals((Object)iASTVariableReference.getReferencedElement(), (Object)iASTVariable);
    }

    public void testArrayModExpression() throws Exception {
        Iterator iterator = this.parse("const int x = 5; int y [ x ]; ").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testPointerVariable() throws Exception {
        Iterator iterator = this.parse("class A { }; A * anA;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        IASTClassReference iASTClassReference = (IASTClassReference)this.callback.getReferences().get(0);
        Assert.assertEquals((Object)iASTClassReference.getReferencedElement(), (Object)iASTClassSpecifier);
    }

    public void testExceptionSpecification() throws Exception {
        Iterator iterator = this.parse("class A { }; void foo( void ) throw ( A );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        IASTClassReference iASTClassReference = (IASTClassReference)this.callback.getReferences().get(0);
        Assert.assertEquals((Object)iASTClassReference.getReferencedElement(), (Object)iASTClassSpecifier);
    }

    public void testNewExpressions() throws Exception {
        Iterator iterator = this.parse("int A; int B; int C; int D; int P; int*p = new  (P) (A)[B][C][D];").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable4 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable5 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)5);
        Iterator iterator2 = this.callback.getReferences().iterator();
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable5);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable2);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable3);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable4);
    }

    public void testBug41520() throws Exception {
        Iterator iterator = this.parse("const int x = 666; const int y( x );").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testNewXReferences() throws Exception {
        Iterator iterator = this.parse("const int max = 5;\n int * x = new int[max];").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        IASTVariableReference iASTVariableReference = (IASTVariableReference)this.callback.getReferences().get(0);
        Assert.assertEquals((Object)iASTVariableReference.getReferencedElement(), (Object)iASTVariable);
    }

    public void testQualifiedNameReferences() throws Exception {
        try {
            Iterator iterator = this.parse("class A{ class B{ class C { public: int cMethod(); }; }; }; \n  int A::B::C::cMethod() {}; \n").getDeclarations();
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
            IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
            Iterator iterator3 = this.getDeclarations((IASTScope)iASTClassSpecifier2);
            IASTClassSpecifier iASTClassSpecifier3 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator3.next()).getTypeSpecifier();
            IASTMethod cfr_ignored_0 = (IASTMethod)iterator.next();
            Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
            Iterator iterator4 = this.callback.getReferences().iterator();
            Assert.assertEquals((Object)((IASTClassReference)iterator4.next()).getReferencedElement(), (Object)iASTClassSpecifier);
            Assert.assertEquals((Object)((IASTClassReference)iterator4.next()).getReferencedElement(), (Object)iASTClassSpecifier2);
            Assert.assertEquals((Object)((IASTClassReference)iterator4.next()).getReferencedElement(), (Object)iASTClassSpecifier3);
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    public void testIsConstructor() throws Exception {
        Iterator iterator = this.parse("class A{ public: A(); }; \n  A::A() {}; \n").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
    }

    public void testIsDestructor() throws Exception {
        Iterator iterator = this.parse("class A{ public: ~A(); }; \n  A::~A() {}; \n").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertTrue((boolean)iASTMethod.isDestructor());
    }

    public void testBug41445() throws Exception {
        Iterator iterator = this.parse("class A { }; namespace N { class B : public A { struct A {}; }; }").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        IASTClassSpecifier cfr_ignored_1 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)this.getDeclarations((IASTScope)iASTClassSpecifier).next()).getTypeSpecifier();
    }

    public void testSimpleFunctionBody() throws Exception {
        Iterator iterator = this.parse("class A { int f1(); }; const int x = 4; int f() { return x; } int A::f1() { return x; }").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        Assert.assertEquals((String)iASTMethod2.getName(), (String)iASTMethod.getName());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
        IASTVariableReference iASTVariableReference = (IASTVariableReference)this.callback.getReferences().get(0);
        Assert.assertEquals((Object)iASTVariableReference.getReferencedElement(), (Object)iASTVariable);
        IASTClassReference iASTClassReference = (IASTClassReference)this.callback.getReferences().get(1);
        Assert.assertEquals((Object)iASTClassReference.getReferencedElement(), (Object)iASTClassSpecifier);
        iASTVariableReference = (IASTVariableReference)this.callback.getReferences().get(2);
        Assert.assertEquals((Object)iASTVariableReference.getReferencedElement(), (Object)iASTVariable);
    }

    public void testSimpleForLoop() throws Exception {
        Iterator iterator = this.parse("const int FIVE = 5;  void f() {  int x = 0; for( int i = 0; i < FIVE; ++i ) { x += i; }  }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)5);
        iterator = this.parse("const int FIVE = 5;  void f() {  int x = 0; for( int i = 0; i < FIVE; ++i )  x += i;  }").getDeclarations();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_3 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)5);
        iterator = this.parse("class A { }; void f() {  for( int i = 0; i < (A*)0; ++i ) { A anA; } }").getDeclarations();
        IASTClassSpecifier cfr_ignored_4 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_5 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)4);
    }

    public void testBug42541() throws Exception {
        Iterator iterator = this.parse("union{ int v; char a; } id;").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField cfr_ignored_0 = (IASTField)iterator2.next();
        IASTField cfr_ignored_1 = (IASTField)iterator2.next();
    }

    public void testSimpleIfStatement() throws Exception {
        Iterator iterator = this.parse("const bool T = true; int foo() { if( T ) { return 5; } else if( ! T ) return 20; else { return 10; } }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testSimpleWhileStatement() throws Exception {
        Iterator iterator = this.parse("const bool T = true; void foo() { int x = 0; while( T ) {  ++x;  if( x == 100 ) break; } }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
    }

    public void testSimpleSwitchStatement() throws Exception {
        Iterator iterator = this.parse("const int x = 5; const int y = 10; void foo() { switch( x ) { case 1: break; case 2: goto blah; case y: continue; default: break;} }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_2 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testSimpleDoStatement() throws Exception {
        Iterator iterator = this.parse("const int x = 3; int counter = 0; void foo() { do { ++counter; } while( counter != x ); } ").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_2 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
    }

    public void testThrowStatement() throws Exception {
        Iterator iterator = this.parse("class A { }; void foo() throw ( A ) { throw A; throw; } ").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
        int n = 0;
        while (n < 2) {
            Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(n)).getReferencedElement(), (Object)iASTClassSpecifier);
            ++n;
        }
    }

    public void testScoping() throws Exception {
        Iterator iterator = this.parse("void foo() { int x = 3; if( x == 1 ) { int x = 4; } else int x = 2; }").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        Assert.assertEquals((String)iASTVariable.getInitializerClause().getAssigmentExpression().getLiteralString(), (String)"3");
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(0)).getReferencedElement(), (Object)iASTVariable);
        Iterator iterator3 = this.getNestedScopes((IASTCodeScope)iASTFunction);
        IASTCodeScope iASTCodeScope = (IASTCodeScope)iterator3.next();
        Iterator iterator4 = this.getDeclarations((IASTScope)iASTCodeScope);
        IASTVariable iASTVariable2 = (IASTVariable)iterator4.next();
        Assert.assertEquals((String)iASTVariable2.getInitializerClause().getAssigmentExpression().getLiteralString(), (String)"4");
        iASTCodeScope = (IASTCodeScope)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        iterator4 = this.getDeclarations((IASTScope)iASTCodeScope);
        IASTVariable iASTVariable3 = (IASTVariable)iterator4.next();
        Assert.assertEquals((String)iASTVariable3.getInitializerClause().getAssigmentExpression().getLiteralString(), (String)"2");
    }

    public void testEnumeratorReferences() throws Exception {
        Iterator iterator = this.parse("enum E { e1, e2, e3 }; E anE = e1;").getDeclarations();
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTEnumerator iASTEnumerator = (IASTEnumerator)iASTEnumerationSpecifier.getEnumerators().next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
        Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(0)).getReferencedElement(), (Object)iASTEnumerationSpecifier);
        Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(1)).getReferencedElement(), (Object)iASTEnumerator);
    }

    public void testBug42840() throws Exception {
        Iterator iterator = this.parse("void foo(); void foo() { } class SearchMe { };").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)this.callback.getReferences().isEmpty());
        iterator = this.parse("class A { void f ( A );\t};\tvoid A::f( A ){ return; }").getDeclarations();
        iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod cfr_ignored_2 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_3 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.callback.getReferences().iterator();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
        int n = 0;
        while (n < 3) {
            Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(n)).getReferencedElement(), (Object)iASTClassSpecifier);
            ++n;
        }
    }

    public void testBug42872() throws Exception {
        Iterator iterator = this.parse("struct B {}; struct D : B {}; void foo(D* dp) { B* bp = dynamic_cast<B*>(dp); }").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier cfr_ignored_1 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction).next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug43503A() throws Exception {
        Iterator iterator = this.parse("class SD_01 { void f_SD_01() {}}; int main(){ SD_01 * a = new SD_01(); a->f_SD_01();\t} ").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator3 = this.getDeclarations((IASTScope)iASTFunction);
        Assert.assertTrue((boolean)iterator3.hasNext());
    }

    public void testBug42979() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class OperatorOverload{\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("  bool operator==( const class OperatorOverload& that )\n");
        ((Writer)stringWriter).write("  { return true; }\n");
        ((Writer)stringWriter).write("  bool operator!=( const class OperatorOverload& that );\n");
        ((Writer)stringWriter).write("}; \n");
        ((Writer)stringWriter).write("bool OperatorOverload::operator!=( const class OperatorOverload& that )\n");
        ((Writer)stringWriter).write("{ return false; }\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        Assert.assertEquals((String)iASTMethod2.getName(), (String)iASTMethod.getName());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)4);
        int n = 0;
        while (n < 4) {
            Assert.assertFalse((iASTClassSpecifier.getNameOffset() == ((IASTReference)this.callback.getReferences().get(n)).getOffset() ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testBug43373() throws Exception {
        try {
            Iterator iterator = this.parse("class A { static int x; }; int A::x = 5;").getDeclarations();
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
            IASTField iASTField = (IASTField)iterator2.next();
            IASTField iASTField2 = (IASTField)iterator.next();
            Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
            Iterator iterator3 = this.callback.getReferences().iterator();
            Assert.assertEquals((Object)((IASTReference)iterator3.next()).getReferencedElement(), (Object)iASTClassSpecifier);
            Assert.assertTrue((iASTField.getVisiblity() == iASTField2.getVisiblity() ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    public void testBug39504() throws Exception {
        Iterator iterator = this.parse("const int w = 2; int x[ 5 ]; int y = sizeof (x[w]);").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testBug43375() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("extern int x;").getDeclarations().next();
        Assert.assertTrue((boolean)iASTVariable.isExtern());
    }

    public void testBug43503() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class SD_02 {");
        stringBuffer.append("\tpublic:");
        stringBuffer.append(" void f_SD_02();");
        stringBuffer.append(" };");
        stringBuffer.append("class SD_01 {\n");
        stringBuffer.append("\tpublic:\n");
        stringBuffer.append("\t\tSD_02 *next;");
        stringBuffer.append("\t\tvoid f_SD_01();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int main(){\n");
        stringBuffer.append("\tSD_01 a = new SD_01();\n");
        stringBuffer.append("\ta->f_SD_01();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void SD_01::f_SD_01()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("   next->f_SD_02();\n");
        stringBuffer.append("}\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTField iASTField = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier2).next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction).next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(8, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField)));
    }

    public void testBug43679_A() throws Exception {
        try {
            Iterator iterator = this.parse("struct Sample { int size() const; }; extern const Sample * getSample(); int trouble() {  return getSample()->size(); } ", false).getDeclarations();
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
            IASTMethod iASTMethod = (IASTMethod)iterator2.next();
            Assert.assertFalse((boolean)iterator2.hasNext());
            IASTFunction iASTFunction = (IASTFunction)iterator.next();
            IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            this.callback.getReferences().iterator();
            this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    public void testBug43679_B() throws Exception {
        try {
            Iterator iterator = this.parse("struct Sample{int size() const; }; struct Sample; ", false).getDeclarations();
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
            IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
            Assert.assertFalse((boolean)iterator2.hasNext());
            IASTAbstractTypeSpecifierDeclaration cfr_ignored_1 = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            Iterator iterator3 = this.callback.getReferences().iterator();
            Assert.assertFalse((boolean)iterator3.hasNext());
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    public void testBug43951() throws Exception {
        Iterator iterator = this.parse("class B{ B(); ~B(); }; B::B(){} B::~B(){}", false).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"B");
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"B");
        Assert.assertTrue((boolean)iASTMethod.previouslyDeclared());
    }

    public void testBug44342() throws Exception {
        try {
            IASTScope iASTScope = this.parse("class A { void f(){} void f(int){} }; int main(){ A * a = new A(); a->f();} ");
            Iterator iterator = iASTScope.getDeclarations();
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
            IASTMethod iASTMethod = (IASTMethod)iterator2.next();
            IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
            Assert.assertFalse((boolean)iterator2.hasNext());
            IASTFunction iASTFunction = (IASTFunction)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            Iterator iterator3 = this.getDeclarations((IASTScope)iASTFunction);
            Assert.assertTrue((boolean)iterator3.hasNext());
            IASTVariable iASTVariable = (IASTVariable)iterator3.next();
            this.callback.getReferences().iterator();
            this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod)));
        }
        catch (ParserException parserException) {
            Assert.fail();
        }
    }

    public void testCDesignatedInitializers() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct Inner { int a,b,c; };");
        stringBuffer.append("struct A { int x; int y[]; struct Inner innerArray[]; int z []; };");
        stringBuffer.append("struct A myA = { .x = 4, .y[3] = 4, .y[4] = 3, .innerArray[0].a = 3, .innerArray[1].b = 5, .innerArray[2].c=6, .z = { 1,4,5} };");
        Iterator iterator = this.parse(stringBuffer.toString(), true, ParserLanguage.C).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        IASTField iASTField2 = (IASTField)iterator2.next();
        IASTField iASTField3 = (IASTField)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier2);
        IASTField iASTField4 = (IASTField)iterator2.next();
        IASTField iASTField5 = (IASTField)iterator2.next();
        IASTField iASTField6 = (IASTField)iterator2.next();
        IASTField iASTField7 = (IASTField)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(12, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField4), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField5, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField6, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField7)));
    }

    public void testBug39551A() throws Exception {
        IASTFunction iASTFunction = (IASTFunction)this.parse("extern float _Complex conjf (float _Complex);", true, ParserLanguage.C).getDeclarations().next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"conjf");
        Assert.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).isComplex());
    }

    public void testBug39551B() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("_Imaginary double id = 99.99 * __I__;", true, ParserLanguage.C).getDeclarations().next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"id");
        Assert.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).isImaginary());
    }

    public void testCBool() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("_Bool x;", true, ParserLanguage.C).getDeclarations().next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type._BOOL);
    }

    public void testCBoolAsParameter() throws Exception {
        Iterator iterator = this.parse("void f( _Bool b ) {} _Bool g( _Bool b ) {} void main(){   _Bool b;     f(b);\tf( g( (_Bool) 1 )  );}", true, ParserLanguage.C).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction3).next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2)));
    }

    public void testBug44510() throws Exception {
        Iterator iterator = this.parse("int initialize(); int initialize( char ){} int initialize(){ return 1; } void main(){ int i = initialize(); }").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((boolean)iASTFunction.previouslyDeclared(), (boolean)false);
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((boolean)iASTFunction2.previouslyDeclared(), (boolean)false);
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertEquals((boolean)iASTFunction3.previouslyDeclared(), (boolean)true);
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction3)));
    }

    public void testBug44925() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class MyClass { };");
        stringBuffer.append("class MyClass myObj1;");
        stringBuffer.append("enum MyEnum { Item1 };");
        stringBuffer.append("enum MyEnum myObj2;");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTEnumerationSpecifier)));
    }

    public void testBug44838() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { int myX; A( int x ); };\n");
        stringBuffer.append("A::A( int x ) : myX( x ) { if( x == 5 ) myX++; }\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTField cfr_ignored_0 = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTParameterDeclaration cfr_ignored_1 = (IASTParameterDeclaration)iASTMethod.getParameters().next();
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug46165() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { int myX; A( int x ); };\n");
        stringBuffer.append("A::A( int x ) : myX( x ) { if( x == 5 ) myX++; }\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTField iASTField = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iASTMethod.getParameters().next();
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTParameterDeclaration)));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug47624() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { }; \n");
        stringBuffer.append("void f ( int s ) { \n");
        stringBuffer.append("   struct s sInstance; \n");
        stringBuffer.append("}\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTElaboratedTypeSpecifier cfr_ignored_0 = (IASTElaboratedTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier)));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testQualifiedLookup() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {");
        stringBuffer.append("   void f () {} \n");
        stringBuffer.append("   class A { }; \n");
        stringBuffer.append("}");
        stringBuffer.append("void main() { N::A * a = new N::A();  a->f(); } ");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator2.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Iterator iterator3 = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator3.next();
        this.assertAllReferences(5, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTNamespaceDefinition, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testBug43110() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void x( int y, ... );\n");
        stringBuffer.append("void y( int x... );\n");
        stringBuffer.append("void z(...);");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)((IASTFunction)iterator.next()).takesVarArgs());
        }
    }

    public void testBug43110_XRef() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( ... ) {}\n");
        stringBuffer.append("void main( ){ foo( 1 ); }\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTFunction.takesVarArgs());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( ... )   {}\n");
        stringBuffer.append("void foo( int x ) {}\n");
        stringBuffer.append("void main( ){ foo( 1 ); }\n");
        iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTFunction2.takesVarArgs());
        Assert.assertFalse((boolean)iASTFunction3.takesVarArgs());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction3)));
        stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( ... )      {}\n");
        stringBuffer.append("void foo( int x = 1) {}\n");
        stringBuffer.append("void main( ){ foo(); }\n");
        iterator = this.parse(stringBuffer.toString()).getDeclarations();
        iASTFunction2 = (IASTFunction)iterator.next();
        iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTFunction2.takesVarArgs());
        Assert.assertFalse((boolean)iASTFunction3.takesVarArgs());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction3)));
        stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( int x ... ) {}\n");
        stringBuffer.append("void main( ){ foo( 1, 2, 'a' ); }\n");
        iterator = this.parse(stringBuffer.toString()).getDeclarations();
        iASTFunction = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTFunction.takesVarArgs());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testErrorHandling_1() throws Exception {
        Iterator iterator = this.parse("A anA; int x = c; class A {}; A * anotherA = &anA; int b;", false).getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"A");
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable2.getName(), (String)"b");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug44340() throws Exception {
        IASTScope iASTScope = this.parse("class A{ int getX() {return x[1];} int x[10];};", false);
        Iterator iterator = iASTScope.getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        IASTField iASTField = (IASTField)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField)));
    }

    public void testBug47628() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void h(char) { }\n");
        ((Writer)stringWriter).write("void h(unsigned char) { }\n");
        ((Writer)stringWriter).write("void h(signed char) { }  // not shown in outline, parsed as char\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"h");
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"char");
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"h");
        iterator2 = iASTFunction2.getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"unsigned char");
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction3.getName(), (String)"h");
        iterator2 = iASTFunction3.getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"signed char");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug47636() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f( char [] ); \n");
        ((Writer)stringWriter).write("void f( char * ){} \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"f");
        Assert.assertTrue((boolean)iASTFunction2.previouslyDeclared());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug45697() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" int f( bool ); \n");
        ((Writer)stringWriter).write(" int f( char ){ } ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"bool");
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"f");
        iterator2 = iASTFunction2.getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"char");
        Assert.assertFalse((boolean)iASTFunction2.previouslyDeclared());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

