/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class CompleteParseBaseTest
extends TestCase {
    protected FullParseCallback callback;

    public CompleteParseBaseTest() {
    }

    public CompleteParseBaseTest(String string) {
        super(string);
    }

    protected Iterator getNestedScopes(IASTCodeScope iASTCodeScope) {
        CodeScope codeScope = this.callback.lookup(iASTCodeScope);
        if (codeScope != null) {
            return codeScope.getCodeBlocks();
        }
        return null;
    }

    protected Iterator getDeclarations(IASTScope iASTScope) {
        Scope scope = this.callback.lookup(iASTScope);
        if (scope != null) {
            return scope.getDeclarations();
        }
        return null;
    }

    protected IASTScope parse(String string) throws ParserException, ParserFactoryError {
        return this.parse(string, true, ParserLanguage.CPP);
    }

    protected IASTScope parse(String string, boolean bl) throws ParserException, ParserFactoryError {
        return this.parse(string, bl, ParserLanguage.CPP);
    }

    protected IASTScope parse(String string, boolean bl, ParserLanguage parserLanguage) throws ParserException, ParserFactoryError {
        this.callback = new FullParseCallback();
        IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((Reader)new StringReader(string), (String)"test-code", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.callback, (IParserLogService)new NullLogService()), (ISourceElementRequestor)this.callback, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, null);
        if (!iParser.parse() && bl) {
            throw new ParserException("FAILURE");
        }
        return this.callback.getCompilationUnit();
    }

    protected void assertReferences(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, int n, boolean bl) {
        HashSet<IASTReference> hashSet = new HashSet<IASTReference>();
        Iterator iterator = this.callback.getReferences().iterator();
        while (iterator.hasNext()) {
            IASTReference iASTReference = (IASTReference)iterator.next();
            if (iASTReference.getReferencedElement() == iSourceElementCallbackDelegate) {
                if (hashSet.add(iASTReference) || bl) continue;
                Assert.fail((String)("Duplicate reference found for ISourceElementCallbackDelegate: " + iSourceElementCallbackDelegate + " @ offset " + iASTReference.getOffset()));
                continue;
            }
            if (!(iASTReference.getReferencedElement() instanceof IASTQualifiedNameElement) || !(iSourceElementCallbackDelegate instanceof IASTQualifiedNameElement) || !this.qualifiedNamesEquals(((IASTQualifiedNameElement)iASTReference.getReferencedElement()).getFullyQualifiedName(), ((IASTQualifiedNameElement)iSourceElementCallbackDelegate).getFullyQualifiedName()) || hashSet.add(iASTReference) || bl) continue;
            Assert.fail((String)("Duplicate reference found for ISourceElementCallbackDelegate: " + iSourceElementCallbackDelegate + " @ offset " + iASTReference.getOffset()));
        }
        Assert.assertEquals((int)n, (int)hashSet.size());
    }

    protected void assertReferenceTask(Task task) {
        this.assertReferences(task.getElement(), task.getCount(), task.isUnique());
    }

    protected void assertAllReferences(int n, List list) {
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)n);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.assertReferenceTask((Task)iterator.next());
        }
    }

    protected List createTaskList(Task task) {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        arrayList.add(task);
        return arrayList;
    }

    protected List createTaskList(Task task, Task task2) {
        List list = this.createTaskList(task);
        list.add(task2);
        return list;
    }

    protected List createTaskList(Task task, Task task2, Task task3) {
        List list = this.createTaskList(task, task2);
        list.add(task3);
        return list;
    }

    protected List createTaskList(Task task, Task task2, Task task3, Task task4) {
        List list = this.createTaskList(task, task2, task3);
        list.add(task4);
        return list;
    }

    protected List createTaskList(Task task, Task task2, Task task3, Task task4, Task task5) {
        List list = this.createTaskList(task, task2, task3, task4);
        list.add(task5);
        return list;
    }

    protected List createTaskList(Task task, Task task2, Task task3, Task task4, Task task5, Task task6) {
        List list = this.createTaskList(task, task2, task3, task4, task5);
        list.add(task6);
        return list;
    }

    protected List createTaskList(Task task, Task task2, Task task3, Task task4, Task task5, Task task6, Task task7) {
        List list = this.createTaskList(task, task2, task3, task4, task5, task6);
        list.add(task7);
        return list;
    }

    protected List createTaskList(Task task, Task task2, Task task3, Task task4, Task task5, Task task6, Task task7, Task task8) {
        List list = this.createTaskList(task, task2, task3, task4, task5, task6, task7);
        list.add(task8);
        return list;
    }

    protected List createTaskList(Task task, Task task2, Task task3, Task task4, Task task5, Task task6, Task task7, Task task8, Task task9) {
        List list = this.createTaskList(task, task2, task3, task4, task5, task6, task7, task8);
        list.add(task9);
        return list;
    }

    public boolean qualifiedNamesEquals(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void assertQualifiedName(String[] stringArray, String[] stringArray2) {
        Assert.assertTrue((boolean)this.qualifiedNamesEquals(stringArray, stringArray2));
    }

    public static class Scope
    implements IASTScope {
        private List decls = new ArrayList();
        private final IASTScope scope;

        public Scope(IASTScope iASTScope) {
            this.scope = iASTScope;
        }

        public void addDeclaration(IASTDeclaration iASTDeclaration) {
            this.decls.add(iASTDeclaration);
        }

        public Iterator getDeclarations() {
            return this.decls.iterator();
        }

        public IASTScope getScope() {
            return this.scope;
        }

        public IASTNode.ILookupResult lookup(String string, IASTNode.LookupKind[] lookupKindArray, IASTNode iASTNode) {
            return null;
        }
    }

    public static class CodeScope
    extends Scope
    implements IASTCodeScope {
        private List nestedScopes = new ArrayList();

        public CodeScope(IASTCodeScope iASTCodeScope) {
            super((IASTScope)iASTCodeScope);
        }

        public IASTCodeScope getOwnerCodeScope() {
            return ((IASTCodeScope)this.getScope()).getOwnerCodeScope();
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
        }

        public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
        }

        public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
        }

        public void addNewScope(IASTCodeScope iASTCodeScope) {
            this.nestedScopes.add(iASTCodeScope);
        }

        public Iterator getCodeBlocks() {
            return this.nestedScopes.iterator();
        }

        public IASTFunction getContainingFunction() {
            return null;
        }
    }

    public static class FullParseCallback
    implements ISourceElementRequestor {
        private List references = new ArrayList();
        private List forewardDecls = new ArrayList();
        private Stack inclusions = new Stack();
        private Scope compilationUnit;
        private Stack scopes = new Stack();
        Hashtable h = new Hashtable();
        List problems = new ArrayList();

        public void finalize() {
        }

        public IASTScope getCompilationUnit() {
            return this.compilationUnit;
        }

        public void acceptVariable(IASTVariable iASTVariable) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTVariable);
        }

        public void acceptFunctionDeclaration(IASTFunction iASTFunction) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTFunction);
        }

        public void acceptUsingDirective(IASTUsingDirective iASTUsingDirective) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTUsingDirective);
        }

        public void acceptUsingDeclaration(IASTUsingDeclaration iASTUsingDeclaration) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTUsingDeclaration);
        }

        public void acceptASMDefinition(IASTASMDefinition iASTASMDefinition) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTASMDefinition);
        }

        public void acceptTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTTypedefDeclaration);
        }

        public void acceptEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        }

        public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTAbstractTypeSpecifierDeclaration);
        }

        public void enterFunctionBody(IASTFunction iASTFunction) {
            this.pushCodeScope((IASTCodeScope)iASTFunction);
        }

        public void exitFunctionBody(IASTFunction iASTFunction) {
            this.popScope();
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTFunction);
        }

        public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
            this.pushScope((IASTScope)iASTCompilationUnit);
        }

        public void enterInclusion(IASTInclusion iASTInclusion) {
            this.pushInclusion(iASTInclusion);
        }

        private void pushInclusion(IASTInclusion iASTInclusion) {
            this.inclusions.push(iASTInclusion);
        }

        public void enterNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
            this.pushScope((IASTScope)iASTNamespaceDefinition);
        }

        public void enterClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
            this.pushScope((IASTScope)iASTClassSpecifier);
        }

        public void enterLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
            this.pushScope((IASTScope)iASTLinkageSpecification);
        }

        public void enterTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
        }

        public void enterTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
        }

        public void enterTemplateInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
        }

        public void acceptMethodDeclaration(IASTMethod iASTMethod) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTMethod);
        }

        public void enterMethodBody(IASTMethod iASTMethod) {
            this.pushCodeScope((IASTCodeScope)iASTMethod);
        }

        public void exitMethodBody(IASTMethod iASTMethod) {
            this.popScope();
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTMethod);
        }

        public void acceptField(IASTField iASTField) {
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTField);
        }

        public void exitTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
        }

        public void exitTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
        }

        public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
        }

        public void exitLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
            this.popScope();
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTLinkageSpecification);
        }

        public void exitClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
            this.popScope();
        }

        public void exitNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
            this.popScope();
            this.getCurrentScope().addDeclaration((IASTDeclaration)iASTNamespaceDefinition);
        }

        public void exitInclusion(IASTInclusion iASTInclusion) {
            this.popInclusion();
        }

        private void popInclusion() {
            this.inclusions.pop();
        }

        public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
            this.compilationUnit = this.popScope();
        }

        protected Scope getCurrentScope() {
            return (Scope)this.scopes.peek();
        }

        protected CodeScope getCurrentCodeScope() {
            return (CodeScope)this.scopes.peek();
        }

        protected Scope popScope() {
            Scope scope = (Scope)this.scopes.pop();
            this.h.put(scope.getScope(), scope);
            return scope;
        }

        protected void pushScope(IASTScope iASTScope) {
            this.scopes.push(new Scope(iASTScope));
        }

        public Scope lookup(IASTScope iASTScope) {
            return (Scope)this.h.get(iASTScope);
        }

        public CodeScope lookup(IASTCodeScope iASTCodeScope) {
            return (CodeScope)this.h.get(iASTCodeScope);
        }

        public Iterator getProblems() {
            return this.problems.iterator();
        }

        public boolean acceptProblem(IProblem iProblem) {
            this.problems.add(iProblem);
            return true;
        }

        public void acceptMacro(IASTMacro iASTMacro) {
        }

        public void acceptClassReference(IASTClassReference iASTClassReference) {
            this.processReference((IASTReference)iASTClassReference);
        }

        public void acceptTypedefReference(IASTTypedefReference iASTTypedefReference) {
            this.processReference((IASTReference)iASTTypedefReference);
        }

        public void acceptNamespaceReference(IASTNamespaceReference iASTNamespaceReference) {
            this.processReference((IASTReference)iASTNamespaceReference);
        }

        public void acceptEnumerationReference(IASTEnumerationReference iASTEnumerationReference) {
            this.processReference((IASTReference)iASTEnumerationReference);
        }

        public void acceptVariableReference(IASTVariableReference iASTVariableReference) {
            this.processReference((IASTReference)iASTVariableReference);
        }

        public void acceptFunctionReference(IASTFunctionReference iASTFunctionReference) {
            this.processReference((IASTReference)iASTFunctionReference);
        }

        protected void processReference(IASTReference iASTReference) {
            this.references.add(iASTReference);
        }

        public void acceptFieldReference(IASTFieldReference iASTFieldReference) {
            this.processReference((IASTReference)iASTFieldReference);
        }

        public void acceptMethodReference(IASTMethodReference iASTMethodReference) {
            this.processReference((IASTReference)iASTMethodReference);
        }

        public List getReferences() {
            return this.references;
        }

        public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
            this.forewardDecls.add(iASTElaboratedTypeSpecifier);
        }

        public List getForewardDecls() {
            return this.forewardDecls;
        }

        public void enterCodeBlock(IASTCodeScope iASTCodeScope) {
            this.pushCodeScope(iASTCodeScope);
        }

        protected void pushCodeScope(IASTCodeScope iASTCodeScope) {
            this.scopes.push(new CodeScope(iASTCodeScope));
        }

        public void exitCodeBlock(IASTCodeScope iASTCodeScope) {
            this.popScope();
            this.getCurrentCodeScope().addNewScope(iASTCodeScope);
        }

        public void acceptEnumeratorReference(IASTEnumeratorReference iASTEnumeratorReference) {
            this.processReference((IASTReference)iASTEnumeratorReference);
        }

        public void acceptParameterReference(IASTParameterReference iASTParameterReference) {
            this.processReference((IASTReference)iASTParameterReference);
        }

        public Reader createReader(String string) {
            return ParserUtil.createReader((String)string);
        }
    }

    protected static class Task {
        private final boolean unique;
        private final int count;
        private final ISourceElementCallbackDelegate element;

        public Task(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, int n, boolean bl) {
            this.element = iSourceElementCallbackDelegate;
            this.count = n;
            this.unique = bl;
        }

        public Task(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, int n) {
            this(iSourceElementCallbackDelegate, n, true);
        }

        public Task(ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            this(iSourceElementCallbackDelegate, 1, false);
        }

        public int getCount() {
            return this.count;
        }

        public ISourceElementCallbackDelegate getElement() {
            return this.element;
        }

        public boolean isUnique() {
            return this.unique;
        }
    }
}

