/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;

public class CompletionParseTest
extends CompleteParseBaseTest {
    public CompletionParseTest(String string) {
        super(string);
    }

    protected IASTCompletionNode parse(String string, int n) throws Exception {
        this.callback = new CompleteParseBaseTest.FullParseCallback();
        IParser iParser = null;
        iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((Reader)new StringReader(string), (String)"completion-test", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.COMPLETION_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)this.callback, (IParserLogService)new NullLogService()), (ISourceElementRequestor)this.callback, (ParserMode)ParserMode.COMPLETION_PARSE, (ParserLanguage)ParserLanguage.CPP, (IParserLogService)ParserUtil.getParserLogService());
        return iParser.parse(n);
    }

    public void testBaseCase_SimpleDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class ABC ");
        stringWriter.write("{int x;}; ");
        stringWriter.write("AB\n\n");
        IASTCompletionNode iASTCompletionNode = null;
        Iterator iterator = null;
        iASTCompletionNode = this.parse(stringWriter.toString(), 21);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionPrefix());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionScope(), (Object)((CompleteParseBaseTest.Scope)this.callback.getCompilationUnit()).getScope());
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"A");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.VARIABLE_TYPE);
        iterator = iASTCompletionNode.getKeywords();
        Assert.assertFalse((boolean)iterator.hasNext());
        iASTCompletionNode = this.parse(stringWriter.toString(), 12);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionPrefix());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTClassSpecifier));
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"i");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.FIELD_TYPE);
        iterator = iASTCompletionNode.getKeywords();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"inline");
        Assert.assertEquals((String)((String)iterator.next()), (String)"int");
        Assert.assertFalse((boolean)iterator.hasNext());
        iASTCompletionNode = this.parse(stringWriter.toString(), 22);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionPrefix());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionScope(), (Object)((CompleteParseBaseTest.Scope)this.callback.getCompilationUnit()).getScope());
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"AB");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.VARIABLE_TYPE);
        iterator = iASTCompletionNode.getKeywords();
        Assert.assertFalse((boolean)iterator.hasNext());
        iASTCompletionNode = this.parse(stringWriter.toString(), 6);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionPrefix());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionScope(), (Object)((CompleteParseBaseTest.Scope)this.callback.getCompilationUnit()).getScope());
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.USER_SPECIFIED_NAME);
        iterator = iASTCompletionNode.getKeywords();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testCompletionLookup_Unqualified() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int aVar; ");
        stringWriter.write("void foo( ) { ");
        stringWriter.write("   int anotherVar; ");
        stringWriter.write("   a ");
        stringWriter.write("} ");
        String string = stringWriter.toString();
        int n = 0;
        while (n < 2) {
            int n2 = n == 0 ? string.indexOf(" a ") + 2 : string.indexOf(" a ") + 1;
            IASTCompletionNode iASTCompletionNode = this.parse(string, n2);
            Assert.assertNotNull((Object)iASTCompletionNode);
            String string2 = iASTCompletionNode.getCompletionPrefix();
            Assert.assertNotNull((Object)string2);
            Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
            Assert.assertEquals((String)string2, (String)(n == 0 ? "a" : ""));
            Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
            IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, lookupKindArray, iASTCompletionNode.getCompletionContext());
            Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
            Iterator iterator = iLookupResult.getNodes();
            IASTVariable iASTVariable = (IASTVariable)iterator.next();
            IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
            if (n != 0) {
                IASTFunction iASTFunction = (IASTFunction)iterator.next();
                Assert.assertEquals((String)iASTFunction.getName(), (String)"foo");
            }
            Assert.assertFalse((boolean)iterator.hasNext());
            Assert.assertEquals((String)iASTVariable.getName(), (String)"anotherVar");
            Assert.assertEquals((String)iASTVariable2.getName(), (String)"aVar");
            ++n;
        }
    }

    public void testCompletionLookup_Qualified() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int aVar; ");
        stringWriter.write("struct D{ ");
        stringWriter.write("   int aField; ");
        stringWriter.write("   void aMethod(); ");
        stringWriter.write("}; ");
        stringWriter.write("void foo(){");
        stringWriter.write("   D d; ");
        stringWriter.write("   d.a ");
        stringWriter.write("}\n");
        String string = stringWriter.toString();
        int n = string.indexOf("d.a");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        String string2 = iASTCompletionNode.getCompletionPrefix();
        Assert.assertNotNull((Object)string2);
        Assert.assertEquals((String)string2, (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTClassSpecifier));
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, lookupKindArray, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
        Iterator iterator = iLookupResult.getNodes();
        IASTField iASTField = (IASTField)iterator.next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aMethod");
        Assert.assertEquals((String)iASTField.getName(), (String)"aField");
    }

    public void testMemberCompletion_Arrow() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {");
        stringWriter.write("   public:   void aPublicBaseMethod();");
        stringWriter.write("   private:  void aPrivateBaseMethod();");
        stringWriter.write("};");
        stringWriter.write("class B : public A {");
        stringWriter.write("   public:   void aMethod();");
        stringWriter.write("};");
        stringWriter.write("void foo(){");
        stringWriter.write("   B * b = new B();");
        stringWriter.write("   b-> \n");
        String string = stringWriter.toString();
        int n = string.indexOf("b->");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((String)((IASTFunction)iASTCompletionNode.getCompletionScope()).getName(), (String)"foo");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTClassSpecifier));
        Assert.assertEquals((String)((IASTClassSpecifier)iASTCompletionNode.getCompletionContext()).getName(), (String)"B");
    }

    public void testMemberCompletion_Dot() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {");
        stringWriter.write("   public:   void aPublicBaseMethod();");
        stringWriter.write("   private:  void aPrivateBaseMethod();");
        stringWriter.write("};");
        stringWriter.write("class B : public A {");
        stringWriter.write("   public:   void aMethod();");
        stringWriter.write("};");
        stringWriter.write("void foo(){");
        stringWriter.write("   B b;");
        stringWriter.write("   b. \n");
        String string = stringWriter.toString();
        int n = string.indexOf("b.");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 2);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"");
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((String)((IASTFunction)iASTCompletionNode.getCompletionScope()).getName(), (String)"foo");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTClassSpecifier));
        Assert.assertEquals((String)((IASTClassSpecifier)iASTCompletionNode.getCompletionContext()).getName(), (String)"B");
    }

    public void testCompletionLookup_Pointer() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {");
        stringWriter.write("   public:   void aPublicBaseMethod();");
        stringWriter.write("   private:  void aPrivateBaseMethod();");
        stringWriter.write("};");
        stringWriter.write("class B : public A {");
        stringWriter.write("   public:   void aMethod();");
        stringWriter.write("};");
        stringWriter.write("void foo(){");
        stringWriter.write("   B * b = new B();");
        stringWriter.write("   b->a \n");
        int n = 0;
        while (n < 2) {
            String string = stringWriter.toString();
            int n2 = n == 0 ? string.indexOf("b->a") + 4 : string.indexOf("b->") + 3;
            IASTCompletionNode iASTCompletionNode = this.parse(string, n2);
            Assert.assertNotNull((Object)iASTCompletionNode);
            String string2 = iASTCompletionNode.getCompletionPrefix();
            Assert.assertEquals((String)string2, (String)(n == 0 ? "a" : ""));
            Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
            Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
            Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
            Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTClassSpecifier));
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.METHODS};
            IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, lookupKindArray, iASTCompletionNode.getCompletionContext());
            Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
            Iterator iterator = iLookupResult.getNodes();
            IASTMethod iASTMethod = (IASTMethod)iterator.next();
            IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            Assert.assertEquals((String)iASTMethod.getName(), (String)"aMethod");
            Assert.assertEquals((String)iASTMethod2.getName(), (String)"aPublicBaseMethod");
            ++n;
        }
    }

    public void testCompletionLookup_FriendClass_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A {");
        stringWriter.write("   private:  void aPrivateMethod();");
        stringWriter.write("   friend class C;");
        stringWriter.write("};");
        stringWriter.write("class C {");
        stringWriter.write("   void foo();");
        stringWriter.write("};");
        stringWriter.write("void C::foo(){");
        stringWriter.write("   A a;");
        stringWriter.write("   a.a \n");
        String string = stringWriter.toString();
        int n = string.indexOf("a.a");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        String string2 = iASTCompletionNode.getCompletionPrefix();
        Assert.assertEquals((String)string2, (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTClassSpecifier));
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, new IASTNode.LookupKind[]{IASTNode.LookupKind.METHODS}, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
        Iterator iterator = iLookupResult.getNodes();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aPrivateMethod");
    }

    public void testCompletionLookup_FriendClass_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class C {");
        stringWriter.write("   void foo();");
        stringWriter.write("};");
        stringWriter.write("class A {");
        stringWriter.write("   private:  void aPrivateMethod();");
        stringWriter.write("   friend class C;");
        stringWriter.write("};");
        stringWriter.write("void C::foo(){");
        stringWriter.write("   A a;");
        stringWriter.write("   a.a \n");
        String string = stringWriter.toString();
        int n = string.indexOf("a.a");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 3);
        Assert.assertNotNull((Object)iASTCompletionNode);
        String string2 = iASTCompletionNode.getCompletionPrefix();
        Assert.assertEquals((String)string2, (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTFunction));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.MEMBER_REFERENCE);
        Assert.assertNotNull((Object)iASTCompletionNode.getCompletionContext());
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionContext() instanceof IASTClassSpecifier));
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, new IASTNode.LookupKind[]{IASTNode.LookupKind.METHODS}, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
        Iterator iterator = iLookupResult.getNodes();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aPrivateMethod");
    }

    public void testCompletionLookup_ParametersAsLocalVariables() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int foo( int aParameter ){");
        stringWriter.write("   int aLocal;");
        stringWriter.write("   if( aLocal != 0 ){");
        stringWriter.write("      int aBlockLocal;");
        stringWriter.write("      a \n");
        String string = stringWriter.toString();
        int n = string.indexOf(" a ");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 2);
        Assert.assertNotNull((Object)iASTCompletionNode);
        String string2 = iASTCompletionNode.getCompletionPrefix();
        Assert.assertEquals((String)string2, (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTCodeScope));
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(string2, new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES}, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((String)iLookupResult.getPrefix(), (String)string2);
        Iterator iterator = iLookupResult.getNodes();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTVariable.getName(), (String)"aBlockLocal");
        Assert.assertEquals((String)iASTVariable2.getName(), (String)"aLocal");
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"aParameter");
    }

    public void testCompletionLookup_LookupKindTHIS() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int aGlobalVar;");
        stringWriter.write("namespace NS { ");
        stringWriter.write("   int aNamespaceFunction(){}");
        stringWriter.write("   class Base { ");
        stringWriter.write("      protected: int aBaseField;");
        stringWriter.write("   };");
        stringWriter.write("   class Derived : public Base {");
        stringWriter.write("      int aMethod();");
        stringWriter.write("   };");
        stringWriter.write("}");
        stringWriter.write("int NS::Derived::aMethod(){");
        stringWriter.write("   int aLocal;");
        stringWriter.write("   a  ");
        String string = stringWriter.toString();
        int n = string.indexOf(" a ");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 2);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTMethod));
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS}, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)2);
        Iterator iterator = iLookupResult.getNodes();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTField iASTField = (IASTField)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aMethod");
        Assert.assertEquals((String)iASTField.getName(), (String)"aBaseField");
        iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS, IASTNode.LookupKind.METHODS}, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        iterator = iLookupResult.getNodes();
        iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"aMethod");
    }

    public void testCompletionInConstructor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class SimpleTest{");
        ((Writer)stringWriter).write("\tpublic:");
        ((Writer)stringWriter).write("SimpleTest();");
        ((Writer)stringWriter).write("~SimpleTest();");
        ((Writer)stringWriter).write("int a, b, c, aa, bb, cc, abc;");
        ((Writer)stringWriter).write("};");
        ((Writer)stringWriter).write("SimpleTest::~SimpleTest()");
        ((Writer)stringWriter).write("{}");
        ((Writer)stringWriter).write("SimpleTest::SimpleTest()");
        ((Writer)stringWriter).write("{");
        ((Writer)stringWriter).write("/**/a");
        ((Writer)stringWriter).write("}");
        IASTCompletionNode iASTCompletionNode = this.parse(((Object)stringWriter).toString(), ((Object)stringWriter).toString().indexOf("/**/a") + 5);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTMethod));
        IASTMethod iASTMethod = (IASTMethod)iASTCompletionNode.getCompletionScope();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"SimpleTest");
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.FIELDS};
        IASTNode.ILookupResult iLookupResult = iASTMethod.lookup("a", lookupKindArray, null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)3);
    }

    public void testCompletionInDestructor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class SimpleTest{");
        ((Writer)stringWriter).write("\tpublic:");
        ((Writer)stringWriter).write("SimpleTest();");
        ((Writer)stringWriter).write("~SimpleTest();");
        ((Writer)stringWriter).write("int a, b, c, aa, bb, cc, abc;");
        ((Writer)stringWriter).write("};");
        ((Writer)stringWriter).write("SimpleTest::SimpleTest()");
        ((Writer)stringWriter).write("{}");
        ((Writer)stringWriter).write("SimpleTest::~SimpleTest()");
        ((Writer)stringWriter).write("{");
        ((Writer)stringWriter).write("/**/a");
        ((Writer)stringWriter).write("}");
        IASTCompletionNode iASTCompletionNode = this.parse(((Object)stringWriter).toString(), ((Object)stringWriter).toString().indexOf("/**/a") + 5);
        Assert.assertNotNull((Object)iASTCompletionNode);
        Assert.assertEquals((String)iASTCompletionNode.getCompletionPrefix(), (String)"a");
        Assert.assertTrue((boolean)(iASTCompletionNode.getCompletionScope() instanceof IASTMethod));
        IASTMethod iASTMethod = (IASTMethod)iASTCompletionNode.getCompletionScope();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"~SimpleTest");
        Assert.assertTrue((boolean)iASTMethod.isDestructor());
        Assert.assertEquals((Object)iASTCompletionNode.getCompletionKind(), (Object)IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
        Assert.assertNull((Object)iASTCompletionNode.getCompletionContext());
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.FIELDS};
        IASTNode.ILookupResult iLookupResult = iASTMethod.lookup("a", lookupKindArray, null);
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)3);
    }

    public void testBug48307_FriendFunction_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{ public : void foo(); }; ");
        stringWriter.write("class B{ ");
        stringWriter.write("   private : int aPrivate;");
        stringWriter.write("   friend void A::foo(); ");
        stringWriter.write("};");
        stringWriter.write("void A::foo(){");
        stringWriter.write("   B b;");
        stringWriter.write("   b.aP");
        String string = stringWriter.toString();
        int n = string.indexOf("b.aP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 4);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        IASTField iASTField = (IASTField)iLookupResult.getNodes().next();
        Assert.assertEquals((String)iASTField.getName(), (String)"aPrivate");
    }

    public void testBug48307_FriendFunction_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void global();");
        stringWriter.write("class B{ ");
        stringWriter.write("   private : int aPrivate;");
        stringWriter.write("   friend void global(); ");
        stringWriter.write("};");
        stringWriter.write("void global(){");
        stringWriter.write("   B b;");
        stringWriter.write("   b.aP");
        String string = stringWriter.toString();
        int n = string.indexOf("b.aP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n + 4);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL}, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)1);
        IASTField iASTField = (IASTField)iLookupResult.getNodes().next();
        Assert.assertEquals((String)iASTField.getName(), (String)"aPrivate");
    }

    public void testBug51260() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(" class A { public: void a(); }; ");
        stringWriter.write(" class B : public virtual A { public: void b(); };");
        stringWriter.write(" class C : public virtual A { public: void c(); };");
        stringWriter.write(" class D : public B, C { public: void d(); };");
        stringWriter.write(" void A::a(){} ");
        stringWriter.write(" void B::b(){} ");
        stringWriter.write(" void C::c(){} ");
        stringWriter.write(" void D::d(){ SP }");
        String string = stringWriter.toString();
        int n = string.indexOf("SP");
        IASTCompletionNode iASTCompletionNode = this.parse(string, n);
        IASTNode.ILookupResult iLookupResult = iASTCompletionNode.getCompletionScope().lookup(iASTCompletionNode.getCompletionPrefix(), new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS}, iASTCompletionNode.getCompletionContext());
        Assert.assertEquals((int)iLookupResult.getResultsSize(), (int)4);
        Iterator iterator = iLookupResult.getNodes();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        IASTMethod iASTMethod3 = (IASTMethod)iterator.next();
        IASTMethod iASTMethod4 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod3.getName(), (String)"a");
        Assert.assertEquals((String)iASTMethod2.getName(), (String)"b");
        Assert.assertEquals((String)iASTMethod4.getName(), (String)"c");
        Assert.assertEquals((String)iASTMethod.getName(), (String)"d");
    }
}

