/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.internal.core.parser.IExpressionParser;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;

public class ExprEvalTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ExprEvalTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ExprEvalTest(String string) {
        super(string);
    }

    public void runTest(String string, int n) throws Exception {
        NullSourceElementRequestor nullSourceElementRequestor = new NullSourceElementRequestor();
        IExpressionParser iExpressionParser = InternalParserUtil.createExpressionParser((IScanner)ParserFactory.createScanner((Reader)new StringReader(string), (String)((Object)((Object)this)).getClass().getName(), (IScannerInfo)new ScannerInfo(), null, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)nullSourceElementRequestor, (IParserLogService)new NullLogService()), (ParserLanguage)ParserLanguage.CPP, null);
        IASTExpression iASTExpression = iExpressionParser.expression(null);
        Assert.assertEquals((int)n, (int)iASTExpression.evaluateExpression());
    }

    public void testInteger() throws Exception {
        this.runTest("5;", 5);
        this.runTest("33;", 33);
    }

    public void testNot() throws Exception {
        this.runTest("!1;", 0);
        this.runTest("!0;", 1);
        this.runTest("!4;", 0);
        this.runTest("!!4;", 1);
    }

    public void testMultiplicational() throws Exception {
        this.runTest("3 * 4;", 12);
        this.runTest("55 * 2;", 110);
        this.runTest("4 / 3;", 1);
        this.runTest("100/4;", 25);
        this.runTest("8 % 2;", 0);
        this.runTest("8 % 3;", 2);
    }

    public void testAdditive() throws Exception {
        this.runTest("4 + 4;", 8);
        this.runTest("4 - 4;", 0);
    }

    public void testLogicalAnd() throws Exception {
        this.runTest("4 && 5;", 1);
        this.runTest("0 && 5;", 0);
        this.runTest("5 && 0;", 0);
        this.runTest("0 && 0;", 0);
    }

    public void testLogicalOr() throws Exception {
        this.runTest("4 || 5;", 1);
        this.runTest("0 || 5;", 1);
        this.runTest("5 || 0;", 1);
        this.runTest("0 || 0;", 0);
    }

    public void testRelational() throws Exception {
        this.runTest("1 < 2;", 1);
        this.runTest("2 < 1;", 0);
        this.runTest("2 == 1 + 1;", 1);
        this.runTest("2 != 1 + 1;", 0);
    }

    public void testBracketed() throws Exception {
        this.runTest("2 * (3 + 4);", 14);
    }
}

