/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.tests.AutomatedFramework;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class FractionalAutomatedTest
extends AutomatedFramework {
    protected static int stepSize = 50;
    protected static int windowSize = 200;
    protected static int timeOut = 5000;
    protected static String outputDir = null;
    protected static int failures = 0;

    public FractionalAutomatedTest() {
    }

    public FractionalAutomatedTest(String string) {
        super(string);
    }

    protected AutomatedFramework newTest(String string) {
        return new FractionalAutomatedTest(string);
    }

    protected void loadProperties() throws Exception {
        String string = Platform.getPlugin((String)"org.eclipse.cdt.core.tests").find((IPath)new Path("/")).getFile();
        string = String.valueOf(string) + "resources/parser/AutomatedTest";
        try {
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(string) + "/FractionalAutomatedTest.properties");
            AutomatedFramework.properties.load(fileInputStream);
            AutomatedFramework.outputFile = AutomatedFramework.properties.getProperty("outputFile", "");
            String string2 = AutomatedFramework.properties.getProperty("source", "");
            stepSize = Integer.parseInt(AutomatedFramework.properties.getProperty("stepSize", "50"));
            windowSize = Integer.parseInt(AutomatedFramework.properties.getProperty("windowSize", "200"));
            timeOut = Integer.parseInt(AutomatedFramework.properties.getProperty("timeOut", "5000"));
            outputDir = AutomatedFramework.properties.getProperty("outDir", "");
            if (string2.equals("")) {
                throw new FileNotFoundException();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = null;
            String string4 = null;
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().trim();
                    string4 = stringTokenizer.nextToken().trim();
                    AutomatedFramework.testSources.put(string3, string4);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                AutomatedFramework.testSources.put(string3, "cpp");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            AutomatedFramework.testSources.put(String.valueOf(string) + "/defaultCpp", "cpp");
            AutomatedFramework.testSources.put(String.valueOf(string) + "/defaultC", "c");
        }
    }

    public static Test suite() {
        FractionalAutomatedTest fractionalAutomatedTest = new FractionalAutomatedTest();
        return fractionalAutomatedTest.createSuite();
    }

    private static String outputFile(String string) {
        if (outputDir == null || outputDir.equals("")) {
            return "";
        }
        File file = new File(outputDir);
        try {
            File file2;
            if (file.exists()) {
                if (file.isFile()) {
                    file.delete();
                    file.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(string.getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    return outputDir;
                }
            } else {
                file.mkdir();
            }
            if ((file2 = new File(String.valueOf(outputDir) + "/" + failures++ + ".tmp")).exists()) {
                file2.delete();
            }
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            return file2.getCanonicalPath();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void reportHang(String string, String string2) {
        String string3 = FractionalAutomatedTest.outputFile(string.toString());
        string3 = string3.equals("") ? "Parser hang while parsing " + string2 + "\n" : "Parser hang while parsing " + string3 + "\n";
        if (AutomatedFramework.report != null) {
            try {
                AutomatedFramework.report.write(string3.getBytes());
            }
            catch (IOException iOException) {}
        }
        Assert.fail((String)string3);
    }

    public static void reportException(String string, String string2, String string3) {
        String string4 = FractionalAutomatedTest.outputFile(string.toString());
        string4 = string4.equals("") ? String.valueOf(string3.getClass().toString()) + " encountered in " + string2 + "\n" : String.valueOf(string3.getClass().toString()) + " encountered in " + string4 + "\n";
        if (AutomatedFramework.report != null) {
            try {
                AutomatedFramework.report.write(string4.getBytes());
            }
            catch (IOException iOException) {}
        }
        Assert.fail((String)string4);
    }

    public void doFile() throws Throwable {
        Assert.assertNotNull((Object)AutomatedFramework.fileList);
        File file = (File)AutomatedFramework.fileList.removeFirst();
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = file.getCanonicalPath();
        String string2 = (String)AutomatedFramework.natures.get(string);
        boolean bl = string2.equalsIgnoreCase("cpp");
        StringWriter stringWriter = new StringWriter();
        ParseThread parseThread = new ParseThread();
        byte[] byArray = new byte[stepSize];
        int n = fileInputStream.read(byArray);
        while (n != -1) {
            stringWriter.write(new String(byArray));
            parseThread.code = stringWriter.toString();
            parseThread.cppNature = bl;
            parseThread.start();
            parseThread.join(timeOut);
            if (parseThread.isAlive()) {
                parseThread.stop();
                FractionalAutomatedTest.reportHang(stringWriter.toString(), string);
            } else if (parseThread.result != null) {
                FractionalAutomatedTest.reportException(stringWriter.toString(), string, parseThread.result);
            }
            n = fileInputStream.read(byArray);
        }
        String string3 = stringWriter.toString();
        String string4 = null;
        int n2 = string3.length();
        int n3 = 0;
        while (n3 + windowSize < n2) {
            string4 = string3.substring(0, n3);
            parseThread.code = string4 = String.valueOf(string4) + "\n" + string3.substring(n3 + windowSize, n2);
            parseThread.cppNature = bl;
            parseThread.file = string;
            parseThread.start();
            parseThread.join(timeOut);
            if (parseThread.isAlive()) {
                parseThread.stop();
                FractionalAutomatedTest.reportHang(string4, string);
            } else if (parseThread.result != null) {
                FractionalAutomatedTest.reportException(string4, string, parseThread.result);
            }
            n3 += stepSize;
        }
    }

    static class ParseThread
    extends Thread {
        public String code;
        public boolean cppNature;
        public String file;
        public String result;

        ParseThread() {
        }

        public void run() {
            try {
                this.result = null;
                ParserLanguage parserLanguage = this.cppNature ? ParserLanguage.CPP : ParserLanguage.C;
                IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((Reader)new StringReader(this.code), null, (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)parserLanguage, (ISourceElementRequestor)AutomatedFramework.nullCallback, (IParserLogService)new NullLogService()), (ISourceElementRequestor)AutomatedFramework.nullCallback, (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)parserLanguage, null);
                iParser.parse();
            }
            catch (Exception exception) {
                this.result = exception.getClass().toString();
            }
        }
    }
}

