/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.IPreprocessor;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;

public class PreprocessorTest
extends TestCase {
    public PreprocessorTest(String string) {
        super(string);
    }

    public void testSimpleExample() {
        Callback callback = new Callback();
        IPreprocessor iPreprocessor = this.setupPreprocessor("#include <stdio.h>", null, null, (ISourceElementRequestor)callback);
        iPreprocessor.process();
        callback.asExpected(0);
    }

    public IPreprocessor setupPreprocessor(String string, List list, Map map, ISourceElementRequestor iSourceElementRequestor) {
        IPreprocessor iPreprocessor = ParserFactory.createPreprocessor((Reader)new StringReader(string), (String)"test", (IScannerInfo)new ScannerInfo(map, list == null ? null : (String[])list.toArray()), (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)iSourceElementRequestor, null);
        return iPreprocessor;
    }

    public static class Callback
    extends NullSourceElementRequestor {
        private List enteredInc = new ArrayList();
        private List exitedInc = new ArrayList();

        public boolean asExpected(int n) {
            return this.enteredInc.size() - this.exitedInc.size() == n;
        }

        public void enterInclusion(IASTInclusion iASTInclusion) {
            this.enteredInc.add(iASTInclusion);
        }

        public void exitInclusion(IASTInclusion iASTInclusion) {
            this.exitedInc.add(iASTInclusion);
        }
    }
}

