/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;

public class SelectionParseTest
extends CompleteParseBaseTest {
    protected IASTNode parse(String string, int n, int n2) throws Exception {
        this.callback = new CompleteParseBaseTest.FullParseCallback();
        IParser iParser = null;
        iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((Reader)new StringReader(string), (String)"completion-test", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)this.callback, (IParserLogService)new NullLogService()), (ISourceElementRequestor)this.callback, (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)ParserLanguage.CPP, (IParserLogService)ParserUtil.getParserLogService());
        return iParser.parse(n, n2);
    }

    public void testBaseCase_VariableReference() throws Exception {
        String string = "int x; x=3;";
        int n = string.indexOf("x=");
        int n2 = string.indexOf(61);
        IASTNode iASTNode = this.parse(string, n, n2);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTVariable));
        Assert.assertEquals((String)((IASTVariable)iASTNode).getName(), (String)"x");
    }

    public void testBaseCase_FunctionReference() throws Exception {
        String string = "int x(){x( );}";
        int n = string.indexOf("x( ");
        int n2 = string.indexOf("( )");
        IASTNode iASTNode = this.parse(string, n, n2);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        Assert.assertEquals((String)((IASTFunction)iASTNode).getName(), (String)"x");
    }

    public void testBaseCase_Error() throws Exception {
        String string = "int x() { y( ) }";
        int n = string.indexOf("y( ");
        int n2 = string.indexOf("( )");
        Assert.assertNull((Object)this.parse(string, n, n2));
    }
}

