/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search.tests;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.core.search.tests.BaseSearchTest;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.search.matching.ClassDeclarationPattern;

public class ClassDeclarationPatternTests
extends BaseSearchTest
implements ICSearchConstants {
    public ClassDeclarationPatternTests(String string) {
        super(string);
    }

    public void testMatchSimpleDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testMatchNamespaceNestedDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::B", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        ClassDeclarationPattern classDeclarationPattern = (ClassDeclarationPattern)iCSearchPattern;
        Assert.assertTrue((boolean)CharOperation.equals((char[])new char[]{'B'}, (char[])classDeclarationPattern.getName()));
        Assert.assertTrue((classDeclarationPattern.getContainingTypes().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)CharOperation.equals((char[])new char[]{'N', 'S'}, (char[])classDeclarationPattern.getContainingTypes()[0]));
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testBug39652() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertTrue((set != null ? 1 : 0) != 0);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::NS2::a", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertTrue((set != null ? 1 : 0) != 0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::B::AA", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertTrue((set != null ? 1 : 0) != 0);
    }

    public void testMatchStruct() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"AA", (ICSearchConstants.SearchFor)ICSearchConstants.STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::B::AA", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set2 = this.resultCollector.getSearchResults();
        Assert.assertTrue((set2 != null ? 1 : 0) != 0);
        Assert.assertEquals((int)set2.size(), (int)1);
        Iterator iterator = set.iterator();
        Iterator iterator2 = set2.iterator();
        IMatch iMatch = (IMatch)iterator.next();
        IMatch iMatch2 = (IMatch)iterator2.next();
        Assert.assertEquals((int)iMatch.getStartOffset(), (int)iMatch2.getStartOffset());
        Assert.assertEquals((int)iMatch.getEndOffset(), (int)iMatch2.getEndOffset());
    }

    public void testWildcardQualification() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::*::A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::*::A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testElaboratedType() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"struct AA", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"union u", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"union ::*::u", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testClassIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"struct A::B::*::c", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        ClassDeclarationPattern classDeclarationPattern = (ClassDeclarationPattern)iCSearchPattern;
        Assert.assertEquals((int)CharOperation.compareWith((char[])"typeDecl/S/c/".toCharArray(), (char[])classDeclarationPattern.indexEntryPrefix()), (int)0);
        classDeclarationPattern = (ClassDeclarationPattern)SearchEngine.createSearchPattern((String)"class ::*::A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"typeDecl/C/c/B/A/".toCharArray(), (char[])classDeclarationPattern.indexEntryPrefix()), (int)0);
        classDeclarationPattern = (ClassDeclarationPattern)SearchEngine.createSearchPattern((String)"enum ::RT*::c", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"typeRef/E/c/RT".toCharArray(), (char[])classDeclarationPattern.indexEntryPrefix()), (int)0);
        classDeclarationPattern = (ClassDeclarationPattern)SearchEngine.createSearchPattern((String)"union A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"typeRef/U/".toCharArray(), (char[])classDeclarationPattern.indexEntryPrefix()), (int)0);
    }

    public void testGloballyQualifiedItem() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"::u", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testClassReferences() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)6);
    }

    public void testClassReferenceInFieldType() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS::B::AA", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS::B"));
    }

    public void testTypeReferenceVisibleByUsingDirective() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS::NS2::a", (ICSearchConstants.SearchFor)ICSearchConstants.STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS::B"));
    }

    public void testEnumerationReferenceVisibleByInheritance() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS::B::e", (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS3::C"));
    }

    public void testHeadersVisitedTwice() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"Hea*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
    }

    public void testAllOccurences() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof OrPattern));
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)7);
    }

    public void testReferencesInFunction() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"AClassForFoo", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)3);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IMatch iMatch = (IMatch)iterator.next();
            Assert.assertTrue((boolean)iMatch.getName().equals("foo(AClassForFoo)"));
            Assert.assertTrue((boolean)iMatch.getParentName().equals(""));
        }
    }

    public void testbug42902_TypeDefs() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"NS_B", (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
    }
}

