/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.suite;

import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.eclipse.cdt.core.suite.AutomatedIntegrationSuite;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class RunTests
implements IPlatformRunnable,
ITestHarness,
TestListener {
    private TestableObject testableObject;
    private PrintStream stream;
    private String testReport;
    private String pluginName = "org.eclipse.cdt.core.tests";
    Document doc;
    Element testRun;
    Element testSuite;
    Element testClass;
    Element test;
    Throwable failure;
    private Class currentTest;
    private long startTime;
    static /* synthetic */ Class class$0;

    public Object run(Object object) throws Exception {
        this.stream = System.out;
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-testout") && ++n < stringArray.length) {
                this.stream = new PrintStream(new FileOutputStream(stringArray[n]));
            } else if (stringArray[n].equals("-testreport") && ++n < stringArray.length) {
                this.testReport = stringArray[n];
            }
            ++n;
        }
        IPlatformRunnable iPlatformRunnable = this.getApplication();
        this.testableObject = PlatformUI.getTestableObject();
        this.testableObject.setTestHarness((ITestHarness)this);
        return iPlatformRunnable.run(object);
    }

    private IPlatformRunnable getApplication() throws CoreException {
        Object object;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension iExtension = Platform.getPluginRegistry().getExtension("org.eclipse.core.runtime", "applications", "org.eclipse.ui.ide.workbench");
        IConfigurationElement[] iConfigurationElementArray2 = iExtension.getConfigurationElements();
        if (iConfigurationElementArray2.length > 0 && (iConfigurationElementArray = iConfigurationElementArray2[0].getChildren("run")).length > 0 && (object = iConfigurationElementArray[0].createExecutableExtension("class")) instanceof IPlatformRunnable) {
            return (IPlatformRunnable)object;
        }
        return null;
    }

    public void runTests() {
        this.testableObject.testingStarting();
        this.testableObject.runTest(new Runnable(){

            public void run() {
                TestResult testResult = new TestResult();
                testResult.addListener((TestListener)RunTests.this);
                try {
                    RunTests.this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    ProcessingInstruction processingInstruction = RunTests.this.doc.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + RunTests.this.testReport + "\"");
                    RunTests.this.doc.appendChild(processingInstruction);
                    RunTests.this.testRun = RunTests.this.doc.createElement("testRun");
                    RunTests.this.doc.appendChild(RunTests.this.testRun);
                    RunTests.this.testRun.setAttribute("name", RunTests.this.pluginName);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.cdt.core.suite.AutomatedIntegrationSuite");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    RunTests.this.startSuite(clazz.getName());
                    AutomatedIntegrationSuite.suite().run(testResult);
                    RunTests.this.currentTest = null;
                    testResult.removeListener((TestListener)RunTests.this);
                    testResult.stop();
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.transform(new DOMSource(RunTests.this.doc), new StreamResult(RunTests.this.stream));
                }
                catch (Throwable throwable) {
                    System.out.println("runTests failed");
                    throwable.printStackTrace();
                }
            }
        });
        this.testableObject.testingFinished();
    }

    public void addError(Test test, Throwable throwable) {
        this.failure = throwable;
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.failure = assertionFailedError;
    }

    public void endTest(Test test) {
        String string;
        double d = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        this.test.setAttribute("time", String.valueOf(d));
        if (this.failure == null) {
            string = "pass";
        } else {
            CDATASection cDATASection = this.doc.createCDATASection(this.failure.toString());
            this.test.appendChild(cDATASection);
            string = this.failure instanceof AssertionFailedError ? "failed" : "error";
        }
        this.test.setAttribute("result", string);
        this.failure = null;
    }

    public void startTest(Test test) {
        if (test.getClass() != this.currentTest) {
            this.currentTest = test.getClass();
            this.testClass = this.doc.createElement("testClass");
            this.testSuite.appendChild(this.testClass);
            this.testClass.setAttribute("name", this.currentTest.getName());
        }
        this.test = this.doc.createElement("test");
        this.testClass.appendChild(this.test);
        String string = test.toString();
        string = string.substring(0, string.indexOf(40));
        this.test.setAttribute("name", string);
        this.startTime = System.currentTimeMillis();
    }

    private void startSuite(String string) {
        this.testSuite = this.doc.createElement("testSuite");
        this.testRun.appendChild(this.testSuite);
        this.testSuite.setAttribute("name", string);
    }
}

