/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testplugin;

import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class CProjectHelper {
    public static ICProject createCProject(final String string, String string2) {
        final IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IProject[] iProjectArray = new IProject[1];
        try {
            iWorkspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
                    IProject iProject = iWorkspaceRoot.getProject(string);
                    if (!iProject.exists()) {
                        iProject.create(null);
                    } else {
                        iProject.refreshLocal(2, null);
                    }
                    if (!iProject.isOpen()) {
                        iProject.open(null);
                    }
                    if (!iProject.hasNature("org.eclipse.cdt.core.cnature")) {
                        String string2 = "org.eclipse.cdt.core.tests.TestProject";
                        CProjectHelper.addNatureToProject(iProject, "org.eclipse.cdt.core.cnature", null);
                        CCorePlugin.getDefault().mapCProjectOwner(iProject, string2, false);
                    }
                    iProjectArray[0] = iProject;
                }
            }, null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)CProjectHelper.getMessage(coreException.getStatus()));
        }
        return CCorePlugin.getDefault().getCoreModel().create(iProjectArray[0]);
    }

    private static String getMessage(IStatus iStatus) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(iStatus.getMessage());
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                stringBuffer.append(CProjectHelper.getMessage(iStatusArray[n]));
                ++n;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static ICProject createCCProject(final String string, final String string2) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final ICProject[] iCProjectArray = new ICProject[1];
        try {
            iWorkspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    ICProject iCProject = CProjectHelper.createCProject(string, string2);
                    if (!iCProject.getProject().hasNature("org.eclipse.cdt.core.ccnature")) {
                        CProjectHelper.addNatureToProject(iCProject.getProject(), "org.eclipse.cdt.core.ccnature", null);
                    }
                    iCProjectArray[0] = iCProject;
                }
            }, null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)CProjectHelper.getMessage(coreException.getStatus()));
        }
        return iCProjectArray[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void delete(ICProject iCProject) {
        try {
            iCProject.getProject().delete(true, true, null);
            return;
        }
        catch (CoreException coreException) {
            try {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                try {
                    iCProject.getProject().delete(true, true, null);
                    throw throwable;
                }
                catch (CoreException coreException2) {
                    Assert.fail((String)CProjectHelper.getMessage(coreException2.getStatus()));
                }
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            try {}
            catch (CoreException coreException3) {
                Assert.fail((String)CProjectHelper.getMessage(coreException3.getStatus()));
                return;
            }
            iCProject.getProject().delete(true, true, null);
            return;
        }
    }

    public static ICContainer addSourceContainer(ICProject iCProject, String string) throws CoreException {
        IProject iProject = iCProject.getProject();
        ICProject iCProject2 = null;
        if (string == null || string.length() == 0) {
            iCProject2 = CModelManager.getDefault().create(iProject);
        } else {
            IFolder iFolder = iProject.getFolder(string);
            if (!iFolder.exists()) {
                iFolder.create(false, true, null);
            }
            iCProject2 = CModelManager.getDefault().create(iFolder);
        }
        return iCProject2;
    }

    public static ICContainer addSourceContainerWithImport(ICProject iCProject, String string, ZipFile zipFile) throws InvocationTargetException, CoreException {
        ICContainer iCContainer = CProjectHelper.addSourceContainer(iCProject, string);
        CProjectHelper.importFilesFromZip(zipFile, iCContainer.getPath(), null);
        return iCContainer;
    }

    public static void removeSourceContainer(ICProject iCProject, String string) throws CoreException {
        IFolder iFolder = iCProject.getProject().getFolder(string);
        iFolder.delete(true, null);
    }

    public static IArchive findArchive(ICProject iCProject, String string) {
        IArchiveContainer iArchiveContainer = iCProject.getArchiveContainer();
        IArchive[] iArchiveArray = iArchiveContainer.getArchives();
        if (iArchiveArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iArchiveArray.length) {
            if (iArchiveArray[n].getElementName().equals(string)) {
                return iArchiveArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IBinary findBinary(ICProject iCProject, String string) {
        IBinaryContainer iBinaryContainer = iCProject.getBinaryContainer();
        IBinary[] iBinaryArray = iBinaryContainer.getBinaries();
        if (iBinaryArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iBinaryArray.length) {
            if (iBinaryArray[n].getElementName().equals(string)) {
                return iBinaryArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IBinary findObject(ICProject iCProject, String string) {
        ICElement[] iCElementArray = iCProject.getChildren();
        if (iCElementArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementName().equals(string) && iCElementArray[n] instanceof IBinary) {
                return (IBinary)iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    public static ITranslationUnit findTranslationUnit(ICProject iCProject, String string) {
        ICElement[] iCElementArray = iCProject.getChildren();
        if (iCElementArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementName().equals(string) && iCElementArray[n] instanceof ITranslationUnit) {
                return (ITranslationUnit)iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    public static ICElement findElement(ICProject iCProject, String string) {
        ICElement[] iCElementArray = iCProject.getChildren();
        if (iCElementArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementName().equals(string)) {
                return iCElementArray[n];
            }
            ++n;
        }
        return null;
    }

    private static void addNatureToProject(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    private static void importFilesFromZip(ZipFile zipFile, IPath iPath, IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(zipFile);
        try {
            ImportOperation importOperation = new ImportOperation(iPath, (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, (IOverwriteQuery)new ImportOverwriteQuery());
            importOperation.run(iProgressMonitor);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static class ImportOverwriteQuery
    implements IOverwriteQuery {
        ImportOverwriteQuery() {
        }

        public String queryOverwrite(String string) {
            return "ALL";
        }
    }
}

