/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.testplugin.CDebugHelper;
import org.eclipse.cdt.debug.testplugin.CProjectHelper;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class BreakpointTests
extends TestCase {
    IWorkspace workspace = ResourcesPlugin.getWorkspace();
    IWorkspaceRoot root = this.workspace.getRoot();
    static ICProject testProject = null;
    NullProgressMonitor monitor = new NullProgressMonitor();
    static ICDISession session = null;
    static ICDITarget[] targets = null;
    static /* synthetic */ Class class$0;

    public BreakpointTests(String string) {
        super(string);
        if (this.workspace == null) {
            Assert.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            Assert.fail((String)"Workspace root was not setup");
        }
    }

    protected static void oneTimeSetUp() throws CoreException, InvocationTargetException, IOException {
        ResourcesPlugin.getWorkspace().getDescription().setAutoBuilding(false);
        String string = Platform.getPlugin((String)"org.eclipse.cdt.debug.ui.tests").find((IPath)new Path("/")).getFile();
        string = String.valueOf(string) + "resources/debugTest.zip";
        testProject = CProjectHelper.createCProjectWithImport("filetest", string);
        if (testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        testProject.getProject().build(6, null);
    }

    protected void tearDown() throws CoreException {
        if (targets != null) {
            try {
                targets[0].terminate();
                targets = null;
            }
            catch (CDIException cDIException) {}
        }
        if (session != null) {
            try {
                session.terminate();
                session = null;
            }
            catch (CDIException cDIException) {}
        }
    }

    protected static void oneTimeTearDown() throws CoreException {
        if (targets != null) {
            try {
                targets[0].terminate();
            }
            catch (CDIException cDIException) {}
        }
        if (session != null) {
            try {
                session.terminate();
            }
            catch (CDIException cDIException) {}
        }
        CProjectHelper.delete(testProject);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.tests.BreakpointTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        TestSetup testSetup = new TestSetup((Test)testSuite){

            protected void setUp() throws FileNotFoundException, IOException, InterruptedException, InvocationTargetException, CoreException {
                BreakpointTests.oneTimeSetUp();
            }

            protected void tearDown() throws FileNotFoundException, IOException, CoreException {
                BreakpointTests.oneTimeTearDown();
            }
        };
        return testSetup;
    }

    public void testFunctionBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        boolean bl = false;
        ICDISession iCDISession = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)iCDISession);
        ICDIBreakpointManager iCDIBreakpointManager = iCDISession.getBreakpointManager();
        Assert.assertNotNull((Object)iCDIBreakpointManager);
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation(null, "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDILocation = iCDIBreakpointManager.createLocation(null, "main", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDILocation = iCDIBreakpointManager.createLocation(null, "badname", 0);
        Assert.assertNotNull((Object)iCDILocation);
        try {
            iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        }
        catch (CDIException cDIException) {
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        iCDIBreakpointManager.deleteAllBreakpoints();
        iCDILocation = iCDIBreakpointManager.createLocation(null, "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        targets = iCDISession.getTargets();
        Assert.assertTrue((targets.length == 1 ? 1 : 0) != 0);
        targets[0].resume();
        int n = 0;
        while (n < 100) {
            if (targets[0].isTerminated() || targets[0].isSuspended()) break;
            Thread.sleep(100L);
            ++n;
        }
        Assert.assertTrue((boolean)targets[0].isSuspended());
        iCDILocation = targets[0].getCurrentThread().getStackFrames()[0].getLocation();
        Assert.assertTrue((iCDILocation.getLineNumber() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iCDILocation.getFunction().equals("func1"));
        Assert.assertTrue((boolean)iCDILocation.getFile().equals("main.c"));
        targets[0].terminate();
        n = 0;
        while (!targets[0].isTerminated() && n < 30) {
            Thread.sleep(100L);
        }
        if (!targets[0].isTerminated()) {
            targets[0].terminate();
        }
        iCDISession.terminate();
        iCDISession = null;
        targets = null;
    }

    public void testLineBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        boolean bl = false;
        session = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)session);
        ICDIBreakpointManager iCDIBreakpointManager = session.getBreakpointManager();
        Assert.assertNotNull((Object)iCDIBreakpointManager);
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, 7);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, 18);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, 30);
        Assert.assertNotNull((Object)iCDILocation);
        try {
            iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        }
        catch (CDIException cDIException) {
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        bl = false;
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, 11);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDILocation = iCDIBreakpointManager.createLocation(null, null, 7);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        bl = false;
        iCDILocation = iCDIBreakpointManager.createLocation(null, null, 30);
        Assert.assertNotNull((Object)iCDILocation);
        try {
            iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        }
        catch (CDIException cDIException) {
            bl = true;
        }
        Assert.assertTrue((String)"Ignoring line numbers with no file specified?", (boolean)bl);
        iCDIBreakpointManager.deleteAllBreakpoints();
        iCDILocation = iCDIBreakpointManager.createLocation(null, null, 7);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        targets = session.getTargets();
        Assert.assertTrue((targets.length == 1 ? 1 : 0) != 0);
        targets[0].resume();
        int n = 0;
        while (n < 100) {
            if (targets[0].isSuspended() || targets[0].isTerminated()) break;
            Thread.sleep(100L);
            ++n;
        }
        Assert.assertTrue((String)("Suspended: " + targets[0].isSuspended() + " Termiunated: " + targets[0].isTerminated()), (boolean)targets[0].isSuspended());
        iCDILocation = targets[0].getCurrentThread().getStackFrames()[0].getLocation();
        Assert.assertTrue((iCDILocation.getLineNumber() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iCDILocation.getFunction().equals("func1"));
        Assert.assertTrue((boolean)iCDILocation.getFile().equals("main.c"));
        session.terminate();
        session = null;
        targets = null;
    }

    public void testGetBreak() throws CoreException, MIException, IOException, CDIException {
        session = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)session);
        ICDIBreakpointManager iCDIBreakpointManager = session.getBreakpointManager();
        Assert.assertNotNull((Object)iCDIBreakpointManager);
        ICDIBreakpoint[] iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation("main.c", "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 1 ? 1 : 0) != 0);
        Object object = iCDIBreakpointArray[0] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)iCDIBreakpointArray[0] : null;
        Assert.assertNotNull(object);
        Assert.assertTrue((boolean)object.getLocation().equals(iCDILocation));
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", "main", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 2 ? 1 : 0) != 0);
        object = iCDIBreakpointArray[1] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)iCDIBreakpointArray[1] : null;
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)object.getLocation().equals(iCDILocation));
        iCDIBreakpointManager.deleteAllBreakpoints();
        session.terminate();
        session = null;
    }

    public void testDelBreak() throws CoreException, MIException, IOException, CDIException {
        session = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)session);
        ICDIBreakpointManager iCDIBreakpointManager = session.getBreakpointManager();
        Assert.assertNotNull((Object)iCDIBreakpointManager);
        ICDIBreakpoint[] iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation("main.c", "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        ICDILocationBreakpoint iCDILocationBreakpoint = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDIBreakpointManager.deleteBreakpoint((ICDIBreakpoint)iCDILocationBreakpoint);
        this.pause();
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDILocationBreakpoint = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        ICDILocation iCDILocation2 = iCDILocationBreakpoint.getLocation();
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", "main", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDILocationBreakpoint = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDIBreakpointManager.deleteBreakpoint((ICDIBreakpoint)iCDILocationBreakpoint);
        this.pause();
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 1 ? 1 : 0) != 0);
        iCDILocationBreakpoint = (ICDILocationBreakpoint)iCDIBreakpointArray[0];
        Assert.assertNotNull((Object)iCDILocationBreakpoint);
        Assert.assertTrue((boolean)iCDILocationBreakpoint.getLocation().equals(iCDILocation2));
        iCDIBreakpointManager.deleteBreakpoint((ICDIBreakpoint)iCDILocationBreakpoint);
        this.pause();
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        ICDIBreakpoint[] iCDIBreakpointArray2 = new ICDIBreakpoint[1];
        int n = 0;
        while (n < 10) {
            iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, n + 1);
            iCDIBreakpointArray2[0] = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
            Assert.assertNotNull((Object)iCDIBreakpointArray2[0]);
            ++n;
        }
        iCDIBreakpointManager.deleteBreakpoints(iCDIBreakpointArray2);
        this.pause();
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 9 ? 1 : 0) != 0);
        n = 0;
        while (n < iCDIBreakpointArray.length) {
            iCDILocationBreakpoint = (ICDILocationBreakpoint)iCDIBreakpointArray[n];
            Assert.assertTrue((iCDILocationBreakpoint.getLocation().getLineNumber() == n + 1 ? 1 : 0) != 0);
            ++n;
        }
        iCDIBreakpointManager.deleteAllBreakpoints();
        this.pause();
        Assert.assertTrue((iCDIBreakpointManager.getBreakpoints().length == 0 ? 1 : 0) != 0);
        iCDIBreakpointArray2 = new ICDIBreakpoint[4];
        n = 0;
        while (n < 10) {
            iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, n + 1);
            iCDIBreakpointArray2[n % 4] = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
            Assert.assertNotNull((Object)iCDIBreakpointArray2[n % 4]);
            ++n;
        }
        iCDIBreakpointManager.deleteBreakpoints(iCDIBreakpointArray2);
        this.pause();
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 6 ? 1 : 0) != 0);
        n = 0;
        while (n < iCDIBreakpointArray.length) {
            iCDILocationBreakpoint = (ICDILocationBreakpoint)iCDIBreakpointArray[n];
            Assert.assertTrue((iCDILocationBreakpoint.getLocation().getLineNumber() == n + 1 ? 1 : 0) != 0);
            ++n;
        }
        iCDIBreakpointManager.deleteAllBreakpoints();
        this.pause();
        Assert.assertTrue((iCDIBreakpointManager.getBreakpoints().length == 0 ? 1 : 0) != 0);
        iCDIBreakpointArray2 = new ICDIBreakpoint[10];
        n = 0;
        while (n < 10) {
            iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, n + 1);
            iCDIBreakpointArray2[n] = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
            Assert.assertNotNull((Object)iCDIBreakpointArray2[n]);
            ++n;
        }
        iCDIBreakpointManager.deleteBreakpoints(iCDIBreakpointArray2);
        this.pause();
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        n = 0;
        while (n < 10) {
            iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, n + 1);
            iCDILocationBreakpoint = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
            Assert.assertNotNull((Object)iCDILocationBreakpoint);
            ++n;
        }
        iCDIBreakpointManager.deleteAllBreakpoints();
        this.pause();
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        session.terminate();
        session = null;
    }

    public void testCondBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        boolean bl = false;
        session = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)session);
        ICDIBreakpointManager iCDIBreakpointManager = session.getBreakpointManager();
        Assert.assertNotNull((Object)iCDIBreakpointManager);
        ICDICondition iCDICondition = iCDIBreakpointManager.createCondition(0, "");
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation(null, "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, iCDICondition, null);
        iCDICondition = iCDIBreakpointManager.createCondition(0, "x<10");
        iCDILocation = iCDIBreakpointManager.createLocation(null, "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, iCDICondition, null);
        iCDICondition = iCDIBreakpointManager.createCondition(0, "nonexist<10");
        iCDILocation = iCDIBreakpointManager.createLocation(null, "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        try {
            iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, iCDICondition, null);
        }
        catch (CDIException cDIException) {
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        iCDIBreakpointManager.deleteAllBreakpoints();
        iCDILocation = iCDIBreakpointManager.createLocation(null, null, 23);
        Assert.assertNotNull((Object)iCDILocation);
        iCDICondition = iCDIBreakpointManager.createCondition(0, "a>10");
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, iCDICondition, null);
        targets = session.getTargets();
        Assert.assertTrue((targets.length == 1 ? 1 : 0) != 0);
        targets[0].resume();
        int n = 0;
        while (n < 100) {
            if (targets[0].isSuspended() || targets[0].isTerminated()) break;
            Thread.sleep(100L);
            ++n;
        }
        Assert.assertTrue((String)("Suspended: " + targets[0].isSuspended() + " Termiunated: " + targets[0].isTerminated()), (boolean)targets[0].isSuspended());
        iCDILocation = targets[0].getCurrentThread().getStackFrames()[0].getLocation();
        Assert.assertTrue((iCDILocation.getLineNumber() == 23 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iCDILocation.getFunction().equals("main"));
        Assert.assertTrue((boolean)iCDILocation.getFile().equals("main.c"));
        Assert.assertTrue((String)targets[0].evaluateExpressionToString("a"), (boolean)targets[0].evaluateExpressionToString("a").equals("11"));
        session.terminate();
        session = null;
        targets = null;
    }

    void pause() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
    }
}

