/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.textmanipulation;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.internal.corext.textmanipulation.MoveTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.SwapTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.cdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.cdt.testplugin.TestPluginLauncher;

public class TextBufferTest
extends TestCase {
    private static final Class THIS;
    private TextBuffer fBuffer;
    private TextBufferEditor fEditor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.textmanipulation.TextBufferTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public TextBufferTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestPluginLauncher.run(TestPluginLauncher.getLocationFromProperties(), THIS, stringArray);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(THIS);
        return testSuite;
    }

    protected void setUp() throws Exception {
        this.fBuffer = TextBuffer.create((String)"0123456789");
        this.fEditor = new TextBufferEditor(this.fBuffer);
    }

    protected void tearDown() throws Exception {
        this.fEditor = null;
    }

    public void testOverlap1() throws Exception {
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)0, (int)2, (String)"01"));
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)1, (int)2, (String)"12"));
        Assert.assertTrue((!this.fEditor.canPerformEdits() ? 1 : 0) != 0);
    }

    public void testOverlap2() throws Exception {
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)0, (int)2, (String)"01"));
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)0, (int)1, (String)"0"));
        Assert.assertTrue((!this.fEditor.canPerformEdits() ? 1 : 0) != 0);
    }

    public void testOverlap3() throws Exception {
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)0, (int)2, (String)"01"));
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)1, (int)1, (String)"1"));
        Assert.assertTrue((!this.fEditor.canPerformEdits() ? 1 : 0) != 0);
    }

    public void testOverlap4() throws Exception {
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)0, (int)3, (String)"012"));
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)1, (int)1, (String)"1"));
        Assert.assertTrue((!this.fEditor.canPerformEdits() ? 1 : 0) != 0);
    }

    public void testOverlap5() throws Exception {
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)0, (int)3, (String)"012"));
        this.fEditor.add((TextEdit)SimpleTextEdit.createInsert((int)1, (String)"xx"));
        Assert.assertTrue((!this.fEditor.canPerformEdits() ? 1 : 0) != 0);
    }

    public void testOverlap6() throws Exception {
        this.fEditor.add((TextEdit)SimpleTextEdit.createReplace((int)0, (int)3, (String)"012"));
        this.fEditor.add((TextEdit)SimpleTextEdit.createInsert((int)2, (String)"xx"));
        Assert.assertTrue((!this.fEditor.canPerformEdits() ? 1 : 0) != 0);
    }

    public void testOverlap7() throws Exception {
        boolean bl = false;
        try {
            new MoveTextEdit(2, 5, 3);
        }
        catch (Exception exception) {
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testOverlap8() throws Exception {
        boolean bl = false;
        try {
            new MoveTextEdit(2, 5, 6);
        }
        catch (Exception exception) {
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
    }

    public void testOverlap9() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(3, 1, 7);
        MoveTextEdit moveTextEdit2 = new MoveTextEdit(2, 3, 8);
        this.fEditor.add((TextEdit)moveTextEdit);
        this.fEditor.add((TextEdit)moveTextEdit2);
        Assert.assertTrue((!this.fEditor.canPerformEdits() ? 1 : 0) != 0);
    }

    public void testInsert1() throws Exception {
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createInsert((int)2, (String)"yy");
        SimpleTextEdit simpleTextEdit2 = SimpleTextEdit.createReplace((int)2, (int)3, (String)"3456");
        this.fEditor.add((TextEdit)simpleTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit2);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 2);
        this.tb_assert(simpleTextEdit2.getTextRange(), 4, 4);
        Assert.assertEquals((String)"Buffer content", (String)"01yy345656789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 0);
        this.tb_assert(simpleTextEdit2.getTextRange(), 2, 3);
    }

    public void testInsert2() throws Exception {
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createInsert((int)2, (String)"yy");
        SimpleTextEdit simpleTextEdit2 = SimpleTextEdit.createInsert((int)2, (String)"xx");
        this.fEditor.add((TextEdit)simpleTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit2);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 2);
        this.tb_assert(simpleTextEdit2.getTextRange(), 4, 2);
        Assert.assertEquals((String)"Buffer content", (String)"01yyxx23456789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 0);
        this.tb_assert(simpleTextEdit2.getTextRange(), 2, 0);
    }

    public void testInsert3() throws Exception {
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)0, (int)2, (String)"011");
        SimpleTextEdit simpleTextEdit2 = SimpleTextEdit.createInsert((int)2, (String)"xx");
        SimpleTextEdit simpleTextEdit3 = SimpleTextEdit.createReplace((int)2, (int)2, (String)"2");
        this.fEditor.add((TextEdit)simpleTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit2);
        this.fEditor.add((TextEdit)simpleTextEdit3);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(simpleTextEdit.getTextRange(), 0, 3);
        this.tb_assert(simpleTextEdit2.getTextRange(), 3, 2);
        this.tb_assert(simpleTextEdit3.getTextRange(), 5, 1);
        Assert.assertEquals((String)"Buffer content", (String)"011xx2456789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(simpleTextEdit.getTextRange(), 0, 2);
        this.tb_assert(simpleTextEdit2.getTextRange(), 2, 0);
        this.tb_assert(simpleTextEdit3.getTextRange(), 2, 2);
    }

    public void testInsert4() throws Exception {
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createInsert((int)0, (String)"xx");
        this.fEditor.add((TextEdit)simpleTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer length", (int)12, (int)this.fBuffer.getLength());
        this.tb_assert(simpleTextEdit.getTextRange(), 0, 2);
        Assert.assertEquals((String)"Buffer content", (String)"xx0123456789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(simpleTextEdit.getTextRange(), 0, 0);
    }

    public void testInsert5() throws Exception {
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createInsert((int)10, (String)"xx");
        this.fEditor.add((TextEdit)simpleTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer length", (int)12, (int)this.fBuffer.getLength());
        this.tb_assert(simpleTextEdit.getTextRange(), 10, 2);
        Assert.assertEquals((String)"Buffer content", (String)"0123456789xx", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(simpleTextEdit.getTextRange(), 10, 0);
    }

    public void testDelete1() throws Exception {
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createDelete((int)3, (int)1);
        this.fEditor.add((TextEdit)simpleTextEdit);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(simpleTextEdit.getTextRange(), 3, 0);
        Assert.assertEquals((String)"Buffer content", (String)"012456789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(simpleTextEdit.getTextRange(), 3, 1);
    }

    public void testDelete2() throws Exception {
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createDelete((int)4, (int)1);
        SimpleTextEdit simpleTextEdit2 = SimpleTextEdit.createDelete((int)3, (int)1);
        SimpleTextEdit simpleTextEdit3 = SimpleTextEdit.createDelete((int)5, (int)1);
        this.fEditor.add((TextEdit)simpleTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit2);
        this.fEditor.add((TextEdit)simpleTextEdit3);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(simpleTextEdit.getTextRange(), 3, 0);
        this.tb_assert(simpleTextEdit2.getTextRange(), 3, 0);
        this.tb_assert(simpleTextEdit3.getTextRange(), 3, 0);
        Assert.assertEquals((String)"Buffer content", (String)"0126789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(simpleTextEdit.getTextRange(), 4, 1);
        this.tb_assert(simpleTextEdit2.getTextRange(), 3, 1);
        this.tb_assert(simpleTextEdit3.getTextRange(), 5, 1);
    }

    public void testDelete3() throws Exception {
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createInsert((int)3, (String)"x");
        SimpleTextEdit simpleTextEdit2 = SimpleTextEdit.createDelete((int)3, (int)1);
        this.fEditor.add((TextEdit)simpleTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit2);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(simpleTextEdit.getTextRange(), 3, 1);
        this.tb_assert(simpleTextEdit2.getTextRange(), 4, 0);
        Assert.assertEquals((String)"Buffer content", (String)"012x456789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(simpleTextEdit.getTextRange(), 3, 0);
        this.tb_assert(simpleTextEdit2.getTextRange(), 3, 1);
    }

    public void testMove1() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(2, 2, 5);
        this.fEditor.add((TextEdit)moveTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"0142356789", (String)this.fBuffer.getContent());
        this.tb_assert(moveTextEdit.getTargetRange(), 3, 2);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 0);
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 2);
        this.tb_assert(moveTextEdit.getTargetRange(), 5, 0);
    }

    public void testMove2() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(5, 2, 2);
        this.fEditor.add((TextEdit)moveTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"0156234789", (String)this.fBuffer.getContent());
        this.tb_assert(moveTextEdit.getTargetRange(), 2, 2);
        this.tb_assert(moveTextEdit.getSourceRange(), 7, 0);
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 5, 2);
        this.tb_assert(moveTextEdit.getTargetRange(), 2, 0);
    }

    public void testMove3() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(2, 2, 7);
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)4, (int)1, (String)"x");
        this.fEditor.add((TextEdit)moveTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"01x5623789", (String)this.fBuffer.getContent());
        this.tb_assert(moveTextEdit.getTargetRange(), 5, 2);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 1);
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 2);
        this.tb_assert(moveTextEdit.getTargetRange(), 7, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 4, 1);
    }

    public void testMove4() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(7, 2, 2);
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)5, (int)1, (String)"x");
        this.fEditor.add((TextEdit)simpleTextEdit);
        this.fEditor.add((TextEdit)moveTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"0178234x69", (String)this.fBuffer.getContent());
        this.tb_assert(moveTextEdit.getTargetRange(), 2, 2);
        this.tb_assert(moveTextEdit.getSourceRange(), 9, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 7, 1);
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 7, 2);
        this.tb_assert(moveTextEdit.getTargetRange(), 2, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 5, 1);
    }

    public void testMove5() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(2, 1, 3);
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)2, (int)1, (String)"x");
        this.fEditor.add((TextEdit)moveTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(moveTextEdit.getTargetRange(), 2, 1);
        this.tb_assert(moveTextEdit.getSourceRange(), 3, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 1);
        Assert.assertEquals((String)"Buffer content", (String)"01x3456789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 1);
        this.tb_assert(moveTextEdit.getTargetRange(), 3, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 1);
    }

    public void testMove6() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(2, 1, 2);
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)2, (int)1, (String)"x");
        this.fEditor.add((TextEdit)moveTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(moveTextEdit.getTargetRange(), 2, 1);
        this.tb_assert(moveTextEdit.getSourceRange(), 3, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 1);
        Assert.assertEquals((String)"Buffer content", (String)"01x3456789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 1);
        this.tb_assert(moveTextEdit.getTargetRange(), 3, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 1);
    }

    public void testMove7() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(2, 3, 7);
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)3, (int)1, (String)"x");
        this.fEditor.add((TextEdit)moveTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"01562x4789", (String)this.fBuffer.getContent());
        this.tb_assert(moveTextEdit.getTargetRange(), 4, 3);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 5, 1);
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 3);
        this.tb_assert(moveTextEdit.getTargetRange(), 7, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 3, 1);
    }

    public void testMove8() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(5, 3, 1);
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)6, (int)1, (String)"x");
        this.fEditor.add((TextEdit)simpleTextEdit);
        this.fEditor.add((TextEdit)moveTextEdit);
        Assert.assertTrue((boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"05x7123489", (String)this.fBuffer.getContent());
        this.tb_assert(moveTextEdit.getTargetRange(), 1, 3);
        this.tb_assert(moveTextEdit.getSourceRange(), 8, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 2, 1);
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 5, 3);
        this.tb_assert(moveTextEdit.getTargetRange(), 1, 0);
        this.tb_assert(simpleTextEdit.getTextRange(), 6, 1);
    }

    public void testMove9() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(1, 1, 3);
        MoveTextEdit moveTextEdit2 = new MoveTextEdit(1, 3, 5);
        this.fEditor.add((TextEdit)moveTextEdit);
        this.fEditor.add((TextEdit)moveTextEdit2);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        this.tb_assert(moveTextEdit.getTargetRange(), 3, 1);
        this.tb_assert(moveTextEdit.getSourceRange(), 2, 0);
        this.tb_assert(moveTextEdit2.getTargetRange(), 2, 3);
        this.tb_assert(moveTextEdit2.getSourceRange(), 1, 0);
        Assert.assertEquals((String)"Buffer content", (String)"0421356789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
        this.tb_assert(moveTextEdit.getSourceRange(), 1, 1);
        this.tb_assert(moveTextEdit.getTargetRange(), 3, 0);
        this.tb_assert(moveTextEdit2.getSourceRange(), 1, 3);
        this.tb_assert(moveTextEdit2.getTargetRange(), 5, 0);
    }

    public void testMove10() throws Exception {
        MoveTextEdit moveTextEdit = new MoveTextEdit(2, 2, 8);
        MoveTextEdit moveTextEdit2 = new MoveTextEdit(5, 2, 1);
        this.fEditor.add((TextEdit)moveTextEdit);
        this.fEditor.add((TextEdit)moveTextEdit2);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"0561472389", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
    }

    public void testSwap1() throws Exception {
        SwapTextEdit swapTextEdit = new SwapTextEdit(1, 1, 3, 1);
        this.fEditor.add((MultiTextEdit)swapTextEdit);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"0321456789", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
    }

    public void testSwap2() throws Exception {
        SwapTextEdit swapTextEdit = new SwapTextEdit(1, 1, 3, 1);
        SwapTextEdit swapTextEdit2 = new SwapTextEdit(5, 1, 7, 1);
        this.fEditor.add((MultiTextEdit)swapTextEdit);
        this.fEditor.add((MultiTextEdit)swapTextEdit2);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"0321476589", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
    }

    public void testSwap3() throws Exception {
        SwapTextEdit swapTextEdit = new SwapTextEdit(1, 1, 3, 1);
        SwapTextEdit swapTextEdit2 = new SwapTextEdit(5, 1, 7, 1);
        SwapTextEdit swapTextEdit3 = new SwapTextEdit(1, 3, 5, 3);
        this.fEditor.add((MultiTextEdit)swapTextEdit);
        this.fEditor.add((MultiTextEdit)swapTextEdit2);
        this.fEditor.add((MultiTextEdit)swapTextEdit3);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"0765432189", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
    }

    public void testSwapAndReplace() throws Exception {
        SwapTextEdit swapTextEdit = new SwapTextEdit(1, 3, 5, 3);
        SimpleTextEdit simpleTextEdit = SimpleTextEdit.createReplace((int)6, (int)1, (String)"ab");
        this.fEditor.add((MultiTextEdit)swapTextEdit);
        this.fEditor.add((TextEdit)simpleTextEdit);
        Assert.assertTrue((String)"Can perform edits", (boolean)this.fEditor.canPerformEdits());
        UndoMemento undoMemento = this.fEditor.performEdits(null);
        Assert.assertEquals((String)"Buffer content", (String)"05ab7412389", (String)this.fBuffer.getContent());
        this.doUndo(undoMemento);
    }

    private void doUndo(UndoMemento undoMemento) throws Exception {
        this.fEditor.add(undoMemento);
        this.fEditor.performEdits(null);
        this.assertBufferContent();
    }

    private void tb_assert(TextRange textRange, int n, int n2) {
        Assert.assertEquals((String)"Offset", (int)n, (int)textRange.getOffset());
        Assert.assertEquals((String)"Length", (int)n2, (int)textRange.getLength());
    }

    private void assertBufferContent() {
        Assert.assertEquals((String)"Buffer content restored", (String)"0123456789", (String)this.fBuffer.getContent());
    }
}

