/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;

public class StorageLabelProvider
extends LabelProvider {
    private IEditorRegistry fEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
    private Map fJarImageMap = new HashMap(10);
    private Image fDefaultImage;

    public Image getImage(Object element) {
        if (element instanceof IStorage) {
            return this.getImageForJarEntry((IStorage)element);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IStorage) {
            return ((IStorage)element).getName();
        }
        return super.getText(element);
    }

    public void dispose() {
        if (this.fJarImageMap != null) {
            Iterator each = this.fJarImageMap.values().iterator();
            while (each.hasNext()) {
                Image image = (Image)each.next();
                image.dispose();
            }
            this.fJarImageMap = null;
        }
        if (this.fDefaultImage != null) {
            this.fDefaultImage.dispose();
        }
        this.fDefaultImage = null;
    }

    private Image getImageForJarEntry(IStorage element) {
        if (this.fJarImageMap == null) {
            return this.getDefaultImage();
        }
        if (element == null || element.getName() == null) {
            return this.getDefaultImage();
        }
        String name = element.getName();
        Image image = (Image)this.fJarImageMap.get(name);
        if (image != null) {
            return image;
        }
        IFileEditorMapping[] mappings = this.fEditorRegistry.getFileEditorMappings();
        int i = 0;
        while (i < mappings.length) {
            if (mappings[i].getLabel().equals(name)) break;
            ++i;
        }
        String key = name;
        if (i == mappings.length) {
            IPath path = element.getFullPath();
            if (path == null) {
                return this.getDefaultImage();
            }
            key = path.getFileExtension();
            if (key == null) {
                return this.getDefaultImage();
            }
            image = (Image)this.fJarImageMap.get(key);
            if (image != null) {
                return image;
            }
        }
        ImageDescriptor desc = this.fEditorRegistry.getImageDescriptor(name);
        image = desc.createImage();
        this.fJarImageMap.put(key, image);
        return image;
    }

    private Image getDefaultImage() {
        if (this.fDefaultImage == null) {
            this.fDefaultImage = this.fEditorRegistry.getImageDescriptor(null).createImage();
        }
        return this.fDefaultImage;
    }
}

